/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrKeywordAndDeclarationHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    private final GroovyFileBase myFile;
    private List<HighlightInfo> toHighlight;

    public GrKeywordAndDeclarationHighlighter(GroovyFileBase file, Document document) {
        super(file.getProject(), document);
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        final ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                IElementType tokenType = element.getNode().getElementType();
                if (TokenSets.KEYWORDS.contains(tokenType)) {
                    if (GrKeywordAndDeclarationHighlighter.highlightKeyword(element, tokenType)) {
                        this.addInfo(element, GroovySyntaxHighlighter.KEYWORD);
                    }
                } else if (!(element instanceof GroovyPsiElement) && !(element instanceof PsiErrorElement)) {
                    TextAttributesKey attribute = GrKeywordAndDeclarationHighlighter.getDeclarationAttribute(element);
                    if (attribute != null) {
                        this.addInfo(element, attribute);
                    }
                } else {
                    super.visitElement(element);
                }
            }

            private void addInfo(@NotNull PsiElement element, @NotNull TextAttributesKey attribute) {
                HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(element);
                HighlightInfo info = builder.needsUpdateOnTyping(false).textAttributes(attribute).create();
                if (info != null) {
                    result.add(info);
                }
            }
        });
        this.toHighlight = result;
    }

    private static boolean highlightKeyword(PsiElement element, IElementType token) {
        PsiElement parent = element.getParent();
        if (parent instanceof GrArgumentLabel) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, GrCodeReferenceElement.class) != null) {
            if (token == GroovyTokenTypes.kDEF || token == GroovyTokenTypes.kIN || token == GroovyTokenTypes.kAS) {
                return false;
            }
        } else {
            if (token == GroovyTokenTypes.kDEF && element.getParent() instanceof GrAnnotationNameValuePair) {
                return false;
            }
            if (parent instanceof GrReferenceExpression && element == ((GrReferenceExpression)parent).getReferenceNameElement()) {
                if (token == GroovyTokenTypes.kSUPER && ((GrReferenceExpression)parent).getQualifier() == null) {
                    return true;
                }
                return token == GroovyTokenTypes.kTHIS && ((GrReferenceExpression)parent).getQualifier() == null;
            }
        }
        return true;
    }

    public void doApplyInformationToEditor() {
        if (this.toHighlight == null || this.myDocument == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), this.toHighlight, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @Nullable
    private static TextAttributesKey getDeclarationAttribute(PsiElement element) {
        if (element.getParent() instanceof GrAnnotation && element.getNode().getElementType() == GroovyTokenTypes.mAT) {
            return GroovySyntaxHighlighter.ANNOTATION;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrNamedElement) || ((GrNamedElement)parent).getNameIdentifierGroovy() != element) {
            return null;
        }
        if (PsiUtil.isLocalVariable(parent) || parent instanceof GrParameter) {
            return null;
        }
        return GrHighlightUtil.getDeclarationHighlightingAttribute(parent, null);
    }
}

