/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;

public class GrConcatenationInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        assert (context instanceof GrLiteral);
        GrLiteral literal = (GrLiteral)context;
        GrConcatenationInjector.processInPlace(registrar, literal);
    }

    public static void processInPlace(MultiHostRegistrar registrar, GrLiteral literal) {
        BaseInjection injection = GrConcatenationInjector.findLanguageParams(literal, Configuration.getInstance());
        if (injection != null) {
            LanguageInjectionSupport support = InjectorUtils.findInjectionSupport((String)"groovy");
            InjectorUtils.registerInjectionSimple((PsiLanguageInjectionHost)literal, (BaseInjection)injection, (LanguageInjectionSupport)support, (MultiHostRegistrar)registrar);
        }
    }

    public static BaseInjection findLanguageParams(PsiElement place, Configuration configuration) {
        PsiElement parent = place.getParent();
        if (parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getRValue() == place) {
            PsiElement resolved;
            GrExpression lvalue = ((GrAssignmentExpression)parent).getLValue();
            if (lvalue instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)lvalue).resolve()) instanceof PsiModifierListOwner) {
                return GrConcatenationInjector.getLanguageParams((PsiModifierListOwner)resolved, configuration);
            }
        } else {
            Map<GrExpression, Pair<PsiParameter, PsiType>> map;
            GrCall call;
            GroovyResolveResult result;
            PsiElement pparent;
            if (parent instanceof GrVariable) {
                return GrConcatenationInjector.getLanguageParams((PsiModifierListOwner)parent, configuration);
            }
            if (parent instanceof GrArgumentList && (pparent = parent.getParent()) instanceof GrCall && (result = (call = (GrCall)pparent).advancedResolve()).getElement() != null && (map = GrClosureSignatureUtil.mapArgumentsToParameters(result, place, false, false, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments())) != null) {
                Pair<PsiParameter, PsiType> pair = map.get(place);
                return GrConcatenationInjector.getLanguageParams((PsiModifierListOwner)pair.first, configuration);
            }
        }
        return null;
    }

    @Nullable
    private static BaseInjection getLanguageParams(PsiModifierListOwner annotationOwner, Configuration configuration) {
        Pair pair = Configuration.getInstance().getAdvancedConfiguration().getLanguageAnnotationPair();
        PsiAnnotation[] annotations = GrConcatenationInjector.getAnnotationFrom(annotationOwner, (Pair<String, ? extends Set<String>>)pair, true, true);
        if (annotations.length > 0) {
            String prefix = StringUtil.notNullize((String)AnnotationUtilEx.calcAnnotationValue((PsiAnnotation[])annotations, (String)"prefix"));
            String suffix = StringUtil.notNullize((String)AnnotationUtilEx.calcAnnotationValue((PsiAnnotation[])annotations, (String)"suffix"));
            String id = StringUtil.notNullize((String)AnnotationUtilEx.calcAnnotationValue((PsiAnnotation[])annotations, (String)"value"));
            if (!StringUtil.isEmpty((String)id)) {
                BaseInjection injection = new BaseInjection("groovy");
                injection.setPrefix(prefix);
                injection.setSuffix(suffix);
                injection.setInjectedLanguageId(id);
                return injection;
            }
        }
        if (annotationOwner instanceof PsiParameter && annotationOwner.getParent() instanceof PsiParameterList && annotationOwner.getParent().getParent() instanceof PsiMethod) {
            List injections = configuration.getInjections("java");
            for (BaseInjection injection : injections) {
                if (!injection.acceptsPsiElement((PsiElement)annotationOwner)) continue;
                return injection;
            }
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation[] getAnnotationFrom(PsiModifierListOwner owner, Pair<String, ? extends Set<String>> annotationName, boolean allowIndirect, boolean inHierarchy) {
        if (!GrConcatenationInjector.isLanguageAnnotationTargetGroovy(owner)) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        return AnnotationUtilEx.getAnnotationsFromImpl((PsiModifierListOwner)owner, annotationName, (boolean)allowIndirect, (boolean)inHierarchy);
    }

    private static boolean isLanguageAnnotationTargetGroovy(PsiModifierListOwner owner) {
        return owner instanceof GrMethod && ((GrMethod)owner).getReturnTypeElementGroovy() == null || owner instanceof GrVariable && ((GrVariable)owner).getTypeElementGroovy() == null || PsiUtilEx.isLanguageAnnotationTarget((PsiModifierListOwner)owner);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return Collections.singletonList(GrLiteral.class);
    }
}

