/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<Class> myExtraProjectModelClasses = new HashSet<Class>();
    private final boolean myIsPreviewMode;

    public ProjectImportAction(boolean isPreviewMode) {
        this.myIsPreviewMode = isPreviewMode;
    }

    public void addExtraProjectModelClasses(@NotNull Set<Class> projectModelClasses) {
        this.myExtraProjectModelClasses.addAll(projectModelClasses);
    }

    @Nullable
    public AllModels execute(BuildController controller) {
        IdeaProject ideaProject;
        ProjectImportAction.configureAdditionalTypes(controller);
        IdeaProject ideaProject2 = ideaProject = this.myIsPreviewMode ? (IdeaProject)controller.getModel(BasicIdeaProject.class) : (IdeaProject)controller.getModel(IdeaProject.class);
        if (ideaProject == null || ideaProject.getModules().isEmpty()) {
            return null;
        }
        AllModels allModels = new AllModels(ideaProject);
        this.addExtraProject(controller, allModels, null);
        for (IdeaModule module : ideaProject.getModules()) {
            this.addExtraProject(controller, allModels, module);
        }
        return allModels;
    }

    private static void configureAdditionalTypes(BuildController controller) {
        try {
            Field adapterField = controller.getClass().getDeclaredField("adapter");
            adapterField.setAccessible(true);
            ProtocolToModelAdapter adapter = (ProtocolToModelAdapter)adapterField.get(controller);
            Field typeProviderField = adapter.getClass().getDeclaredField("targetTypeProvider");
            typeProviderField.setAccessible(true);
            TargetTypeProvider typeProvider = (TargetTypeProvider)typeProviderField.get(adapter);
            Field targetTypesField = typeProvider.getClass().getDeclaredField("configuredTargetTypes");
            targetTypesField.setAccessible(true);
            Map targetTypes = (Map)targetTypesField.get(typeProvider);
            targetTypes.put(ExternalProjectDependency.class.getCanonicalName(), ExternalProjectDependency.class);
            targetTypes.put(ExternalLibraryDependency.class.getCanonicalName(), ExternalLibraryDependency.class);
            targetTypes.put(FileCollectionDependency.class.getCanonicalName(), FileCollectionDependency.class);
            targetTypes.put(UnresolvedExternalDependency.class.getCanonicalName(), UnresolvedExternalDependency.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addExtraProject(@NotNull BuildController controller, @NotNull AllModels allModels, @Nullable IdeaModule model) {
        for (Class aClass : this.myExtraProjectModelClasses) {
            try {
                Object extraProject = controller.findModel((Model)model, aClass);
                if (extraProject == null) continue;
                allModels.addExtraProject(extraProject, aClass, model);
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) continue;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    public static class AllModels
    extends ModelsHolder<IdeaProject, IdeaModule> {
        public AllModels(@NotNull IdeaProject ideaProject) {
            super(ideaProject);
        }

        @NotNull
        public IdeaProject getIdeaProject() {
            return (IdeaProject)this.getRootModel();
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.getExtraProject(BuildEnvironment.class);
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            if (buildEnvironment != null) {
                this.addExtraProject(buildEnvironment, BuildEnvironment.class);
            }
        }

        @Override
        @NotNull
        protected String extractMapKey(Class modelClazz, @Nullable IdeaModule module) {
            return modelClazz.getName() + '@' + (module != null ? module.getGradleProject().getPath() : "root" + ((IdeaProject)this.getRootModel()).getName().hashCode());
        }
    }
}

