/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.store;

import android.databinding.InverseBindingListener;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class SetterStore {
    private static SetterStore sStore;
    private final IntermediateV2 mStore;
    private final ModelAnalyzer mClassAnalyzer;
    private HashMap<String, List<String>> mInstanceAdapters;
    private final HashSet<String> mInverseEventAttributes = new HashSet();
    private Comparator<MultiAttributeSetter> COMPARE_MULTI_ATTRIBUTE_SETTERS = new Comparator<MultiAttributeSetter>(){

        @Override
        public int compare(MultiAttributeSetter o1, MultiAttributeSetter o2) {
            ModelClass view2;
            if (o1.attributes.length != o2.attributes.length) {
                return o2.attributes.length - o1.attributes.length;
            }
            ModelClass view1 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o1).mKey.viewType, null).erasure();
            if (!view1.equals(view2 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o2).mKey.viewType, null).erasure())) {
                if (view1.isAssignableFrom(view2)) {
                    return 1;
                }
                return -1;
            }
            if (!((Object)((MultiAttributeSetter)o1).mKey.attributeIndices.keySet()).equals(((MultiAttributeSetter)o2).mKey.attributeIndices.keySet())) {
                Iterator<String> o1Keys = ((MultiAttributeSetter)o1).mKey.attributeIndices.keySet().iterator();
                Iterator<String> o2Keys = ((MultiAttributeSetter)o2).mKey.attributeIndices.keySet().iterator();
                while (o1Keys.hasNext()) {
                    String key2;
                    String key1 = o1Keys.next();
                    int compare = key1.compareTo(key2 = o2Keys.next());
                    if (compare == 0) continue;
                    return compare;
                }
                Preconditions.check((boolean)false, (String)"The sets don't match! That means the keys shouldn't match also", (Object[])new Object[0]);
            }
            for (String attribute : ((MultiAttributeSetter)o1).mKey.attributeIndices.keySet()) {
                ModelClass type2;
                int index1 = ((MultiAttributeSetter)o1).mKey.attributeIndices.get(attribute);
                int index2 = ((MultiAttributeSetter)o2).mKey.attributeIndices.get(attribute);
                ModelClass type1 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o1).mKey.parameterTypes[index1], null);
                if (type1.equals(type2 = SetterStore.this.mClassAnalyzer.findClass(((MultiAttributeSetter)o2).mKey.parameterTypes[index2], null))) continue;
                if (o1.mCasts[index1] != null) {
                    if (o2.mCasts[index2] != null) continue;
                    return 1;
                }
                if (o2.mCasts[index2] != null) {
                    return -1;
                }
                if (o1.mConverters[index1] != null) {
                    if (o2.mConverters[index2] != null) continue;
                    return 1;
                }
                if (o2.mConverters[index2] != null) {
                    return -1;
                }
                if (type1.isPrimitive()) {
                    if (type2.isPrimitive()) {
                        int type1ConversionLevel = ModelMethod.getImplicitConversionLevel(type1);
                        int type2ConversionLevel = ModelMethod.getImplicitConversionLevel(type2);
                        return type2ConversionLevel - type1ConversionLevel;
                    }
                    return -1;
                }
                if (type2.isPrimitive()) {
                    return 1;
                }
                if (type1.isAssignableFrom(type2)) {
                    return 1;
                }
                if (!type2.isAssignableFrom(type1)) continue;
                return -1;
            }
            return 0;
        }
    };

    private SetterStore(ModelAnalyzer modelAnalyzer, IntermediateV2 store) {
        this.mClassAnalyzer = modelAnalyzer;
        this.mStore = store;
        for (HashMap<AccessorKey, InverseDescription> hashMap : this.mStore.inverseAdapters.values()) {
            for (InverseDescription inverseDescription : hashMap.values()) {
                this.mInverseEventAttributes.add(inverseDescription.event);
            }
        }
        for (HashMap<Object, InverseDescription> hashMap : this.mStore.inverseMethods.values()) {
            for (InverseDescription inverseDescription : hashMap.values()) {
                this.mInverseEventAttributes.add(inverseDescription.event);
            }
        }
    }

    public static SetterStore get(ModelAnalyzer modelAnalyzer) {
        if (sStore == null) {
            sStore = SetterStore.load(modelAnalyzer);
        }
        return sStore;
    }

    private static SetterStore load(ModelAnalyzer modelAnalyzer) {
        IntermediateV2 store = new IntermediateV2();
        List<Intermediate> previousStores = GenerationalClassUtil.loadObjects(GenerationalClassUtil.ExtensionFilter.SETTER_STORE);
        for (Intermediate intermediate : previousStores) {
            SetterStore.merge(store, intermediate);
        }
        return new SetterStore(modelAnalyzer, store);
    }

    public void addRenamedMethod(String attribute, String declaringClass, String method, TypeElement declaredOn) {
        HashMap<String, MethodDescription> renamed = (HashMap<String, MethodDescription>)this.mStore.renamedMethods.get(attribute = SetterStore.stripNamespace(attribute));
        if (renamed == null) {
            renamed = new HashMap<String, MethodDescription>();
            this.mStore.renamedMethods.put(attribute, renamed);
        }
        MethodDescription methodDescription = new MethodDescription(declaredOn.getQualifiedName().toString(), method);
        L.d((String)"STORE addmethod desc %s", (Object[])new Object[]{methodDescription});
        renamed.put(declaringClass, methodDescription);
    }

    public void addInverseMethod(String attribute, String event, String declaringClass, String method, TypeElement declaredOn) {
        attribute = SetterStore.stripNamespace(attribute);
        event = SetterStore.stripNamespace(event);
        HashMap<String, InverseDescription> inverseMethods = this.mStore.inverseMethods.get(attribute);
        if (inverseMethods == null) {
            inverseMethods = new HashMap();
            this.mStore.inverseMethods.put(attribute, inverseMethods);
        }
        InverseDescription methodDescription = new InverseDescription(declaredOn.getQualifiedName().toString(), method, event);
        L.d((String)"STORE addInverseMethod desc %s", (Object[])new Object[]{methodDescription});
        inverseMethods.put(declaringClass, methodDescription);
    }

    public void addBindingAdapter(ProcessingEnvironment processingEnv, String attribute, ExecutableElement bindingMethod, boolean takesComponent) {
        TypeMirror parameterType;
        String value;
        int viewIndex;
        List<? extends VariableElement> parameters;
        TypeMirror viewType;
        String view;
        AccessorKey key;
        attribute = SetterStore.stripNamespace(attribute);
        L.d((String)"STORE addBindingAdapter %s %s", (Object[])new Object[]{attribute, bindingMethod});
        HashMap<AccessorKey, MethodDescription> adapters = (HashMap<AccessorKey, MethodDescription>)this.mStore.adapterMethods.get(attribute);
        if (adapters == null) {
            adapters = new HashMap<AccessorKey, MethodDescription>();
            this.mStore.adapterMethods.put(attribute, adapters);
        }
        if (adapters.containsKey(key = new AccessorKey(view = SetterStore.getQualifiedName(viewType = SetterStore.eraseType(processingEnv, (parameters = bindingMethod.getParameters()).get(viewIndex = takesComponent ? 1 : 0).asType())), value = SetterStore.getQualifiedName(parameterType = SetterStore.eraseType(processingEnv, parameters.get(viewIndex + 1).asType()))))) {
            throw new IllegalArgumentException("Already exists!");
        }
        adapters.put(key, new MethodDescription(bindingMethod, 1, takesComponent));
    }

    public void addInverseAdapter(ProcessingEnvironment processingEnv, String attribute, String event, ExecutableElement bindingMethod, boolean takesComponent) {
        TypeMirror returnType;
        String value;
        int viewIndex;
        List<? extends VariableElement> parameters;
        TypeMirror viewType;
        String view;
        AccessorKey key;
        attribute = SetterStore.stripNamespace(attribute);
        event = SetterStore.stripNamespace(event);
        L.d((String)"STORE addInverseAdapter %s %s", (Object[])new Object[]{attribute, bindingMethod});
        HashMap<AccessorKey, InverseDescription> adapters = this.mStore.inverseAdapters.get(attribute);
        if (adapters == null) {
            adapters = new HashMap();
            this.mStore.inverseAdapters.put(attribute, adapters);
        }
        if (adapters.containsKey(key = new AccessorKey(view = SetterStore.getQualifiedName(viewType = SetterStore.eraseType(processingEnv, (parameters = bindingMethod.getParameters()).get(viewIndex = takesComponent ? 1 : 0).asType())), value = SetterStore.getQualifiedName(returnType = SetterStore.eraseType(processingEnv, bindingMethod.getReturnType()))))) {
            throw new IllegalArgumentException("Already exists!");
        }
        adapters.put(key, new InverseDescription(bindingMethod, event, takesComponent));
    }

    private static TypeMirror eraseType(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        if (SetterStore.hasTypeVar(typeMirror)) {
            return processingEnv.getTypeUtils().erasure(typeMirror);
        }
        return typeMirror;
    }

    private static ModelClass eraseType(ModelClass modelClass) {
        if (SetterStore.hasTypeVar(modelClass)) {
            return modelClass.erasure();
        }
        return modelClass;
    }

    private static boolean hasTypeVar(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind == TypeKind.TYPEVAR) {
            return true;
        }
        if (kind == TypeKind.ARRAY) {
            return SetterStore.hasTypeVar(((ArrayType)typeMirror).getComponentType());
        }
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments == null || typeArguments.isEmpty()) {
                return false;
            }
            for (TypeMirror typeMirror2 : typeArguments) {
                if (!SetterStore.hasTypeVar(typeMirror2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean hasTypeVar(ModelClass type) {
        if (type.isTypeVar()) {
            return true;
        }
        if (type.isArray()) {
            return SetterStore.hasTypeVar(type.getComponentType());
        }
        List<ModelClass> typeArguments = type.getTypeArguments();
        if (typeArguments == null) {
            return false;
        }
        for (ModelClass arg : typeArguments) {
            if (!SetterStore.hasTypeVar(arg)) continue;
            return true;
        }
        return false;
    }

    public void addBindingAdapter(ProcessingEnvironment processingEnv, String[] attributes, ExecutableElement bindingMethod, boolean takesComponent, boolean requireAll) {
        L.d((String)"STORE add multi-value BindingAdapter %d %s", (Object[])new Object[]{attributes.length, bindingMethod});
        MultiValueAdapterKey key = new MultiValueAdapterKey(processingEnv, bindingMethod, attributes, takesComponent, requireAll);
        MethodDescription methodDescription = new MethodDescription(bindingMethod, attributes.length, takesComponent);
        this.mStore.multiValueAdapters.put(key, methodDescription);
    }

    private static String[] stripAttributes(String[] attributes) {
        String[] strippedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] == null) continue;
            strippedAttributes[i] = SetterStore.stripNamespace(attributes[i]);
        }
        return strippedAttributes;
    }

    public void addUntaggableTypes(String[] typeNames, TypeElement declaredOn) {
        L.d((String)"STORE addUntaggableTypes %s %s", (Object[])new Object[]{Arrays.toString(typeNames), declaredOn});
        String declaredType = declaredOn.getQualifiedName().toString();
        for (String type : typeNames) {
            this.mStore.untaggableTypes.put(type, declaredType);
        }
    }

    private static String getQualifiedName(TypeMirror type) {
        TypeKind kind = type.getKind();
        if (kind == TypeKind.ARRAY) {
            return SetterStore.getQualifiedName(((ArrayType)type).getComponentType()) + "[]";
        }
        if (kind == TypeKind.DECLARED && SetterStore.isIncompleteType(type)) {
            DeclaredType declaredType = (DeclaredType)type;
            return declaredType.asElement().toString();
        }
        return ((Object)type).toString();
    }

    private static boolean isIncompleteType(TypeMirror type) {
        TypeKind kind = type.getKind();
        if (kind == TypeKind.TYPEVAR || kind == TypeKind.WILDCARD) {
            return true;
        }
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
            if (typeArgs == null) {
                return false;
            }
            for (TypeMirror typeMirror : typeArgs) {
                if (!SetterStore.isIncompleteType(typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public void addConversionMethod(ExecutableElement conversionMethod) {
        L.d((String)"STORE addConversionMethod %s", (Object[])new Object[]{conversionMethod});
        List<? extends VariableElement> parameters = conversionMethod.getParameters();
        String fromType = SetterStore.getQualifiedName(parameters.get(0).asType());
        String toType = SetterStore.getQualifiedName(conversionMethod.getReturnType());
        MethodDescription methodDescription = new MethodDescription(conversionMethod, 1, false);
        HashMap<String, MethodDescription> convertTo = (HashMap<String, MethodDescription>)this.mStore.conversionMethods.get(fromType);
        if (convertTo == null) {
            convertTo = new HashMap<String, MethodDescription>();
            this.mStore.conversionMethods.put(fromType, convertTo);
        }
        convertTo.put(toType, methodDescription);
    }

    public void clear(Set<String> classes) {
        ArrayList<AccessorKey> removedAccessorKeys = new ArrayList<AccessorKey>();
        for (HashMap adapters : this.mStore.adapterMethods.values()) {
            for (AccessorKey key : adapters.keySet()) {
                MethodDescription description = (MethodDescription)adapters.get(key);
                if (!classes.contains(description.type)) continue;
                removedAccessorKeys.add(key);
            }
            SetterStore.removeFromMap(adapters, removedAccessorKeys);
        }
        ArrayList<String> removedRenamed = new ArrayList<String>();
        for (HashMap renamed : this.mStore.renamedMethods.values()) {
            for (String key : renamed.keySet()) {
                if (!classes.contains(((MethodDescription)renamed.get((Object)key)).type)) continue;
                removedRenamed.add(key);
            }
            SetterStore.removeFromMap(renamed, removedRenamed);
        }
        ArrayList<String> removedConversions = new ArrayList<String>();
        for (HashMap convertTos : this.mStore.conversionMethods.values()) {
            for (String toType : convertTos.keySet()) {
                MethodDescription methodDescription = (MethodDescription)convertTos.get(toType);
                if (!classes.contains(methodDescription.type)) continue;
                removedConversions.add(toType);
            }
            SetterStore.removeFromMap(convertTos, removedConversions);
        }
        ArrayList<String> removedUntaggable = new ArrayList<String>();
        for (String typeName : this.mStore.untaggableTypes.keySet()) {
            if (!classes.contains(this.mStore.untaggableTypes.get(typeName))) continue;
            removedUntaggable.add(typeName);
        }
        SetterStore.removeFromMap(this.mStore.untaggableTypes, removedUntaggable);
    }

    private static <K, V> void removeFromMap(Map<K, V> map, List<K> keys) {
        for (K key : keys) {
            map.remove(key);
        }
        keys.clear();
    }

    public void write(String projectPackage, ProcessingEnvironment processingEnvironment) throws IOException {
        GenerationalClassUtil.writeIntermediateFile(processingEnvironment, projectPackage, projectPackage + GenerationalClassUtil.ExtensionFilter.SETTER_STORE.getExtension(), this.mStore);
    }

    private static String stripNamespace(String attribute) {
        int colon;
        if (!attribute.startsWith("android:") && (colon = attribute.indexOf(58)) >= 0) {
            attribute = attribute.substring(colon + 1);
        }
        return attribute;
    }

    public boolean isTwoWayEventAttribute(String attribute) {
        attribute = SetterStore.stripNamespace(attribute);
        return this.mInverseEventAttributes.contains(attribute);
    }

    public List<MultiAttributeSetter> getMultiAttributeSetterCalls(String[] attributes, ModelClass viewType, ModelClass[] valueType) {
        attributes = SetterStore.stripAttributes(attributes);
        ArrayList<MultiAttributeSetter> calls = new ArrayList<MultiAttributeSetter>();
        if (viewType != null && viewType.isGeneric()) {
            List<ModelClass> viewGenerics = viewType.getTypeArguments();
            for (int i = 0; i < valueType.length; ++i) {
                valueType[i] = SetterStore.eraseType(valueType[i], viewGenerics);
            }
            viewType = viewType.erasure();
        }
        ArrayList<MultiAttributeSetter> matching = this.getMatchingMultiAttributeSetters(attributes, viewType, valueType);
        Collections.sort(matching, this.COMPARE_MULTI_ATTRIBUTE_SETTERS);
        while (!matching.isEmpty()) {
            MultiAttributeSetter bestMatch = matching.get(0);
            calls.add(bestMatch);
            SetterStore.removeConsumedAttributes(matching, bestMatch.attributes);
        }
        return calls;
    }

    private static String simpleName(String className) {
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex < 0) {
            return className;
        }
        return className.substring(dotIndex + 1);
    }

    public Map<String, List<String>> getComponentBindingAdapters() {
        this.ensureInstanceAdapters();
        return this.mInstanceAdapters;
    }

    private String getBindingAdapterCall(String className) {
        this.ensureInstanceAdapters();
        String simpleName = SetterStore.simpleName(className);
        List<String> adapters = this.mInstanceAdapters.get(simpleName);
        if (adapters.size() == 1) {
            return "get" + simpleName + "()";
        }
        int index = adapters.indexOf(className) + 1;
        return "get" + simpleName + index + "()";
    }

    private void ensureInstanceAdapters() {
        if (this.mInstanceAdapters == null) {
            HashSet<String> adapters = new HashSet<String>();
            for (HashMap hashMap : this.mStore.adapterMethods.values()) {
                for (MethodDescription method : hashMap.values()) {
                    if (method.isStatic) continue;
                    adapters.add(method.type);
                }
            }
            for (MethodDescription methodDescription : this.mStore.multiValueAdapters.values()) {
                if (methodDescription.isStatic) continue;
                adapters.add(methodDescription.type);
            }
            for (HashMap hashMap : this.mStore.inverseAdapters.values()) {
                for (MethodDescription method : hashMap.values()) {
                    if (((InverseDescription)method).isStatic) continue;
                    adapters.add(((InverseDescription)method).type);
                }
            }
            this.mInstanceAdapters = new HashMap();
            for (String string : adapters) {
                String simpleName = SetterStore.simpleName(string);
                List<String> list = this.mInstanceAdapters.get(simpleName);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.mInstanceAdapters.put(simpleName, list);
                }
                list.add(string);
            }
            for (List list : this.mInstanceAdapters.values()) {
                if (list.size() <= 1) continue;
                Collections.sort(list);
            }
        }
    }

    private static void removeConsumedAttributes(ArrayList<MultiAttributeSetter> matching, String[] attributes) {
        for (int i = matching.size() - 1; i >= 0; --i) {
            MultiAttributeSetter setter = matching.get(i);
            boolean found = false;
            for (String attribute : attributes) {
                if (!SetterStore.isInArray(attribute, setter.attributes)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            matching.remove(i);
        }
    }

    private static boolean isInArray(String str, String[] array) {
        for (String value : array) {
            if (!value.equals(str)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<MultiAttributeSetter> getMatchingMultiAttributeSetters(String[] attributes, ModelClass viewType, ModelClass[] valueType) {
        ArrayList<MultiAttributeSetter> setters = new ArrayList<MultiAttributeSetter>();
        for (MultiValueAdapterKey adapter : this.mStore.multiValueAdapters.keySet()) {
            MethodDescription method;
            MultiAttributeSetter setter;
            if (adapter.requireAll && adapter.attributes.length > attributes.length) continue;
            ModelClass viewClass = this.mClassAnalyzer.findClass(adapter.viewType, null);
            if (viewClass.isGeneric()) {
                viewClass = viewClass.erasure();
            }
            if (!viewClass.isAssignableFrom(viewType) || (setter = this.createMultiAttributeSetter(method = (MethodDescription)this.mStore.multiValueAdapters.get(adapter), attributes, valueType, adapter)) == null) continue;
            setters.add(setter);
        }
        return setters;
    }

    private MultiAttributeSetter createMultiAttributeSetter(MethodDescription method, String[] allAttributes, ModelClass[] attributeValues, MultiValueAdapterKey adapter) {
        int matchingAttributes = 0;
        String[] casts = new String[adapter.attributes.length];
        MethodDescription[] conversions = new MethodDescription[adapter.attributes.length];
        boolean[] supplied = new boolean[adapter.attributes.length];
        for (int i = 0; i < allAttributes.length; ++i) {
            ModelClass attributeType;
            Integer index = adapter.attributeIndices.get(allAttributes[i]);
            if (index == null) continue;
            supplied[index.intValue()] = true;
            ++matchingAttributes;
            String parameterTypeStr = adapter.parameterTypes[index];
            ModelClass parameterType = SetterStore.eraseType(this.mClassAnalyzer.findClass(parameterTypeStr, null));
            if (parameterType.isAssignableFrom(attributeType = attributeValues[i]) || ModelMethod.isBoxingConversion(parameterType, attributeType) || ModelMethod.isImplicitConversion(attributeType, parameterType)) continue;
            conversions[index.intValue()] = this.getConversionMethod(attributeType, parameterType, null);
            if (conversions[index] != null) continue;
            if (attributeType.isObject()) {
                casts[index.intValue()] = parameterTypeStr;
                continue;
            }
            return null;
        }
        if (adapter.requireAll && matchingAttributes != adapter.attributes.length || matchingAttributes == 0) {
            return null;
        }
        return new MultiAttributeSetter(adapter, supplied, method, conversions, casts);
    }

    public SetterCall getSetterCall(String attribute, ModelClass viewType, ModelClass valueType, Map<String, String> imports) {
        attribute = SetterStore.stripNamespace(attribute);
        SetterCall setterCall = null;
        MethodDescription conversionMethod = null;
        if (viewType != null) {
            viewType = viewType.erasure();
            HashMap adapters = (HashMap)this.mStore.adapterMethods.get(attribute);
            ModelMethod bestSetterMethod = this.getBestSetter(viewType, valueType, attribute, imports);
            ModelClass bestViewType = null;
            ModelClass bestValueType = null;
            if (bestSetterMethod != null) {
                bestViewType = bestSetterMethod.getDeclaringClass();
                bestValueType = bestSetterMethod.getParameterTypes()[0];
                setterCall = new ModelMethodSetter(bestSetterMethod);
            }
            if (adapters != null) {
                for (AccessorKey key : adapters.keySet()) {
                    try {
                        ModelClass adapterViewType = this.mClassAnalyzer.findClass(key.viewType, imports).erasure();
                        if (adapterViewType == null || !adapterViewType.isAssignableFrom(viewType)) continue;
                        try {
                            L.d((String)"setter parameter type is %s", (Object[])new Object[]{key.valueType});
                            ModelClass adapterValueType = SetterStore.eraseType(this.mClassAnalyzer.findClass(key.valueType, imports));
                            L.d((String)"setter %s takes type %s, compared to %s", (Object[])new Object[]{((MethodDescription)adapters.get((Object)key)).method, adapterValueType.toJavaCode(), valueType.toJavaCode()});
                            boolean isBetterView = bestViewType == null || bestViewType.isAssignableFrom(adapterViewType);
                            if (!this.isBetterParameter(valueType, adapterValueType, bestValueType, isBetterView, imports)) continue;
                            bestViewType = adapterViewType;
                            bestValueType = adapterValueType;
                            MethodDescription adapter = (MethodDescription)adapters.get(key);
                            setterCall = new AdapterSetter(adapter, adapterValueType);
                        }
                        catch (Exception e) {
                            L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.valueType});
                        }
                    }
                    catch (Exception e) {
                        L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.viewType});
                    }
                }
            }
            conversionMethod = this.getConversionMethod(valueType, bestValueType, imports);
            if (valueType.isObject() && setterCall != null && bestValueType.isNullable()) {
                setterCall.setCast(bestValueType);
            }
        }
        if (setterCall == null) {
            if (viewType != null && !viewType.isViewDataBinding()) {
                return null;
            }
            setterCall = new DummySetter(SetterStore.getDefaultSetter(attribute));
        }
        setterCall.setConverter(conversionMethod);
        return setterCall;
    }

    public BindingGetterCall getGetterCall(String attribute, ModelClass viewType, ModelClass valueType, Map<String, String> imports) {
        if (viewType == null) {
            return null;
        }
        if (viewType.isViewDataBinding()) {
            return new ViewDataBindingGetterCall(viewType, attribute);
        }
        attribute = SetterStore.stripNamespace(attribute);
        viewType = viewType.erasure();
        InverseMethod bestMethod = this.getBestGetter(viewType, valueType, attribute, imports);
        HashMap<AccessorKey, InverseDescription> adapters = this.mStore.inverseAdapters.get(attribute);
        if (adapters != null) {
            for (AccessorKey key : adapters.keySet()) {
                try {
                    ModelClass adapterViewType = this.mClassAnalyzer.findClass(key.viewType, imports).erasure();
                    if (adapterViewType == null || !adapterViewType.isAssignableFrom(viewType)) continue;
                    try {
                        boolean isBetterView;
                        L.d((String)"getter return type is %s", (Object[])new Object[]{key.valueType});
                        ModelClass adapterValueType = SetterStore.eraseType(this.mClassAnalyzer.findClass(key.valueType, imports));
                        L.d((String)"getter %s returns type %s, compared to %s", (Object[])new Object[]{adapters.get((Object)key).method, adapterValueType.toJavaCode(), valueType});
                        boolean bl = isBetterView = bestMethod.viewType == null || bestMethod.viewType.isAssignableFrom(adapterViewType);
                        if (valueType != null && !this.isBetterParameter(adapterValueType, valueType, bestMethod.returnType, isBetterView, imports)) continue;
                        bestMethod.viewType = adapterViewType;
                        bestMethod.returnType = adapterValueType;
                        InverseDescription inverseDescription = adapters.get(key);
                        ModelClass listenerType = ModelAnalyzer.getInstance().findClass(InverseBindingListener.class);
                        SetterCall eventCall = this.getSetterCall(inverseDescription.event, viewType, listenerType, imports);
                        if (eventCall == null) {
                            List<MultiAttributeSetter> setters = this.getMultiAttributeSetterCalls(new String[]{inverseDescription.event}, viewType, new ModelClass[]{listenerType});
                            if (setters.size() != 1) {
                                L.e((String)"Could not find event '%s' on View type '%s'", (Object[])new Object[]{inverseDescription.event, viewType.getCanonicalName()});
                                continue;
                            }
                            bestMethod.call = new AdapterGetter(inverseDescription, setters.get(0), key.valueType);
                            continue;
                        }
                        bestMethod.call = new AdapterGetter(inverseDescription, eventCall, key.valueType);
                    }
                    catch (Exception e) {
                        L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.valueType});
                    }
                }
                catch (Exception e) {
                    L.e((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{key.viewType});
                }
            }
        }
        return bestMethod.call;
    }

    public boolean isUntaggable(String viewType) {
        return this.mStore.untaggableTypes.containsKey(viewType);
    }

    private ModelMethod getBestSetter(ModelClass viewType, ModelClass argumentType, String attribute, Map<String, String> imports) {
        if (viewType.isGeneric()) {
            argumentType = SetterStore.eraseType(argumentType, viewType.getTypeArguments());
            viewType = viewType.erasure();
        }
        ArrayList<String> setterCandidates = new ArrayList<String>();
        HashMap renamed = (HashMap)this.mStore.renamedMethods.get(attribute);
        if (renamed != null) {
            for (String className : renamed.keySet()) {
                try {
                    ModelClass renamedViewType = this.mClassAnalyzer.findClass(className, imports);
                    if (!renamedViewType.erasure().isAssignableFrom(viewType)) continue;
                    setterCandidates.add(((MethodDescription)renamed.get((Object)className)).method);
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        setterCandidates.add(SetterStore.getDefaultSetter(attribute));
        setterCandidates.add(SetterStore.trimAttributeNamespace(attribute));
        ModelMethod bestMethod = null;
        ModelClass bestParameterType = null;
        ArrayList<ModelClass> args = new ArrayList<ModelClass>();
        args.add(argumentType);
        for (String name : setterCandidates) {
            ModelMethod[] methods;
            for (ModelMethod method : methods = viewType.getMethods(name, 1)) {
                ModelClass[] parameterTypes = method.getParameterTypes();
                ModelClass param = parameterTypes[0];
                if (!method.isVoid() || !this.isBetterParameter(argumentType, param, bestParameterType, true, imports)) continue;
                bestParameterType = param;
                bestMethod = method;
            }
        }
        return bestMethod;
    }

    private InverseMethod getBestGetter(ModelClass viewType, ModelClass valueType, String attribute, Map<String, String> imports) {
        if (viewType.isGeneric()) {
            if (valueType != null) {
                valueType = SetterStore.eraseType(valueType, viewType.getTypeArguments());
            }
            viewType = viewType.erasure();
        }
        ModelClass bestReturnType = null;
        InverseDescription bestDescription = null;
        ModelClass bestViewType = null;
        ModelMethod bestMethod = null;
        HashMap<String, InverseDescription> inverseMethods = this.mStore.inverseMethods.get(attribute);
        if (inverseMethods != null) {
            for (String className : inverseMethods.keySet()) {
                try {
                    ModelClass methodViewType = this.mClassAnalyzer.findClass(className, imports);
                    if (!methodViewType.erasure().isAssignableFrom(viewType)) continue;
                    boolean isBetterViewType = bestViewType == null || bestViewType.isAssignableFrom(methodViewType);
                    InverseDescription inverseDescription = inverseMethods.get(className);
                    String name = inverseDescription.method.isEmpty() ? SetterStore.trimAttributeNamespace(attribute) : inverseDescription.method;
                    ModelMethod method = methodViewType.findInstanceGetter(name);
                    ModelClass returnType = method.getReturnType(null);
                    if (valueType != null && bestReturnType != null && !this.isBetterParameter(returnType, valueType, bestReturnType, isBetterViewType, imports)) continue;
                    bestDescription = inverseDescription;
                    bestReturnType = returnType;
                    bestViewType = methodViewType;
                    bestMethod = method;
                }
                catch (Exception e) {}
            }
        }
        ViewGetterCall call = null;
        if (bestDescription != null) {
            ModelClass listenerType = ModelAnalyzer.getInstance().findClass(InverseBindingListener.class);
            SetterCall eventSetter = this.getSetterCall(bestDescription.event, viewType, listenerType, imports);
            if (eventSetter == null) {
                List<MultiAttributeSetter> setters = this.getMultiAttributeSetterCalls(new String[]{bestDescription.event}, viewType, new ModelClass[]{listenerType});
                if (setters.size() != 1) {
                    L.e((String)"Could not find event '%s' on View type '%s'", (Object[])new Object[]{bestDescription.event, viewType.getCanonicalName()});
                    bestViewType = null;
                    bestReturnType = null;
                } else {
                    call = new ViewGetterCall(bestDescription, bestMethod, setters.get(0));
                }
            } else {
                call = new ViewGetterCall(bestDescription, bestMethod, eventSetter);
            }
        }
        return new InverseMethod(call, bestReturnType, bestViewType);
    }

    private static ModelClass eraseType(ModelClass type, List<ModelClass> typeParameters) {
        List<ModelClass> typeArguments = type.getTypeArguments();
        if (typeArguments == null || typeParameters == null) {
            return type;
        }
        for (ModelClass arg : typeArguments) {
            if (!typeParameters.contains(arg)) continue;
            return type.erasure();
        }
        return type;
    }

    private static String trimAttributeNamespace(String attribute) {
        int colonIndex = attribute.indexOf(58);
        return colonIndex == -1 ? attribute : attribute.substring(colonIndex + 1);
    }

    private static String getDefaultSetter(String attribute) {
        return "set" + StringUtils.capitalize((String)SetterStore.trimAttributeNamespace(attribute));
    }

    private boolean isBetterParameter(ModelClass argument, ModelClass parameter, ModelClass oldParameter, boolean isBetterViewTypeMatch, Map<String, String> imports) {
        if (!isBetterViewTypeMatch && oldParameter.equals(argument)) {
            return false;
        }
        if (argument.equals(parameter)) {
            return true;
        }
        if (!isBetterViewTypeMatch && ModelMethod.isBoxingConversion(oldParameter, argument)) {
            return false;
        }
        if (ModelMethod.isBoxingConversion(parameter, argument)) {
            return true;
        }
        int oldConversionLevel = ModelMethod.getImplicitConversionLevel(oldParameter);
        if (ModelMethod.isImplicitConversion(argument, parameter)) {
            int conversionLevel = ModelMethod.getImplicitConversionLevel(parameter);
            return oldConversionLevel < 0 || conversionLevel < oldConversionLevel;
        }
        if (oldConversionLevel >= 0) {
            return false;
        }
        if (parameter.isAssignableFrom(argument)) {
            if (oldParameter == null) {
                return true;
            }
            return oldParameter.isAssignableFrom(parameter);
        }
        MethodDescription conversionMethod = this.getConversionMethod(argument, parameter, imports);
        if (conversionMethod != null) {
            return true;
        }
        if (this.getConversionMethod(argument, oldParameter, imports) != null) {
            return false;
        }
        return argument.isObject() && !parameter.isPrimitive();
    }

    private MethodDescription getConversionMethod(ModelClass from, ModelClass to, Map<String, String> imports) {
        if (from != null && to != null) {
            if (to.isObject()) {
                return null;
            }
            for (String fromClassName : this.mStore.conversionMethods.keySet()) {
                try {
                    ModelClass convertFrom = this.mClassAnalyzer.findClass(fromClassName, imports);
                    if (!this.canUseForConversion(from, convertFrom)) continue;
                    HashMap conversion = (HashMap)this.mStore.conversionMethods.get(fromClassName);
                    for (String toClassName : conversion.keySet()) {
                        try {
                            ModelClass convertTo = this.mClassAnalyzer.findClass(toClassName, imports);
                            if (!this.canUseForConversion(convertTo, to)) continue;
                            return (MethodDescription)conversion.get(toClassName);
                        }
                        catch (Exception e) {
                            L.d((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{toClassName});
                        }
                    }
                }
                catch (Exception e) {
                    L.d((Throwable)e, (String)"Unknown class: %s", (Object[])new Object[]{fromClassName});
                }
            }
        }
        return null;
    }

    private boolean canUseForConversion(ModelClass from, ModelClass to) {
        if (from.isIncomplete() || to.isIncomplete()) {
            from = from.erasure();
            to = to.erasure();
        }
        return from.equals(to) || ModelMethod.isBoxingConversion(from, to) || to.isAssignableFrom(from);
    }

    private static void merge(IntermediateV2 store, Intermediate dumpStore) {
        IntermediateV2 intermediateV2 = (IntermediateV2)dumpStore.upgrade();
        SetterStore.merge(store.adapterMethods, intermediateV2.adapterMethods);
        SetterStore.merge(store.renamedMethods, intermediateV2.renamedMethods);
        SetterStore.merge(store.conversionMethods, intermediateV2.conversionMethods);
        store.multiValueAdapters.putAll(intermediateV2.multiValueAdapters);
        store.untaggableTypes.putAll(intermediateV2.untaggableTypes);
        SetterStore.merge(store.inverseAdapters, intermediateV2.inverseAdapters);
        SetterStore.merge(store.inverseMethods, intermediateV2.inverseMethods);
    }

    private static <K, V, D> void merge(HashMap<K, HashMap<V, D>> first, HashMap<K, HashMap<V, D>> second) {
        for (K key : second.keySet()) {
            HashMap<D, D> firstVals = first.get(key);
            HashMap<V, D> secondVals = second.get(key);
            if (firstVals == null) {
                first.put(key, secondVals);
                continue;
            }
            for (V key2 : secondVals.keySet()) {
                if (firstVals.containsKey(key2)) continue;
                firstVals.put(key2, secondVals.get(key2));
            }
        }
    }

    private static String createAdapterCall(MethodDescription adapter, String componentExpression, String viewExpression, String ... args) {
        StringBuilder sb = new StringBuilder();
        if (adapter.isStatic) {
            sb.append(adapter.type);
        } else {
            SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
            String binderCall = setterStore.getBindingAdapterCall(adapter.type);
            sb.append(componentExpression).append('.').append(binderCall);
        }
        sb.append('.').append(adapter.method).append('(');
        if (adapter.componentClass != null) {
            if (!"DataBindingComponent".equals(adapter.componentClass)) {
                sb.append('(').append(adapter.componentClass).append(") ");
            }
            sb.append(componentExpression).append(", ");
        }
        sb.append(viewExpression);
        for (String arg : args) {
            sb.append(", ").append(arg);
        }
        sb.append(')');
        return sb.toString();
    }

    private static int mergedHashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    private static class InverseMethod {
        public BindingGetterCall call;
        public ModelClass returnType;
        public ModelClass viewType;

        public InverseMethod(BindingGetterCall call, ModelClass returnType, ModelClass viewType) {
            this.call = call;
            this.returnType = returnType;
            this.viewType = viewType;
        }
    }

    public static class AdapterGetter
    implements BindingGetterCall {
        private final InverseDescription mInverseDescription;
        private String mBindingAdapterCall;
        private final BindingSetterCall mEventCall;
        private final String mGetterType;

        public AdapterGetter(InverseDescription description, BindingSetterCall eventCall, String getterType) {
            this.mInverseDescription = description;
            this.mEventCall = eventCall;
            this.mGetterType = getterType;
        }

        @Override
        public String getGetterType() {
            return this.mGetterType;
        }

        @Override
        public String toJava(String componentExpression, String viewExpression) {
            StringBuilder sb = new StringBuilder();
            if (this.mInverseDescription.isStatic) {
                sb.append(this.mInverseDescription.type);
            } else {
                sb.append(componentExpression).append('.').append(this.mBindingAdapterCall);
            }
            sb.append('.').append(this.mInverseDescription.method).append('(');
            if (this.mInverseDescription.componentClass != null) {
                if (!"DataBindingComponent".equals(this.mInverseDescription.componentClass)) {
                    sb.append('(').append(this.mInverseDescription.componentClass).append(") ");
                }
                sb.append(componentExpression).append(", ");
            }
            sb.append(viewExpression).append(')');
            return sb.toString();
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mInverseDescription.isStatic ? null : this.mInverseDescription.type;
        }

        @Override
        public void setBindingAdapterCall(String method) {
            this.mBindingAdapterCall = method;
        }

        @Override
        public BindingSetterCall getEvent() {
            return this.mEventCall;
        }

        @Override
        public String getEventAttribute() {
            return this.mInverseDescription.event;
        }
    }

    public static class ViewGetterCall
    implements BindingGetterCall {
        private final InverseDescription mInverseDescription;
        private final BindingSetterCall mEventCall;
        private final ModelMethod mMethod;

        public ViewGetterCall(InverseDescription inverseDescription, ModelMethod method, BindingSetterCall eventCall) {
            this.mInverseDescription = inverseDescription;
            this.mEventCall = eventCall;
            this.mMethod = method;
        }

        @Override
        public BindingSetterCall getEvent() {
            return this.mEventCall;
        }

        @Override
        public String getEventAttribute() {
            return this.mInverseDescription.event;
        }

        @Override
        public String toJava(String componentExpression, String viewExpression) {
            return viewExpression + "." + this.mMethod.getName() + "()";
        }

        @Override
        public String getGetterType() {
            return this.mMethod.getReturnType().toJavaCode();
        }

        @Override
        public int getMinApi() {
            return this.mMethod.getMinApi();
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }

        @Override
        public void setBindingAdapterCall(String method) {
        }
    }

    public static class ViewDataBindingGetterCall
    implements BindingGetterCall {
        private final String mGetter;
        private final BindingSetterCall mEventSetter;
        private final String mAttribute;
        private final ModelClass mBindingClass;

        public ViewDataBindingGetterCall(ModelClass bindingClass, String attribute) {
            int colonIndex = attribute.indexOf(58);
            this.mAttribute = attribute.substring(colonIndex + 1);
            this.mGetter = "get" + StringUtils.capitalize((String)this.mAttribute);
            this.mEventSetter = new ViewDataBindingEventSetter();
            this.mBindingClass = bindingClass;
        }

        @Override
        public String toJava(String componentExpression, String viewExpression) {
            return viewExpression + "." + this.mGetter + "()";
        }

        @Override
        public String getGetterType() {
            return this.mBindingClass.findInstanceGetter(this.mGetter).getReturnType().toJavaCode();
        }

        @Override
        public int getMinApi() {
            return 0;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }

        @Override
        public void setBindingAdapterCall(String method) {
        }

        @Override
        public BindingSetterCall getEvent() {
            return this.mEventSetter;
        }

        @Override
        public String getEventAttribute() {
            return this.mAttribute;
        }
    }

    public static interface BindingGetterCall {
        public String toJava(String var1, String var2);

        public String getGetterType();

        public int getMinApi();

        public String getBindingAdapterInstanceClass();

        public void setBindingAdapterCall(String var1);

        public BindingSetterCall getEvent();

        public String getEventAttribute();
    }

    public static class ViewDataBindingEventSetter
    implements BindingSetterCall {
        @Override
        public String toJava(String componentExpression, String viewExpression, String ... valueExpressions) {
            return "setBindingInverseListener(" + viewExpression + ", " + valueExpressions[0] + ", " + valueExpressions[1] + ")";
        }

        @Override
        public int getMinApi() {
            return 0;
        }

        @Override
        public boolean requiresOldValue() {
            return true;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            ModelClass[] parameterTypes = new ModelClass[]{ModelAnalyzer.getInstance().findClass("android.databinding.ViewDataBinder.PropertyChangedInverseListener", null)};
            return parameterTypes;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }
    }

    public static class MultiAttributeSetter
    implements BindingSetterCall {
        public final String[] attributes;
        private final MethodDescription mAdapter;
        private final MethodDescription[] mConverters;
        private final String[] mCasts;
        private final MultiValueAdapterKey mKey;
        private final boolean[] mSupplied;

        public MultiAttributeSetter(MultiValueAdapterKey key, boolean[] supplied, MethodDescription adapter, MethodDescription[] converters, String[] casts) {
            Preconditions.check((converters != null && converters.length == key.attributes.length && casts != null && casts.length == key.attributes.length && supplied.length == key.attributes.length ? 1 : 0) != 0, (String)"invalid arguments to create multi attr setter", (Object[])new Object[0]);
            this.mAdapter = adapter;
            this.mConverters = converters;
            this.mCasts = casts;
            this.mKey = key;
            this.mSupplied = supplied;
            if (key.requireAll) {
                this.attributes = key.attributes;
            } else {
                int numSupplied = 0;
                for (int i = 0; i < this.mKey.attributes.length; ++i) {
                    if (!supplied[i]) continue;
                    ++numSupplied;
                }
                if (numSupplied == key.attributes.length) {
                    this.attributes = key.attributes;
                } else {
                    this.attributes = new String[numSupplied];
                    int attrIndex = 0;
                    for (int i = 0; i < key.attributes.length; ++i) {
                        if (!supplied[i]) continue;
                        this.attributes[attrIndex++] = key.attributes[i];
                    }
                }
            }
        }

        @Override
        public final String toJava(String componentExpression, String viewExpression, String[] valueExpressions) {
            Preconditions.check((valueExpressions.length == this.attributes.length * 2 ? 1 : 0) != 0, (String)"MultiAttributeSetter needs %s items, received %s", (Object[])new Object[]{Arrays.toString(this.attributes), Arrays.toString(valueExpressions)});
            int numAttrs = this.mKey.attributes.length;
            String[] args = new String[numAttrs + (this.requiresOldValue() ? numAttrs : 0)];
            int startIndex = this.mAdapter.requiresOldValue ? 0 : numAttrs;
            int attrIndex = this.mAdapter.requiresOldValue ? 0 : this.attributes.length;
            ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
            StringBuilder argBuilder = new StringBuilder();
            int endIndex = numAttrs * 2;
            for (int i = startIndex; i < endIndex; ++i) {
                argBuilder.setLength(0);
                if (!this.mSupplied[i % numAttrs]) {
                    String paramType = this.mKey.parameterTypes[i % numAttrs];
                    String defaultValue = modelAnalyzer.getDefaultValue(paramType);
                    argBuilder.append('(').append(paramType).append(')').append(defaultValue);
                } else {
                    if (this.mConverters[i % numAttrs] != null) {
                        MethodDescription converter = this.mConverters[i % numAttrs];
                        argBuilder.append(converter.type).append('.').append(converter.method).append('(').append(valueExpressions[attrIndex]).append(')');
                    } else {
                        if (this.mCasts[i % numAttrs] != null) {
                            argBuilder.append('(').append(this.mCasts[i % numAttrs]).append(')');
                        }
                        argBuilder.append(valueExpressions[attrIndex]);
                    }
                    ++attrIndex;
                }
                args[i - startIndex] = argBuilder.toString();
            }
            return SetterStore.createAdapterCall(this.mAdapter, componentExpression, viewExpression, args);
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public boolean requiresOldValue() {
            return this.mAdapter.requiresOldValue;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            ModelClass[] parameters = new ModelClass[this.attributes.length];
            String[] paramTypeStrings = this.mKey.parameterTypes;
            ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
            int attrIndex = 0;
            for (int i = 0; i < this.mKey.attributes.length; ++i) {
                if (!this.mSupplied[i]) continue;
                parameters[attrIndex++] = modelAnalyzer.findClass(paramTypeStrings[i], null);
            }
            return parameters;
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mAdapter.isStatic ? null : this.mAdapter.type;
        }

        public String toString() {
            return "MultiAttributeSetter{attributes=" + Arrays.toString(this.attributes) + ", mAdapter=" + this.mAdapter + ", mConverters=" + Arrays.toString(this.mConverters) + ", mCasts=" + Arrays.toString(this.mCasts) + ", mKey=" + this.mKey + '}';
        }
    }

    public static abstract class SetterCall
    implements BindingSetterCall {
        private MethodDescription mConverter;
        protected String mCastString = "";

        public void setConverter(MethodDescription converter) {
            this.mConverter = converter;
        }

        protected abstract String toJavaInternal(String var1, String var2, String var3);

        protected abstract String toJavaInternal(String var1, String var2, String var3, String var4);

        @Override
        public final String toJava(String componentExpression, String viewExpression, String ... valueExpression) {
            Preconditions.check((valueExpression.length == 2 ? 1 : 0) != 0, (String)"value expressions size must be 2", (Object[])new Object[0]);
            if (this.requiresOldValue()) {
                return this.toJavaInternal(componentExpression, viewExpression, this.convertValue(valueExpression[0]), this.convertValue(valueExpression[1]));
            }
            return this.toJavaInternal(componentExpression, viewExpression, this.convertValue(valueExpression[1]));
        }

        protected String convertValue(String valueExpression) {
            return this.mConverter == null ? valueExpression : this.mConverter.type + "." + this.mConverter.method + "(" + valueExpression + ")";
        }

        @Override
        public abstract int getMinApi();

        public void setCast(ModelClass castTo) {
            this.mCastString = "(" + castTo.toJavaCode() + ") ";
        }
    }

    public static interface BindingSetterCall {
        public String toJava(String var1, String var2, String ... var3);

        public int getMinApi();

        public boolean requiresOldValue();

        public ModelClass[] getParameterTypes();

        public String getBindingAdapterInstanceClass();
    }

    public static class ModelMethodSetter
    extends SetterCall {
        final ModelMethod mModelMethod;

        public ModelMethodSetter(ModelMethod modelMethod) {
            this.mModelMethod = modelMethod;
        }

        @Override
        public String toJavaInternal(String componentExpression, String viewExpression, String valueExpression) {
            return viewExpression + "." + this.mModelMethod.getName() + "(" + this.mCastString + valueExpression + ")";
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String valueExpression) {
            return viewExpression + "." + this.mModelMethod.getName() + "(" + this.mCastString + oldValue + ", " + this.mCastString + valueExpression + ")";
        }

        @Override
        public int getMinApi() {
            return this.mModelMethod.getMinApi();
        }

        @Override
        public boolean requiresOldValue() {
            return this.mModelMethod.getParameterTypes().length == 3;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{this.mModelMethod.getParameterTypes()[0]};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }
    }

    public static class AdapterSetter
    extends SetterCall {
        final MethodDescription mAdapter;
        final ModelClass mParameterType;

        public AdapterSetter(MethodDescription adapter, ModelClass parameterType) {
            this.mAdapter = adapter;
            this.mParameterType = parameterType;
        }

        @Override
        public String toJavaInternal(String componentExpression, String viewExpression, String valueExpression) {
            return SetterStore.createAdapterCall(this.mAdapter, componentExpression, viewExpression, new String[]{this.mCastString + valueExpression});
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String valueExpression) {
            return SetterStore.createAdapterCall(this.mAdapter, componentExpression, viewExpression, new String[]{this.mCastString + oldValue, this.mCastString + valueExpression});
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public boolean requiresOldValue() {
            return this.mAdapter.requiresOldValue;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{this.mParameterType};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mAdapter.isStatic ? null : this.mAdapter.type;
        }
    }

    public static class DummySetter
    extends SetterCall {
        private String mMethodName;

        public DummySetter(String methodName) {
            this.mMethodName = methodName;
        }

        @Override
        public String toJavaInternal(String componentExpression, String viewExpression, String valueExpression) {
            return viewExpression + "." + this.mMethodName + "(" + valueExpression + ")";
        }

        @Override
        public String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String valueExpression) {
            return viewExpression + "." + this.mMethodName + "(" + valueExpression + ")";
        }

        @Override
        public int getMinApi() {
            return 1;
        }

        @Override
        public boolean requiresOldValue() {
            return false;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{ModelAnalyzer.getInstance().findClass(Object.class)};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }
    }

    private static class IntermediateV2
    extends IntermediateV1 {
        private static final long serialVersionUID = -6603351593475417081L;
        public final HashMap<String, HashMap<AccessorKey, InverseDescription>> inverseAdapters = new HashMap();
        public final HashMap<String, HashMap<String, InverseDescription>> inverseMethods = new HashMap();

        private IntermediateV2() {
        }

        @Override
        public Intermediate upgrade() {
            return this;
        }
    }

    private static class IntermediateV1
    implements Serializable,
    Intermediate {
        private static final long serialVersionUID = 1L;
        public final HashMap<String, HashMap<AccessorKey, MethodDescription>> adapterMethods = new HashMap();
        public final HashMap<String, HashMap<String, MethodDescription>> renamedMethods = new HashMap();
        public final HashMap<String, HashMap<String, MethodDescription>> conversionMethods = new HashMap();
        public final HashMap<String, String> untaggableTypes = new HashMap();
        public final HashMap<MultiValueAdapterKey, MethodDescription> multiValueAdapters = new HashMap();

        @Override
        public Intermediate upgrade() {
            IntermediateV2 v2 = new IntermediateV2();
            v2.adapterMethods.putAll(this.adapterMethods);
            v2.renamedMethods.putAll(this.renamedMethods);
            v2.conversionMethods.putAll(this.conversionMethods);
            v2.untaggableTypes.putAll(this.untaggableTypes);
            v2.multiValueAdapters.putAll(this.multiValueAdapters);
            return v2;
        }
    }

    private static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();
    }

    private static class AccessorKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String viewType;
        public final String valueType;

        public AccessorKey(String viewType, String valueType) {
            this.viewType = viewType;
            this.valueType = valueType;
        }

        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.viewType, this.valueType});
        }

        public boolean equals(Object obj) {
            if (obj instanceof AccessorKey) {
                AccessorKey that = (AccessorKey)obj;
                return this.viewType.equals(that.valueType) && this.valueType.equals(that.valueType);
            }
            return false;
        }

        public String toString() {
            return "AK(" + this.viewType + ", " + this.valueType + ")";
        }
    }

    private static class InverseDescription
    extends MethodDescription {
        private static final long serialVersionUID = 1L;
        public final String event;

        public InverseDescription(String type, String method, String event) {
            super(type, method);
            this.event = event;
        }

        public InverseDescription(ExecutableElement method, String event, boolean takesComponent) {
            super(method, 1, takesComponent);
            this.event = event;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof InverseDescription)) {
                return false;
            }
            return this.event.equals(((InverseDescription)obj).event);
        }

        @Override
        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.type, this.method, this.event});
        }
    }

    private static class MethodDescription
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String type;
        public final String method;
        public final boolean requiresOldValue;
        public final boolean isStatic;
        public final String componentClass;

        public MethodDescription(String type, String method) {
            this.type = type;
            this.method = method;
            this.requiresOldValue = false;
            this.isStatic = true;
            this.componentClass = null;
            L.d((String)"BINARY created method desc 1 %s %s", (Object[])new Object[]{type, method});
        }

        public MethodDescription(ExecutableElement method, int numAttributes, boolean takesComponent) {
            TypeElement enclosingClass = (TypeElement)method.getEnclosingElement();
            this.type = enclosingClass.getQualifiedName().toString();
            this.method = method.getSimpleName().toString();
            int argStart = 1 + (takesComponent ? 1 : 0);
            this.requiresOldValue = method.getParameters().size() - argStart == numAttributes * 2;
            this.isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
            this.componentClass = takesComponent ? SetterStore.getQualifiedName(method.getParameters().get(0).asType()) : null;
            L.d((String)"BINARY created method desc 2 %s %s, %s", (Object[])new Object[]{this.type, this.method, method});
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodDescription) {
                MethodDescription that = (MethodDescription)obj;
                return that.type.equals(this.type) && that.method.equals(this.method);
            }
            return false;
        }

        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.type, this.method});
        }

        public String toString() {
            return this.type + "." + this.method + "()";
        }
    }

    private static class MultiValueAdapterKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String viewType;
        public final String[] attributes;
        public final String[] parameterTypes;
        public final boolean requireAll;
        public final TreeMap<String, Integer> attributeIndices = new TreeMap();

        public MultiValueAdapterKey(ProcessingEnvironment processingEnv, ExecutableElement method, String[] attributes, boolean takesComponent, boolean requireAll) {
            this.attributes = SetterStore.stripAttributes(attributes);
            this.requireAll = requireAll;
            List<? extends VariableElement> parameters = method.getParameters();
            int argStart = 1 + (takesComponent ? 1 : 0);
            this.viewType = SetterStore.getQualifiedName(SetterStore.eraseType(processingEnv, parameters.get(argStart - 1).asType()));
            this.parameterTypes = new String[parameters.size() - argStart];
            for (int i = 0; i < attributes.length; ++i) {
                TypeMirror typeMirror = SetterStore.eraseType(processingEnv, parameters.get(i + argStart).asType());
                this.parameterTypes[i] = SetterStore.getQualifiedName(typeMirror);
                this.attributeIndices.put(this.attributes[i], i);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MultiValueAdapterKey)) {
                return false;
            }
            MultiValueAdapterKey that = (MultiValueAdapterKey)obj;
            if (!this.viewType.equals(that.viewType) || this.attributes.length != that.attributes.length || !((Object)this.attributeIndices.keySet()).equals(that.attributeIndices.keySet())) {
                return false;
            }
            for (int i = 0; i < this.attributes.length; ++i) {
                String thisParameter = this.parameterTypes[i];
                int thatIndex = that.attributeIndices.get(this.attributes[i]);
                String thatParameter = that.parameterTypes[thatIndex];
                if (thisParameter.equals(thatParameter)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return SetterStore.mergedHashCode(new Object[]{this.viewType, this.attributeIndices.keySet()});
        }
    }
}

