/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class ComparisonExpr
extends Expr {
    final String mOp;

    ComparisonExpr(String op, Expr left, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return ComparisonExpr.join(this.mOp, super.computeUniqueKey());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.loadPrimitive("boolean");
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public String getOp() {
        return this.mOp;
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }

    @Override
    public boolean isEqualityCheck() {
        return "==".equals(this.mOp.trim());
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("(", this.getLeft().toCode()).app(") ").app(this.getOp()).app(" (", this.getRight().toCode()).app(")");
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.comparison(this.mOp, this.getLeft().cloneToModel(model), this.getRight().cloneToModel(model));
    }

    @Override
    public String getInvertibleError() {
        return "Comparison operators are not valid as targets of two-way binding";
    }

    @Override
    public String toString() {
        return this.getLeft().toString() + ' ' + this.mOp + ' ' + this.getRight();
    }
}

