/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.Extractor;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiDatabase {
    private final List<String> lines;
    private final Map<String, Set<String>> fieldMap = Maps.newHashMapWithExpectedSize((int)1000);
    private final Map<String, Map<String, List<String>>> methodMap = Maps.newHashMapWithExpectedSize((int)1000);
    private final Map<String, List<String>> inheritsFrom = Maps.newHashMapWithExpectedSize((int)1000);
    private final Map<String, Set<String>> intFieldMap = Maps.newHashMapWithExpectedSize((int)1000);
    private final Set<String> classSet = Sets.newHashSetWithExpectedSize((int)1000);

    public ApiDatabase(List<String> lines) {
        this.lines = lines;
        this.readApi();
    }

    public ApiDatabase(File api) throws IOException {
        this(Files.readLines((File)api, (Charset)Charsets.UTF_8));
    }

    public boolean hasMethod(String className, String methodName, String arguments) {
        List<String> strings;
        className = ApiDatabase.getRawClass(className);
        methodName = ApiDatabase.getRawMethod(methodName);
        arguments = ApiDatabase.getRawParameterList(arguments);
        Map<String, List<String>> methods = this.methodMap.get(className);
        if (methods != null && (strings = methods.get(methodName)) != null && strings.contains(arguments)) {
            return true;
        }
        List<String> inheritsFrom = this.inheritsFrom.get(className);
        if (inheritsFrom != null) {
            for (String clz : inheritsFrom) {
                if (!this.hasMethod(clz, methodName, arguments)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasField(String className, String fieldName) {
        Set<String> fields = this.fieldMap.get(className);
        if (fields != null && fields.contains(fieldName)) {
            return true;
        }
        List<String> inheritsFrom = this.inheritsFrom.get(className);
        if (inheritsFrom != null) {
            for (String clz : inheritsFrom) {
                if (!this.hasField(clz, fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasClass(String className) {
        return this.classSet.contains(className);
    }

    public Set<String> getDeclaredIntFields(String className) {
        return this.intFieldMap.get(className);
    }

    private void readApi() {
        String MODIFIERS = "((deprecated|public|static|private|protected|final|abstract|\\s*)\\s+)*";
        Pattern PACKAGE = Pattern.compile("package (\\S+) \\{");
        Pattern CLASS = Pattern.compile(MODIFIERS + "(class|interface|enum)\\s+(\\S+)\\s+(extends (.+))?(implements (.+))?(.*)\\{");
        Pattern METHOD = Pattern.compile("(method|ctor)\\s+" + MODIFIERS + "(.+)??\\s+(\\S+)\\s*\\((.*)\\)(.*);");
        Pattern CTOR = Pattern.compile("(method|ctor)\\s+.*\\((.*)\\)(.*);");
        Pattern FIELD = Pattern.compile("(enum_constant|field)\\s+" + MODIFIERS + "(.+)\\s+(\\S+)\\s*;");
        String currentPackage = null;
        String currentClass = null;
        for (String line : this.lines) {
            String implementsList;
            String raw;
            String signature;
            String methodName;
            List signatures;
            Map<Object, Object> memberMap;
            if ((line = line.trim()).isEmpty() || line.equals("}")) continue;
            if (line.startsWith("method ")) {
                Matcher matcher = METHOD.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a member: " + line);
                    continue;
                }
                assert (currentClass != null);
                memberMap = this.methodMap.get(currentClass);
                if (memberMap == null) {
                    memberMap = Maps.newHashMap();
                    this.methodMap.put(currentClass, (Map<String, List<String>>)memberMap);
                    this.methodMap.put(ApiDatabase.getRawClass(currentClass), memberMap);
                }
                if ((signatures = (List)memberMap.get(methodName = matcher.group(5))) == null) {
                    signatures = Lists.newArrayList();
                    memberMap.put(methodName, signatures);
                    memberMap.put(ApiDatabase.getRawMethod(methodName), signatures);
                }
                signature = matcher.group(6);
                signature = signature.trim().replace(" ", "").replace(" ", "");
                signatures.add(signature);
                if (signature.endsWith("...")) {
                    signatures.add(signature.substring(0, signature.length() - 3) + "[]");
                } else if (signature.endsWith("[]") && !signature.endsWith("[][]")) {
                    signatures.add(signature.substring(0, signature.length() - 2) + "...");
                }
                if (signatures.contains(raw = ApiDatabase.getRawParameterList(signature))) continue;
                signatures.add(raw);
                continue;
            }
            if (line.startsWith("ctor ")) {
                Matcher matcher = CTOR.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a member: " + line);
                    continue;
                }
                assert (currentClass != null);
                memberMap = this.methodMap.get(currentClass);
                if (memberMap == null) {
                    memberMap = Maps.newHashMap();
                    this.methodMap.put(currentClass, memberMap);
                    this.methodMap.put(ApiDatabase.getRawClass(currentClass), memberMap);
                }
                if ((signatures = (List)memberMap.get(methodName = currentClass)) == null) {
                    signatures = Lists.newArrayList();
                    memberMap.put(methodName, signatures);
                    String constructor = methodName.substring(methodName.lastIndexOf(46) + 1);
                    memberMap.put(constructor, signatures);
                    memberMap.put(ApiDatabase.getRawMethod(methodName), signatures);
                    memberMap.put(ApiDatabase.getRawMethod(constructor), signatures);
                }
                signature = matcher.group(2);
                if ((signature = signature.trim().replace(" ", "").replace(" ", "")).endsWith("...")) {
                    signatures.add(signature.substring(0, signature.length() - 3) + "[]");
                } else if (signature.endsWith("[]") && !signature.endsWith("[][]")) {
                    signatures.add(signature.substring(0, signature.length() - 2) + "...");
                }
                signatures.add(signature);
                raw = ApiDatabase.getRawMethod(signature);
                if (signatures.contains(raw)) continue;
                signatures.add(raw);
                continue;
            }
            if (line.startsWith("enum_constant ") || line.startsWith("field ")) {
                int semi;
                int equals = line.indexOf(61);
                if (equals != -1) {
                    int semi2 = (line = line.substring(0, equals).trim()).indexOf(59);
                    if (semi2 == -1) {
                        line = line + ';';
                    }
                } else if (!line.endsWith(";") && (semi = line.indexOf(59)) != -1) {
                    line = line.substring(0, semi + 1);
                }
                Matcher matcher = FIELD.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a member: " + line);
                    continue;
                }
                assert (currentClass != null);
                String fieldName = matcher.group(5);
                HashSet fieldSet = this.fieldMap.get(currentClass);
                if (fieldSet == null) {
                    fieldSet = Sets.newHashSet();
                    this.fieldMap.put(currentClass, fieldSet);
                }
                fieldSet.add(fieldName);
                String type = matcher.group(4);
                if (!type.equals("int")) continue;
                fieldSet = this.intFieldMap.get(currentClass);
                if (fieldSet == null) {
                    fieldSet = Sets.newHashSet();
                    this.intFieldMap.put(currentClass, fieldSet);
                }
                fieldSet.add(fieldName);
                continue;
            }
            if (line.startsWith("package ")) {
                Matcher matcher = PACKAGE.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a package: " + line);
                    continue;
                }
                currentPackage = matcher.group(1);
                continue;
            }
            Matcher matcher = CLASS.matcher(line);
            if (!matcher.matches()) {
                Extractor.warning("Warning: Did not match as a class/interface: " + line);
                continue;
            }
            currentClass = currentPackage + '.' + matcher.group(4);
            this.classSet.add(currentClass);
            String superClass = matcher.group(6);
            if (superClass != null) {
                Splitter splitter = Splitter.on((char)' ').trimResults().omitEmptyStrings();
                for (String from : splitter.split((CharSequence)superClass)) {
                    if (from.equals("implements")) continue;
                    this.addInheritsFrom(currentClass, from);
                }
                this.addInheritsFrom(currentClass, superClass.trim());
            }
            if ((implementsList = matcher.group(8)) == null) continue;
            Splitter splitter = Splitter.on((char)' ').trimResults().omitEmptyStrings();
            for (String from : splitter.split((CharSequence)implementsList)) {
                this.addInheritsFrom(currentClass, from);
            }
        }
    }

    private void addInheritsFrom(String cls, String inheritsFrom) {
        ArrayList list = this.inheritsFrom.get(cls);
        if (list == null) {
            list = Lists.newArrayList();
            this.inheritsFrom.put(cls, list);
        }
        list.add(inheritsFrom);
    }

    static String getRawClass(String name) {
        int index = name.indexOf(60);
        if (index != -1) {
            int end = name.indexOf(62, index + 1);
            if (end == -1 || end == name.length() - 1) {
                return name.substring(0, index);
            }
            return name.substring(0, index) + name.substring(end + 1);
        }
        return name;
    }

    static String getRawMethod(String name) {
        int index = name.indexOf(60);
        if (index != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    static String getRawParameterList(String signature) {
        if (signature.indexOf(60) == -1 && !signature.endsWith("...")) {
            return signature;
        }
        int n = signature.length();
        StringBuilder sb = new StringBuilder(n);
        int start = 0;
        block0: while (true) {
            int index;
            if ((index = signature.indexOf(60, start)) == -1) break;
            sb.append(signature.substring(start, index));
            int balance = 1;
            int i = index + 1;
            while (true) {
                if (i >= n) continue block0;
                char c = signature.charAt(i);
                if (c == '<') {
                    ++balance;
                } else if (c == '>' && --balance == 0) {
                    start = i + 1;
                    continue block0;
                }
                ++i;
            }
            break;
        }
        sb.append(signature.substring(start));
        if (sb.length() > 3 && sb.charAt(sb.length() - 1) == '.' && sb.charAt(sb.length() - 2) == '.' && sb.charAt(sb.length() - 3) == '.') {
            sb.setLength(sb.length() - 3);
            sb.append('[').append(']');
        }
        return sb.toString();
    }
}

