/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.external.gson.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;

class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    NdkBuildExternalNativeJsonGenerator(NdkHandler ndkHandler, int minSdkVersion, String variantName, List<Abi> abis, AndroidBuilder androidBuilder, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makeFile, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons) {
        super(ndkHandler, minSdkVersion, variantName, abis, androidBuilder, sdkFolder, ndkFolder, soFolder, new File(objFolder, "local"), jsonFolder, makeFile, debuggable, buildArguments, cFlags, cppFlags, nativeBuildConfigurationsJsons);
    }

    @Override
    void processBuildOutput(String buildOutput, String abi, int abiPlatformVersion) throws IOException {
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        this.diagnostic("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        NativeBuildConfigValue buildConfig = new NativeBuildConfigValueBuilder(this.getMakeFile()).addCommands(this.getBuildCommand(abi, abiPlatformVersion, applicationMk), this.variantName, buildOutput, NdkBuildExternalNativeJsonGenerator.isWindows()).build();
        if (applicationMk.exists()) {
            this.diagnostic("found application make file %s", applicationMk.getAbsolutePath());
            Preconditions.checkNotNull(buildConfig.buildFiles);
            buildConfig.buildFiles.add(applicationMk);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        File expectedJson = ExternalNativeBuildTaskUtils.getOutputJson(this.getJsonFolder(), abi);
        Files.write((CharSequence)actualResult, (File)expectedJson, (Charset)Charsets.UTF_8);
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(String abi, int abiPlatformVersion, File outputJson) {
        this.checkConfiguration();
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getNdkBuild()).addArgs(this.getBaseArgs(abi, abiPlatformVersion, applicationMk)).addArgs("APP_SHORT_COMMANDS=false").addArgs("LOCAL_SHORT_COMMANDS=false").addArgs("-n");
        return builder;
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.NDK_BUILD;
    }

    private String getNdkBuild() {
        String tool = "ndk-build";
        if (NdkBuildExternalNativeJsonGenerator.isWindows()) {
            tool = tool + ".cmd";
        }
        return new File(this.getNdkFolder(), tool).getAbsolutePath();
    }

    private File getMakeFile() {
        if (this.getMakefile().isDirectory()) {
            return new File(this.getMakefile(), "Android.mk");
        }
        return this.getMakefile();
    }

    private void checkConfiguration() {
        List<String> configurationErrors = this.getConfigurationErrors();
        if (!configurationErrors.isEmpty()) {
            throw new GradleException(Joiner.on((String)"\n").join(configurationErrors));
        }
    }

    private List<String> getBaseArgs(String abi, int abiPlatformVersion, File applicationMk) {
        ArrayList result = Lists.newArrayList();
        result.add("NDK_PROJECT_PATH=null");
        result.add("APP_BUILD_SCRIPT=" + this.getMakeFile());
        if (applicationMk.exists()) {
            result.add("NDK_APPLICATION_MK=" + applicationMk.getAbsolutePath());
        }
        result.add("APP_ABI=" + abi);
        result.add("NDK_ALL_ABIS=" + abi);
        if (this.isDebuggable()) {
            result.add("NDEBUG=1");
        } else {
            result.add("NDEBUG=0");
        }
        result.add("APP_PLATFORM=android-" + abiPlatformVersion);
        result.add("NDK_OUT=" + this.getObjFolder().getParent());
        result.add("NDK_LIBS_OUT=" + this.getSoFolder().getAbsolutePath());
        for (String flag : this.getcFlags()) {
            result.add(String.format("APP_CFLAGS+=\"%s\"", flag));
        }
        for (String flag : this.getCppFlags()) {
            result.add(String.format("APP_CPPFLAGS+=\"%s\"", flag));
        }
        for (String argument : this.getBuildArguments()) {
            result.add(argument);
        }
        return result;
    }

    private String getBuildCommand(String abi, int abiPlatformVersion, File applicationMk) {
        return this.getNdkBuild() + " " + Joiner.on((String)" ").join(this.getBaseArgs(abi, abiPlatformVersion, applicationMk));
    }

    private List<String> getConfigurationErrors() {
        ArrayList messages = Lists.newArrayList();
        if (this.getMakefile().isDirectory()) {
            messages.add(String.format("Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", this.getMakefile()));
        } else if (!this.getMakefile().exists()) {
            messages.add(String.format("Gradle project ndkBuild.path is %s but that file doesn't exist", this.getMakefile()));
        }
        messages.addAll(this.getBaseConfigurationErrors());
        return messages;
    }
}

