/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.externalBuild.ExternalBuildAnchorTask;
import com.android.build.gradle.internal.externalBuild.ExternalBuildContext;
import com.android.build.gradle.internal.externalBuild.ExternalBuildExtension;
import com.android.build.gradle.internal.externalBuild.ExternalBuildGlobalScope;
import com.android.build.gradle.internal.externalBuild.ExternalBuildManifestLoader;
import com.android.build.gradle.internal.externalBuild.ExternalBuildPackagingScope;
import com.android.build.gradle.internal.externalBuild.ExternalBuildVariantScope;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.model.AaptOptionsImpl;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.SupplierTask;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.transforms.ExtractJarsTransform;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DexOptions;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.utils.FileUtils;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;

class ExternalBuildTaskManager {
    private final Project project;
    private final AndroidTaskRegistry androidTasks = new AndroidTaskRegistry();
    private final TaskContainerAdaptor tasks;

    ExternalBuildTaskManager(Project project) {
        this.project = project;
        this.tasks = new TaskContainerAdaptor(project.getTasks());
    }

    void createTasks(ExternalBuildExtension externalBuildExtension) throws Exception {
        AndroidTask<ExternalBuildAnchorTask> externalBuildAnchorTask = this.androidTasks.create(this.tasks, new ExternalBuildAnchorTask.ConfigAction());
        ExternalBuildContext externalBuildContext = new ExternalBuildContext(externalBuildExtension);
        File file = this.project.file((Object)externalBuildExtension.buildManifestPath);
        ExternalBuildManifestLoader.loadAndPopulateContext(new File(externalBuildExtension.getExecutionRoot()), file, this.project, externalBuildContext);
        ExtraModelInfo modelInfo = new ExtraModelInfo(this.project, false);
        TransformManager transformManager = new TransformManager(this.androidTasks, modelInfo);
        transformManager.addStream(OriginalStream.builder().addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.CLASSES).addScope(QualifiedContent.Scope.PROJECT).setJars((Supplier<Collection<File>>)((Supplier)externalBuildContext::getInputJarFiles)).build());
        transformManager.addStream(OriginalStream.builder().addContentType((QualifiedContent.ContentType)QualifiedContent.DefaultContentType.RESOURCES).addScope(QualifiedContent.Scope.PROJECT).setFolder(Files.createTempDir()).build());
        transformManager.addStream(OriginalStream.builder().addContentType(ExtendedContentType.NATIVE_LIBS).addScope(QualifiedContent.Scope.PROJECT).setFolder(Files.createTempDir()).build());
        ExternalBuildGlobalScope globalScope = new ExternalBuildGlobalScope(this.project);
        final File androidManifestFile = new File(externalBuildContext.getExecutionRoot(), externalBuildContext.getBuildManifest().getAndroidManifest().getExecRootPath());
        final File processedAndroidResourcesFile = new File(externalBuildContext.getExecutionRoot(), externalBuildContext.getBuildManifest().getResourceApk().getExecRootPath());
        final ExternalBuildVariantScope variantScope = new ExternalBuildVariantScope(globalScope, this.project.getBuildDir(), externalBuildContext, new AaptOptionsImpl(null, null, false, null), (ManifestAttributeSupplier)new DefaultManifestParser(androidManifestFile));
        ExtractJarsTransform extractJarsTransform = new ExtractJarsTransform((Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT));
        AndroidTask<TransformTask> extractJarsTask = transformManager.addTransform(this.tasks, variantScope, extractJarsTransform);
        assert (extractJarsTask != null);
        InstantRunTaskManager instantRunTaskManager = new InstantRunTaskManager(this.project.getLogger(), variantScope, transformManager, this.androidTasks, this.tasks);
        AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask = instantRunTaskManager.createInstantRunAllTasks((DexOptions)new com.android.build.gradle.internal.dsl.DexOptions(modelInfo), () -> ((AndroidBuilder)externalBuildContext.getAndroidBuilder()).getDexByteCodeConverter(), extractJarsTask, externalBuildAnchorTask, EnumSet.of(QualifiedContent.Scope.PROJECT), new SupplierTask<File>(){

            @Override
            public AndroidTask<?> getBuilderTask() {
                return null;
            }

            @Override
            public File get() {
                return androidManifestFile;
            }
        }, new SupplierTask<File>(){

            @Override
            public AndroidTask<?> getBuilderTask() {
                return null;
            }

            @Override
            public File get() {
                return processedAndroidResourcesFile;
            }
        }, false);
        extractJarsTask.dependsOn((TaskFactory)this.tasks, buildInfoLoaderTask);
        AndroidTask<PreColdSwapTask> preColdswapTask = instantRunTaskManager.createPreColdswapTask(this.project);
        if (variantScope.getInstantRunBuildContext().getPatchingPolicy() != InstantRunPatchingPolicy.PRE_LOLLIPOP) {
            instantRunTaskManager.createSlicerTask();
        }
        boolean multiDex = variantScope.getInstantRunBuildContext().getPatchingPolicy().useMultiDex();
        DexTransform dexTransform = new DexTransform((DexOptions)new DefaultDexOptions(), true, multiDex, null, variantScope.getPreDexOutputDir(), externalBuildContext.getAndroidBuilder(), this.project.getLogger(), variantScope.getInstantRunBuildContext(), AndroidGradleOptions.getBuildCache(variantScope.getGlobalScope().getProject()));
        transformManager.addTransform(this.tasks, variantScope, dexTransform);
        SigningConfig debugSigningConfig = new SigningConfig("debug");
        ExternalBuildPackagingScope packagingScope = new ExternalBuildPackagingScope(this.project, externalBuildContext, variantScope, transformManager, debugSigningConfig);
        AndroidTask<Task> createAssetsDirectory = this.androidTasks.create(this.tasks, new TaskConfigAction<Task>(){

            @Override
            public String getName() {
                return "createAssetsDirectory";
            }

            @Override
            public Class<Task> getType() {
                return Task.class;
            }

            @Override
            public void execute(Task task) {
                task.doLast(t -> FileUtils.mkdirs((File)variantScope.getAssetsDir()));
            }
        });
        AndroidTask<InstantRunSplitApkBuilder> splitApk = this.androidTasks.create(this.tasks, new InstantRunSplitApkBuilder.ConfigAction(packagingScope));
        for (TransformStream stream : transformManager.getStreams(StreamFilter.DEX)) {
            splitApk.dependsOn((TaskFactory)this.tasks, stream.getDependencies());
        }
        AndroidTask<PackageApplication> packageApp = this.androidTasks.create(this.tasks, new PackageApplication.StandardConfigAction(packagingScope, variantScope.getInstantRunBuildContext().getPatchingPolicy()));
        variantScope.setPackageApplicationTask(packageApp);
        packageApp.dependsOn((TaskFactory)this.tasks, createAssetsDirectory);
        for (TransformStream stream : transformManager.getStreams(StreamFilter.DEX)) {
            packageApp.dependsOn((TaskFactory)this.tasks, stream.getDependencies());
        }
        for (TransformStream stream : transformManager.getStreams(StreamFilter.RESOURCES)) {
            packageApp.dependsOn((TaskFactory)this.tasks, stream.getDependencies());
        }
        for (TransformStream stream : transformManager.getStreams(StreamFilter.NATIVE_LIBS)) {
            packageApp.dependsOn((TaskFactory)this.tasks, stream.getDependencies());
        }
        AndroidTask<InstantRunWrapperTask> buildInfoGeneratorTask = instantRunTaskManager.createBuildInfoGeneratorTask(packageApp);
        buildInfoGeneratorTask.dependsOn((TaskFactory)this.tasks, packageApp);
        externalBuildAnchorTask.dependsOn((TaskFactory)this.tasks, buildInfoGeneratorTask);
        for (AndroidTask<? extends DefaultTask> task : variantScope.getColdSwapBuildTasks()) {
            task.dependsOn((TaskFactory)this.tasks, preColdswapTask);
        }
    }
}

