/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.incremental.BuildInfoLoaderTask;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.AndroidTaskRegistry;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.SupplierTask;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.transforms.InstantRunDex;
import com.android.build.gradle.internal.transforms.InstantRunSlicer;
import com.android.build.gradle.internal.transforms.InstantRunTransform;
import com.android.build.gradle.internal.transforms.InstantRunVerifierTransform;
import com.android.build.gradle.internal.transforms.NoChangesVerifierTransform;
import com.android.build.gradle.tasks.CheckManifestInInstantRunMode;
import com.android.build.gradle.tasks.PreColdSwapTask;
import com.android.build.gradle.tasks.fd.FastDeployRuntimeExtractorTask;
import com.android.build.gradle.tasks.fd.GenerateInstantRunAppInfoTask;
import com.android.builder.core.DexByteCodeConverter;
import com.android.builder.core.DexOptions;
import com.android.builder.model.OptionalCompilationStep;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class InstantRunTaskManager {
    private AndroidTask<TransformTask> verifierTask;
    private AndroidTask<TransformTask> reloadDexTask;
    private final Logger logger;
    private final InstantRunVariantScope variantScope;
    private final TransformManager transformManager;
    private final AndroidTaskRegistry androidTasks;
    private final TaskFactory tasks;

    public InstantRunTaskManager(Logger logger, InstantRunVariantScope instantRunVariantScope, TransformManager transformManager, AndroidTaskRegistry androidTasks, TaskFactory tasks) {
        this.logger = logger;
        this.variantScope = instantRunVariantScope;
        this.transformManager = transformManager;
        this.androidTasks = androidTasks;
        this.tasks = tasks;
    }

    public AndroidTask<BuildInfoLoaderTask> createInstantRunAllTasks(DexOptions dexOptions, Supplier<DexByteCodeConverter> dexByteCodeConverter, AndroidTask<?> preTask, AndroidTask<?> anchorTask, Set<QualifiedContent.Scope> resMergingScopes, SupplierTask<File> instantRunMergedManifest, SupplierTask<File> processedResourcesOutputFile, boolean addResourceVerifier) {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        AndroidTask<BuildInfoLoaderTask> buildInfoLoaderTask = this.androidTasks.create(this.tasks, new BuildInfoLoaderTask.ConfigAction(this.variantScope, this.logger));
        InstantRunVerifierTransform verifierTransform = new InstantRunVerifierTransform(this.variantScope);
        this.verifierTask = this.transformManager.addTransform(this.tasks, transformVariantScope, verifierTransform);
        assert (this.verifierTask != null);
        this.verifierTask.dependsOn(this.tasks, preTask);
        NoChangesVerifierTransform jniLibsVerifierTransform = new NoChangesVerifierTransform(this.variantScope, (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.RESOURCES, (Object)((Object)ExtendedContentType.NATIVE_LIBS)), resMergingScopes, InstantRunVerifierStatus.JAVA_RESOURCES_CHANGED);
        AndroidTask<TransformTask> jniLibsVerifierTask = this.transformManager.addTransform(this.tasks, transformVariantScope, jniLibsVerifierTransform);
        assert (jniLibsVerifierTask != null);
        jniLibsVerifierTask.dependsOn(this.tasks, this.verifierTask);
        InstantRunTransform instantRunTransform = new InstantRunTransform(this.variantScope);
        AndroidTask<TransformTask> instantRunTask = this.transformManager.addTransform(this.tasks, transformVariantScope, instantRunTransform);
        assert (instantRunTask != null);
        AndroidTask<CheckManifestInInstantRunMode> checkManifestTask = this.androidTasks.create(this.tasks, new CheckManifestInInstantRunMode.ConfigAction(transformVariantScope, this.variantScope, instantRunMergedManifest, processedResourcesOutputFile));
        checkManifestTask.optionalDependsOn(this.tasks, instantRunMergedManifest.getBuilderTask(), processedResourcesOutputFile.getBuilderTask());
        instantRunTask.dependsOn(this.tasks, checkManifestTask);
        if (addResourceVerifier) {
            NoChangesVerifierTransform dependenciesVerifierTransform = new NoChangesVerifierTransform(this.variantScope, (Set<QualifiedContent.ContentType>)ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES), (Set<QualifiedContent.Scope>)Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT_LOCAL_DEPS, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.EXTERNAL_LIBRARIES}), InstantRunVerifierStatus.DEPENDENCY_CHANGED);
            AndroidTask<TransformTask> dependenciesVerifierTask = this.transformManager.addTransform(this.tasks, transformVariantScope, dependenciesVerifierTransform);
            assert (dependenciesVerifierTask != null);
            dependenciesVerifierTask.dependsOn(this.tasks, this.verifierTask);
            instantRunTask.dependsOn(this.tasks, dependenciesVerifierTask);
        }
        instantRunTask.dependsOn(this.tasks, buildInfoLoaderTask, this.verifierTask, jniLibsVerifierTask);
        AndroidTask<FastDeployRuntimeExtractorTask> extractorTask = this.androidTasks.create(this.tasks, new FastDeployRuntimeExtractorTask.ConfigAction(this.variantScope));
        extractorTask.dependsOn(this.tasks, buildInfoLoaderTask);
        this.transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJar(this.variantScope.getIncrementalRuntimeSupportJar()).setDependency((Object)extractorTask.get(this.tasks)).build());
        AndroidTask<GenerateInstantRunAppInfoTask> generateAppInfoAndroidTask = this.androidTasks.create(this.tasks, new GenerateInstantRunAppInfoTask.ConfigAction(transformVariantScope, this.variantScope, instantRunMergedManifest));
        GenerateInstantRunAppInfoTask generateInstantRunAppInfoTask = generateAppInfoAndroidTask.get(this.tasks);
        this.transformManager.addStream(OriginalStream.builder().addContentTypes(TransformManager.CONTENT_CLASS).addScope(QualifiedContent.Scope.EXTERNAL_LIBRARIES).setJar(generateInstantRunAppInfoTask.getOutputFile()).setDependency((Object)generateInstantRunAppInfoTask).build());
        generateAppInfoAndroidTask.optionalDependsOn(this.tasks, instantRunMergedManifest.getBuilderTask());
        anchorTask.dependsOn(this.tasks, instantRunTask);
        InstantRunDex reloadDexTransform = new InstantRunDex(this.variantScope, dexByteCodeConverter, dexOptions, this.logger);
        this.reloadDexTask = this.transformManager.addTransform(this.tasks, transformVariantScope, reloadDexTransform);
        anchorTask.dependsOn(this.tasks, this.reloadDexTask);
        return buildInfoLoaderTask;
    }

    public AndroidTask<PreColdSwapTask> createPreColdswapTask(Project project) {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunBuildContext context = this.variantScope.getInstantRunBuildContext();
        context.setApiLevel(AndroidGradleOptions.getTargetFeatureLevel(project), AndroidGradleOptions.getColdswapMode(project), AndroidGradleOptions.getBuildTargetAbi(project));
        context.setDensity(AndroidGradleOptions.getBuildTargetDensity(project));
        if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.FULL_APK)) {
            context.setVerifierResult(InstantRunVerifierStatus.FULL_BUILD_REQUESTED);
        } else if (transformVariantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY)) {
            context.setVerifierResult(InstantRunVerifierStatus.COLD_SWAP_REQUESTED);
        }
        AndroidTask<PreColdSwapTask> preColdSwapTask = this.androidTasks.create(this.tasks, new PreColdSwapTask.ConfigAction("preColdswap", transformVariantScope, this.variantScope));
        preColdSwapTask.dependsOn(this.tasks, this.verifierTask);
        return preColdSwapTask;
    }

    public void createSlicerTask() {
        TransformVariantScope transformVariantScope = this.variantScope.getTransformVariantScope();
        InstantRunSlicer slicer = new InstantRunSlicer(this.logger, this.variantScope);
        AndroidTask<TransformTask> slicing = this.transformManager.addTransform(this.tasks, transformVariantScope, slicer);
        this.variantScope.addColdSwapBuildTask(slicing);
    }

    public AndroidTask<InstantRunWrapperTask> createBuildInfoGeneratorTask(AndroidTask<?> ... dependencies) {
        AndroidTask<InstantRunWrapperTask> buildInfoGeneratorTask = this.androidTasks.create(this.tasks, new InstantRunWrapperTask.ConfigAction(this.variantScope, this.logger));
        buildInfoGeneratorTask.dependsOn(this.tasks, this.reloadDexTask);
        if (dependencies != null) {
            for (AndroidTask<?> dependency : dependencies) {
                buildInfoGeneratorTask.dependsOn(this.tasks, dependency);
            }
        }
        return buildInfoGeneratorTask;
    }
}

