/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.dependency.DependencyChecker;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.tasks.PrepareLibraryTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.ErrorReporter;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.DependencyContainerImpl;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.sdk.SdkLibData;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.gradle.util.GUtil;

public class DependencyManager {
    private static final boolean DEBUG_DEPENDENCY = false;
    private final Project project;
    private final ExtraModelInfo extraModelInfo;
    private final ILogger logger;
    private final SdkHandler sdkHandler;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private boolean repositoriesUpdated = false;
    private final Map<String, PrepareLibraryTask> prepareLibTaskMap = Maps.newHashMap();

    public DependencyManager(Project project, ExtraModelInfo extraModelInfo, SdkHandler sdkHandler) {
        this.project = project;
        this.extraModelInfo = extraModelInfo;
        this.sdkHandler = sdkHandler;
        this.logger = new LoggerWrapper(Logging.getLogger(DependencyManager.class));
    }

    public void addDependenciesToPrepareTask(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData, AndroidTask<PrepareDependenciesTask> prepareDependenciesTask) {
        VariantDependencies variantDeps = variantData.getVariantDependency();
        for (AndroidLibrary androidLibrary : variantDeps.getCompileDependencies().getAndroidDependencies()) {
            this.addDependencyToPrepareTask(tasks, androidLibrary, prepareDependenciesTask, variantData.getScope().getPreBuildTask());
        }
        for (AndroidLibrary androidLibrary : variantDeps.getPackageDependencies().getAndroidDependencies()) {
            this.addDependencyToPrepareTask(tasks, androidLibrary, prepareDependenciesTask, variantData.getScope().getPreBuildTask());
        }
    }

    private void addDependencyToPrepareTask(TaskFactory tasks, AndroidLibrary lib, AndroidTask<PrepareDependenciesTask> prepareDependenciesTask, AndroidTask<DefaultTask> preBuildTask) {
        PrepareLibraryTask prepareLibTask = this.prepareLibTaskMap.get(lib.getResolvedCoordinates().toString());
        if (prepareLibTask != null) {
            prepareDependenciesTask.dependsOn(tasks, new Object[]{prepareLibTask});
            prepareLibTask.dependsOn(new Object[]{preBuildTask.getName()});
        }
        for (AndroidLibrary childLib : lib.getLibraryDependencies()) {
            this.addDependencyToPrepareTask(tasks, childLib, prepareDependenciesTask, preBuildTask);
        }
    }

    public void resolveDependencies(VariantDependencies variantDeps, VariantDependencies testedVariantDeps, String testedProjectPath) {
        ArrayListMultimap reverseLibMap = ArrayListMultimap.create();
        this.resolveDependencyForConfig(variantDeps, testedVariantDeps, testedProjectPath, (Multimap<AndroidLibrary, Configuration>)reverseLibMap);
        this.processLibraries((Multimap<AndroidLibrary, Configuration>)reverseLibMap);
    }

    private void processLibraries(Multimap<AndroidLibrary, Configuration> reverseMap) {
        for (AndroidLibrary lib : reverseMap.keySet()) {
            this.setupPrepareLibraryTask(lib, reverseMap.get((Object)lib));
        }
    }

    private void setupPrepareLibraryTask(AndroidLibrary androidLibrary, Collection<Configuration> configurationList) {
        PrepareLibraryTask task = this.maybeCreatePrepareLibraryTask(androidLibrary, this.project);
        if (configurationList != null && !configurationList.isEmpty()) {
            for (Configuration configuration : configurationList) {
                task.dependsOn(new Object[]{configuration.getBuildDependencies()});
            }
        }
    }

    private PrepareLibraryTask maybeCreatePrepareLibraryTask(AndroidLibrary library, Project project) {
        LibraryDependency lib = (LibraryDependency)library;
        String key = library.getResolvedCoordinates().toString();
        PrepareLibraryTask prepareLibraryTask = this.prepareLibTaskMap.get(key);
        if (prepareLibraryTask == null) {
            String bundleName = GUtil.toCamelCase((CharSequence)lib.getName().replaceAll("\\:", " "));
            prepareLibraryTask = (PrepareLibraryTask)project.getTasks().create("prepare" + bundleName + "Library", PrepareLibraryTask.class);
            prepareLibraryTask.setDescription("Prepare " + lib.getName());
            prepareLibraryTask.setBundle(lib.getBundle());
            prepareLibraryTask.setExplodedDir(lib.getFolder());
            prepareLibraryTask.setVariantName("");
            this.prepareLibTaskMap.put(key, prepareLibraryTask);
        }
        return prepareLibraryTask;
    }

    private void resolveDependencyForConfig(VariantDependencies variantDeps, VariantDependencies testedVariantDeps, String testedProjectPath, Multimap<AndroidLibrary, Configuration> reverseLibMap) {
        boolean needPackageScope = true;
        if (AndroidGradleOptions.buildModelOnly(this.project)) {
            Integer modelLevelInt = AndroidGradleOptions.buildModelOnlyVersion(this.project);
            int modelLevel = 0;
            if (modelLevelInt != null) {
                modelLevel = modelLevelInt;
            }
            needPackageScope = modelLevel >= 2;
        }
        Configuration compileClasspath = variantDeps.getCompileConfiguration();
        Configuration packageClasspath = variantDeps.getPackageConfiguration();
        this.ensureConfigured(compileClasspath);
        if (needPackageScope) {
            this.ensureConfigured(packageClasspath);
        }
        HashSet currentUnresolvedDependencies = Sets.newHashSet();
        HashSet artifactSet = Sets.newHashSet();
        DependencyContainer packagedDependencies = needPackageScope ? this.gatherDependencies(packageClasspath, variantDeps, reverseLibMap, currentUnresolvedDependencies, testedProjectPath, artifactSet, ScopeType.PACKAGE) : DependencyContainerImpl.getEmpty();
        ScopeType scopeType = needPackageScope ? ScopeType.COMPILE : ScopeType.COMPILE_ONLY;
        DependencyContainer compileDependencies = this.gatherDependencies(compileClasspath, variantDeps, reverseLibMap, currentUnresolvedDependencies, testedProjectPath, artifactSet, scopeType);
        if (this.extraModelInfo.getMode() != ErrorReporter.EvaluationMode.STANDARD && compileClasspath.getResolvedConfiguration().hasError()) {
            for (String dependency : currentUnresolvedDependencies) {
                this.extraModelInfo.handleSyncError(dependency, 2, String.format("Unable to resolve dependency '%s'", dependency));
            }
        }
        if (needPackageScope) {
            variantDeps.getChecker().validate(compileDependencies, packagedDependencies, testedVariantDeps);
        }
        variantDeps.setDependencies(compileDependencies, packagedDependencies);
        this.configureBuild(variantDeps);
    }

    private DependencyContainer gatherDependencies(Configuration configuration, VariantDependencies variantDeps, Multimap<AndroidLibrary, Configuration> reverseLibMap, Set<String> currentUnresolvedDependencies, String testedProjectPath, Set<String> artifactSet, ScopeType scopeType) {
        HashMap artifacts = Maps.newHashMap();
        configuration = this.collectArtifacts(configuration, artifacts);
        HashMap foundLibraries = Maps.newHashMap();
        HashMap foundJars = Maps.newHashMap();
        ArrayList libraryDependencies = Lists.newArrayList();
        ArrayList jarDependencies = Lists.newArrayList();
        Set dependencyResultSet = configuration.getIncoming().getResolutionResult().getRoot().getDependencies();
        for (DependencyResult dependencyResult : dependencyResultSet) {
            ComponentSelector attempted;
            if (dependencyResult instanceof ResolvedDependencyResult) {
                this.addDependency(((ResolvedDependencyResult)dependencyResult).getSelected(), variantDeps, configuration, libraryDependencies, jarDependencies, foundLibraries, foundJars, artifacts, reverseLibMap, currentUnresolvedDependencies, testedProjectPath, Collections.emptyList(), artifactSet, scopeType, false, 0);
                continue;
            }
            if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
            currentUnresolvedDependencies.add(attempted.toString());
        }
        ArrayList localJars = Lists.newArrayList();
        for (Dependency dependency : configuration.getAllDependencies()) {
            if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
            Set files = ((SelfResolvingDependency)dependency).resolve();
            for (File localJarFile : files) {
                JarDependency localJar;
                if (!localJarFile.getName().toLowerCase(Locale.getDefault()).endsWith(".jar")) {
                    variantDeps.getChecker().handleIssue(localJarFile.getAbsolutePath(), 5, 2, String.format("Project %s: Only Jar-type local dependencies are supported. Cannot handle: %s", this.project.getName(), localJarFile.getAbsolutePath()));
                    continue;
                }
                switch (scopeType) {
                    case PACKAGE: {
                        localJar = new JarDependency(localJarFile);
                        artifactSet.add(DependencyChecker.computeVersionLessCoordinateKey(localJar.getResolvedCoordinates()));
                        break;
                    }
                    case COMPILE: {
                        MavenCoordinatesImpl coord = JarDependency.getCoordForLocalJar((File)localJarFile);
                        boolean provided = !artifactSet.contains(DependencyChecker.computeVersionLessCoordinateKey((MavenCoordinates)coord));
                        localJar = new JarDependency(localJarFile, (List)ImmutableList.of(), (MavenCoordinates)coord, null, provided);
                        break;
                    }
                    case COMPILE_ONLY: {
                        localJar = new JarDependency(localJarFile);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported ProvidedComputationAction");
                    }
                }
                localJars.add(localJar);
            }
        }
        return new DependencyContainerImpl((List)libraryDependencies, (Collection)jarDependencies, (Collection)localJars);
    }

    private void ensureConfigured(Configuration config) {
        for (Dependency dependency : config.getAllDependencies()) {
            if (!(dependency instanceof ProjectDependency)) continue;
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            this.project.evaluationDependsOn(projectDependency.getDependencyProject().getPath());
            try {
                this.ensureConfigured(projectDependency.getProjectConfiguration());
            }
            catch (Throwable e) {
                throw new UnknownProjectException(String.format("Cannot evaluate module %s : %s", projectDependency.getName(), e.getMessage()), e);
            }
        }
    }

    private Configuration collectArtifacts(Configuration configuration, Map<ModuleVersionIdentifier, List<ResolvedArtifact>> artifacts) {
        Set allArtifacts;
        Configuration configurationCopy = configuration.copyRecursive();
        Set unresolvedDependencies = configuration.getResolvedConfiguration().getLenientConfiguration().getUnresolvedModuleDependencies();
        if (unresolvedDependencies.isEmpty()) {
            allArtifacts = configuration.getResolvedConfiguration().getResolvedArtifacts();
        } else {
            if (!this.repositoriesUpdated && this.sdkLibData.useSdkDownload()) {
                ArrayList<String> repositoryPaths = new ArrayList<String>();
                for (Object dependency : unresolvedDependencies) {
                    if (!this.isGoogleOwnedDependency(dependency.getSelector())) continue;
                    repositoryPaths.add(DependencyManager.getRepositoryPath(dependency.getSelector()));
                }
                if (this.sdkHandler.shouldResetCache()) {
                    this.sdkLibData.setCacheExpirationPeriod(0L);
                    this.sdkHandler.setResetCache(false);
                } else {
                    this.sdkLibData.setCacheExpirationPeriod(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS);
                }
                List updatedRepositories = this.sdkHandler.getSdkLoader().updateRepositories(repositoryPaths, this.sdkLibData, this.logger);
                for (File updatedRepository : updatedRepositories) {
                    this.project.getRepositories().maven(newRepo -> {
                        newRepo.setName("Updated " + updatedRepository.getPath());
                        newRepo.setUrl((Object)updatedRepository.toURI());
                        newRepo.artifactUrls(new Object[]{this.project.getRootProject().file((Object)"sdk-manager")});
                    });
                }
                this.repositoriesUpdated = true;
            }
            allArtifacts = this.extraModelInfo.getMode() != ErrorReporter.EvaluationMode.STANDARD ? configurationCopy.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.satisfyAll()) : configurationCopy.getResolvedConfiguration().getResolvedArtifacts();
            configuration = configurationCopy;
        }
        for (ResolvedArtifact artifact : allArtifacts) {
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            ArrayList moduleArtifacts = artifacts.get(id);
            if (moduleArtifacts == null) {
                moduleArtifacts = Lists.newArrayList();
                artifacts.put(id, moduleArtifacts);
            }
            if (moduleArtifacts.contains(artifact)) continue;
            moduleArtifacts.add(artifact);
        }
        return configuration;
    }

    private static String getRepositoryPath(ModuleVersionSelector selector) {
        return DetailsTypes.MavenType.getRepositoryPath((String)selector.getGroup(), (String)selector.getName(), (String)selector.getVersion());
    }

    private boolean isGoogleOwnedDependency(ModuleVersionSelector selector) {
        return selector.getGroup().startsWith("com.android.") || selector.getGroup().startsWith("com.google.android.");
    }

    private static void printIndent(int indent, String message) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println(message);
    }

    private void addDependency(ResolvedComponentResult resolvedComponentResult, VariantDependencies configDependencies, Configuration configuration, Collection<LibraryDependency> outLibraries, List<JarDependency> outJars, Map<ModuleVersionIdentifier, List<LibraryDependency>> alreadyFoundLibraries, Map<ModuleVersionIdentifier, List<JarDependency>> alreadyFoundJars, Map<ModuleVersionIdentifier, List<ResolvedArtifact>> artifacts, Multimap<AndroidLibrary, Configuration> reverseLibMap, Set<String> currentUnresolvedDependencies, String testedProjectPath, List<String> projectChain, Set<String> artifactSet, ScopeType scopeType, boolean forceProvided, int indent) {
        block25: {
            ArrayList jarsForThisModule;
            ArrayList libsForThisModule;
            ModuleVersionIdentifier moduleVersion;
            block26: {
                block24: {
                    moduleVersion = resolvedComponentResult.getModuleVersion();
                    if (configDependencies.getChecker().checkForExclusion(moduleVersion)) {
                        return;
                    }
                    if (moduleVersion.getName().equals("support-annotations") && moduleVersion.getGroup().equals("com.android.support")) {
                        configDependencies.setAnnotationsPresent(true);
                    }
                    libsForThisModule = alreadyFoundLibraries.get(moduleVersion);
                    jarsForThisModule = alreadyFoundJars.get(moduleVersion);
                    if (libsForThisModule == null) break block24;
                    outLibraries.addAll(libsForThisModule);
                    for (AndroidLibrary lib : libsForThisModule) {
                        reverseLibMap.put((Object)lib, (Object)configuration);
                    }
                    break block25;
                }
                if (jarsForThisModule == null) break block26;
                outJars.addAll(jarsForThisModule);
                break block25;
            }
            ComponentIdentifier id = resolvedComponentResult.getId();
            String gradlePath = id instanceof ProjectComponentIdentifier ? ((ProjectComponentIdentifier)id).getProjectPath() : null;
            boolean childForceProvided = forceProvided;
            if (scopeType == ScopeType.COMPILE && testedProjectPath != null && testedProjectPath.equals(gradlePath)) {
                childForceProvided = true;
            }
            ArrayList nestedLibraries = Lists.newArrayList();
            ArrayList nestedJars = Lists.newArrayList();
            Set dependencies = resolvedComponentResult.getDependencies();
            for (DependencyResult dependencyResult : dependencies) {
                ComponentSelector attempted;
                if (dependencyResult instanceof ResolvedDependencyResult) {
                    ResolvedComponentResult selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
                    ArrayList newProjectChain = projectChain;
                    ComponentIdentifier identifier = selected.getId();
                    if (identifier instanceof ProjectComponentIdentifier) {
                        String projectPath = ((ProjectComponentIdentifier)identifier).getProjectPath();
                        int index = projectChain.indexOf(projectPath);
                        if (index != -1) {
                            projectChain.add(projectPath);
                            String path = Joiner.on((String)" -> ").join(projectChain.subList(index, projectChain.size()));
                            throw new CircularReferenceException("Circular reference between projects: " + path);
                        }
                        newProjectChain = Lists.newArrayList();
                        newProjectChain.addAll(projectChain);
                        newProjectChain.add(projectPath);
                    }
                    this.addDependency(selected, configDependencies, configuration, nestedLibraries, nestedJars, alreadyFoundLibraries, alreadyFoundJars, artifacts, reverseLibMap, currentUnresolvedDependencies, testedProjectPath, newProjectChain, artifactSet, scopeType, childForceProvided, indent + 1);
                    continue;
                }
                if (!(dependencyResult instanceof UnresolvedDependencyResult) || (attempted = ((UnresolvedDependencyResult)dependencyResult).getAttempted()) == null) continue;
                currentUnresolvedDependencies.add(attempted.toString());
            }
            List<ResolvedArtifact> moduleArtifacts = artifacts.get(moduleVersion);
            if (moduleArtifacts == null) break block25;
            for (ResolvedArtifact artifact : moduleArtifacts) {
                String name;
                MavenCoordinates mavenCoordinates = DependencyManager.createMavenCoordinates(artifact);
                boolean provided = forceProvided;
                String coordKey = DependencyChecker.computeVersionLessCoordinateKey(mavenCoordinates);
                if (scopeType == ScopeType.PACKAGE) {
                    artifactSet.add(coordKey);
                } else if (scopeType == ScopeType.COMPILE) {
                    provided |= !artifactSet.contains(coordKey);
                }
                if ("aar".equals(artifact.getExtension())) {
                    if (libsForThisModule == null) {
                        libsForThisModule = Lists.newArrayList();
                        alreadyFoundLibraries.put(moduleVersion, libsForThisModule);
                    }
                    String path = this.computeArtifactPath(moduleVersion, artifact);
                    String name2 = DependencyManager.computeArtifactName(moduleVersion, artifact);
                    File explodedDir = this.project.file((Object)(this.project.getBuildDir() + "/" + "intermediates" + "/exploded-aar/" + path));
                    LibraryDependency LibraryDependency2 = new LibraryDependency(artifact.getFile(), explodedDir, (List)nestedLibraries, (Collection)nestedJars, name2, artifact.getClassifier(), gradlePath, null, mavenCoordinates, provided);
                    libsForThisModule.add(LibraryDependency2);
                    outLibraries.add(LibraryDependency2);
                    reverseLibMap.put((Object)LibraryDependency2, (Object)configuration);
                    continue;
                }
                if ("jar".equals(artifact.getExtension())) {
                    if (!nestedLibraries.isEmpty()) {
                        if (testedProjectPath != null && testedProjectPath.equals(gradlePath)) {
                            if (scopeType == ScopeType.PACKAGE) {
                                DependencyManager.recursiveLibSkip(nestedLibraries);
                            } else {
                                provided = true;
                            }
                            outLibraries.addAll(nestedLibraries);
                        } else {
                            configDependencies.getChecker().handleIssue(DependencyManager.createMavenCoordinates(artifact).toString(), 8, 2, String.format("Module '%s' depends on one or more Android Libraries but is a jar", moduleVersion));
                        }
                    }
                    if (jarsForThisModule == null) {
                        jarsForThisModule = Lists.newArrayList();
                        alreadyFoundJars.put(moduleVersion, jarsForThisModule);
                    }
                    JarDependency jarDependency = new JarDependency(artifact.getFile(), (List)nestedJars, mavenCoordinates, gradlePath, provided);
                    if (scopeType == ScopeType.PACKAGE && testedProjectPath != null && testedProjectPath.equals(gradlePath)) {
                        jarDependency.skip();
                        DependencyManager.recursiveJavaSkip(jarDependency.getDependencies());
                    }
                    jarsForThisModule.add(jarDependency);
                    outJars.add(jarDependency);
                    continue;
                }
                if ("apk".equals(artifact.getExtension())) {
                    name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                    configDependencies.getChecker().handleIssue(name, 3, 2, String.format("Dependency %s on project %s resolves to an APK archive which is not supported as a compilation dependency. File: %s", name, this.project.getName(), artifact.getFile()));
                    continue;
                }
                if ("apklib".equals(artifact.getExtension())) {
                    name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                    configDependencies.getChecker().handleIssue(name, 4, 2, String.format("Packaging for dependency %s is 'apklib' and is not supported. Only 'aar' libraries are supported.", name));
                    continue;
                }
                name = DependencyManager.computeArtifactName(moduleVersion, artifact);
                this.logger.warning(String.format("Unrecognized dependency: '%s' (type: '%s', extension: '%s')", name, artifact.getType(), artifact.getExtension()), new Object[0]);
            }
        }
    }

    private static MavenCoordinates createMavenCoordinates(ResolvedArtifact resolvedArtifact) {
        return new MavenCoordinatesImpl(resolvedArtifact.getModuleVersion().getId().getGroup(), resolvedArtifact.getModuleVersion().getId().getName(), resolvedArtifact.getModuleVersion().getId().getVersion(), resolvedArtifact.getExtension(), resolvedArtifact.getClassifier());
    }

    private static void recursiveLibSkip(List<LibraryDependency> libs) {
        for (LibraryDependency lib : libs) {
            lib.skip();
            DependencyManager.recursiveLibSkip(lib.getLibraryDependencies());
            DependencyManager.recursiveJavaSkip((List)lib.getJavaDependencies());
        }
    }

    private static void recursiveJavaSkip(List<JarDependency> libs) {
        for (JarDependency lib : libs) {
            lib.skip();
            DependencyManager.recursiveJavaSkip(lib.getDependencies());
        }
    }

    private String computeArtifactPath(ModuleVersionIdentifier moduleVersion, ResolvedArtifact artifact) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getGroup())).append('/').append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getName())).append('/').append(DependencyManager.normalize(this.logger, moduleVersion, moduleVersion.getVersion()));
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            pathBuilder.append('/').append(DependencyManager.normalize(this.logger, moduleVersion, artifact.getClassifier()));
        }
        return pathBuilder.toString();
    }

    private static String computeArtifactName(ModuleVersionIdentifier moduleVersion, ResolvedArtifact artifact) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(moduleVersion.getGroup()).append(':').append(moduleVersion.getName()).append(':').append(moduleVersion.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            nameBuilder.append(':').append(artifact.getClassifier());
        }
        return nameBuilder.toString();
    }

    static String normalize(ILogger logger, ModuleVersionIdentifier id, String path) {
        if (path == null || path.isEmpty()) {
            logger.info(String.format("When unzipping library '%s:%s:%s, either group, name or version is empty", id.getGroup(), id.getName(), id.getVersion()), new Object[0]);
            return path;
        }
        String normalizedPath = path.replaceAll("[%<>:\"/?*\\\\]", "@");
        if (normalizedPath == null || normalizedPath.isEmpty()) {
            logger.info(String.format("When unzipping library '%s:%s:%s, the normalized '%s' is empty", id.getGroup(), id.getName(), id.getVersion(), path), new Object[0]);
            return path;
        }
        try {
            int pathPointer;
            String suffix = "";
            for (pathPointer = normalizedPath.length() - 1; pathPointer >= 0 && (normalizedPath.charAt(pathPointer) == '.' || normalizedPath.charAt(pathPointer) == ' '); --pathPointer) {
                suffix = suffix + "@";
            }
            if (pathPointer < 0) {
                throw new RuntimeException(String.format("When unzipping library '%s:%s:%s, the path '%s' cannot be transformed into a valid directory name", id.getGroup(), id.getName(), id.getVersion(), path));
            }
            return normalizedPath.substring(0, pathPointer + 1) + suffix;
        }
        catch (Exception e) {
            logger.error((Throwable)e, String.format("When unzipping library '%s:%s:%s', Path normalization failed for input %s", id.getGroup(), id.getName(), id.getVersion(), path), new Object[0]);
            return path;
        }
    }

    private void configureBuild(VariantDependencies configurationDependencies) {
        DependencyManager.addDependsOnTaskInOtherProjects(this.project.getTasks().getByName("buildNeeded"), true, "buildNeeded", "compile");
        DependencyManager.addDependsOnTaskInOtherProjects(this.project.getTasks().getByName("buildDependents"), false, "buildDependents", "compile");
    }

    private static void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    static enum ScopeType {
        PACKAGE,
        COMPILE,
        COMPILE_ONLY;

    }
}

