/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DexParser
implements PatternAwareOutputParser {
    static final String DEX_TOOL_NAME = "Dex";
    static final String DEX_LIMIT_EXCEEDED_ERROR = "The number of method references in a .dex file cannot exceed 64K.\nLearn how to resolve this issue at https://developer.android.com/tools/building/multidex.html";
    static final String COULD_NOT_CONVERT_BYTECODE_TO_DEX = "Error converting bytecode to dex:\nCause: %s";
    static final String INVALID_BYTE_CODE_VERSION = "Dex cannot parse version %1$d byte code.\nThis is caused by library dependencies that have been compiled using Java 8 or above.\nIf you are using the 'java' gradle plugin in a library submodule add \ntargetCompatibility = '1.7'\nsourceCompatibility = '1.7'\nto that submodule's build.gradle file.";
    private static final Pattern INVALID_BYTE_CODE_VERSION_EXCEPTION_PATTERN = Pattern.compile("com.android.dx.cf.iface.ParseException: bad class file magic \\(cafebabe\\) or version \\((\\d+)\\.\\d+\\).*");

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        if (line.startsWith("processing ") && line.endsWith("...")) {
            logger.verbose(line, new Object[0]);
            return true;
        }
        if (line.startsWith("writing ") && line.endsWith("size 0...")) {
            logger.verbose(line, new Object[0]);
            return true;
        }
        if (line.startsWith("ignored resource ") && line.endsWith("/")) {
            logger.verbose(line, new Object[0]);
            return true;
        }
        if (line.startsWith("trouble writing output: Too many method references:")) {
            StringBuilder original1 = new StringBuilder(line).append('\n');
            String nextLine = reader.readLine();
            while (!Strings.isNullOrEmpty((String)nextLine)) {
                original1.append(nextLine).append('\n');
                nextLine = reader.readLine();
            }
            messages.add(new Message(Message.Kind.ERROR, DEX_LIMIT_EXCEEDED_ERROR, original1.toString(), Optional.of((Object)DEX_TOOL_NAME), ImmutableList.of((Object)SourceFilePosition.UNKNOWN)));
            return true;
        }
        if (!line.equals("UNEXPECTED TOP-LEVEL EXCEPTION:")) {
            return false;
        }
        StringBuilder original = new StringBuilder(line).append('\n');
        String exception = reader.readLine();
        if (exception == null) {
            reader.pushBack();
            return false;
        }
        original.append(exception).append('\n');
        DexParser.consumeStacktrace(reader, original);
        String exceptionWithStacktrace = original.toString();
        if (exception.startsWith("com.android.dex.DexIndexOverflowException: method ID not in [0, 0xffff]: ")) {
            messages.add(new Message(Message.Kind.ERROR, DEX_LIMIT_EXCEEDED_ERROR, exceptionWithStacktrace, Optional.of((Object)DEX_TOOL_NAME), ImmutableList.of((Object)SourceFilePosition.UNKNOWN)));
            return true;
        }
        String cause = exception;
        Matcher invalidByteCodeVersion = INVALID_BYTE_CODE_VERSION_EXCEPTION_PATTERN.matcher(exceptionWithStacktrace);
        if (invalidByteCodeVersion.find()) {
            int bytecodeVersion = Integer.valueOf(invalidByteCodeVersion.group(1), 16);
            cause = String.format(INVALID_BYTE_CODE_VERSION, bytecodeVersion);
        }
        messages.add(new Message(Message.Kind.ERROR, String.format(COULD_NOT_CONVERT_BYTECODE_TO_DEX, cause), exceptionWithStacktrace, Optional.of((Object)DEX_TOOL_NAME), ImmutableList.of((Object)SourceFilePosition.UNKNOWN)));
        return true;
    }

    private static void consumeStacktrace(OutputLineReader reader, StringBuilder out) {
        String nextLine = reader.readLine();
        while (nextLine != null && (nextLine.startsWith("\t") || nextLine.startsWith("Caused by: "))) {
            out.append(nextLine).append('\n');
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            reader.pushBack();
        }
    }
}

