/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.processing;

import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedErrorReport;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;

public class ScopedException
extends RuntimeException {
    public static final String ERROR_LOG_PREFIX = "****/ data binding error ****";
    public static final String ERROR_LOG_SUFFIX = "****\\ data binding error ****";
    public static final String MSG_KEY = "msg:";
    public static final String LOCATION_KEY = "loc:";
    public static final String FILE_KEY = "file:";
    private static boolean sEncodeOutput = false;
    private ScopedErrorReport mScopedErrorReport;
    private String mScopeLog;

    public ScopedException(String message, Object ... args) {
        super(message == null ? "unknown data binding exception" : (args.length == 0 ? message : String.format(message, args)));
        this.mScopedErrorReport = Scope.createReport();
        this.mScopeLog = L.isDebugEnabled() ? Scope.produceScopeLog() : null;
    }

    ScopedException(String message, ScopedErrorReport scopedErrorReport) {
        super(message);
        this.mScopedErrorReport = scopedErrorReport;
    }

    public String getBareMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return sEncodeOutput ? this.createEncodedMessage() : this.createHumanReadableMessage();
    }

    private String createHumanReadableMessage() {
        ScopedErrorReport scopedError = this.getScopedErrorReport();
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage()).append("\n").append("file://").append(scopedError.getFilePath());
        if (scopedError.getLocations() != null && scopedError.getLocations().size() > 0) {
            sb.append(" Line:");
            sb.append(scopedError.getLocations().get((int)0).startLine);
        }
        sb.append("\n");
        return sb.toString();
    }

    private String createEncodedMessage() {
        ScopedErrorReport scopedError = this.getScopedErrorReport();
        StringBuilder sb = new StringBuilder();
        sb.append(ERROR_LOG_PREFIX).append(MSG_KEY).append(super.getMessage()).append("\n").append(FILE_KEY).append(scopedError.getFilePath()).append("\n");
        if (scopedError.getLocations() != null) {
            for (Location location : scopedError.getLocations()) {
                sb.append(LOCATION_KEY).append(location.toUserReadableString()).append("\n");
            }
        }
        sb.append(ERROR_LOG_SUFFIX);
        return Joiner.on((char)' ').join(Splitter.on((String)StringUtils.LINE_SEPARATOR).split((CharSequence)sb));
    }

    public ScopedErrorReport getScopedErrorReport() {
        return this.mScopedErrorReport;
    }

    public boolean isValid() {
        return this.mScopedErrorReport.isValid();
    }

    public static ScopedException createFromOutput(String output) {
        String message = "";
        String file = "";
        ArrayList<Location> locations = new ArrayList<Location>();
        int msgStart = output.indexOf(MSG_KEY);
        if (msgStart < 0) {
            message = output;
        } else {
            int fileStart = output.indexOf(FILE_KEY, msgStart + MSG_KEY.length());
            if (fileStart < 0) {
                message = output;
            } else {
                message = output.substring(msgStart + MSG_KEY.length(), fileStart);
                int locStart = output.indexOf(LOCATION_KEY, fileStart + FILE_KEY.length());
                if (locStart < 0) {
                    file = output.substring(fileStart + FILE_KEY.length());
                } else {
                    file = output.substring(fileStart + FILE_KEY.length(), locStart);
                    int nextLoc = 0;
                    while (nextLoc >= 0) {
                        nextLoc = output.indexOf(LOCATION_KEY, locStart + LOCATION_KEY.length());
                        Location loc = nextLoc < 0 ? Location.fromUserReadableString(output.substring(locStart + LOCATION_KEY.length())) : Location.fromUserReadableString(output.substring(locStart + LOCATION_KEY.length(), nextLoc));
                        if (loc != null && loc.isValid()) {
                            locations.add(loc);
                        }
                        locStart = nextLoc;
                    }
                }
            }
        }
        return new ScopedException(message.trim(), new ScopedErrorReport(Strings.isNullOrEmpty((String)file) ? null : file.trim(), locations));
    }

    public static List<ScopedException> extractErrors(String output) {
        ArrayList<ScopedException> errors = new ArrayList<ScopedException>();
        int index = output.indexOf(ERROR_LOG_PREFIX);
        int limit = output.length();
        while (index >= 0 && index < limit) {
            int end = output.indexOf(ERROR_LOG_SUFFIX, index + ERROR_LOG_PREFIX.length());
            if (end == -1) {
                errors.add(ScopedException.createFromOutput(output.substring(index + ERROR_LOG_PREFIX.length())));
                break;
            }
            errors.add(ScopedException.createFromOutput(output.substring(index + ERROR_LOG_PREFIX.length(), end)));
            index = output.indexOf(ERROR_LOG_PREFIX, end + ERROR_LOG_SUFFIX.length());
        }
        return errors;
    }

    public static void encodeOutput(boolean encodeOutput) {
        sEncodeOutput = encodeOutput;
    }

    public static boolean issEncodeOutput() {
        return sEncodeOutput;
    }
}

