/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;

public class UnorderedMapTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private final String myContainerName;

    private static boolean isDefaultHashFunction(String keyType, String hashFunction) {
        String defaultHashFunction = String.format("std::hash<%s%s>", keyType, TemplateParamsParser.spaceBetweenAngleBracket(keyType));
        return hashFunction.contentEquals(defaultHashFunction);
    }

    private static boolean isDefaultPredicateFunction(String keyType, String predicateFunction) {
        String defaultPredicateFunction = String.format("std::equal_to<%s%s>", keyType, TemplateParamsParser.spaceBetweenAngleBracket(keyType));
        return predicateFunction.contentEquals(defaultPredicateFunction);
    }

    private static boolean isDefaultAllocatorType(String keyType, String elementType, String allocatorType) {
        String constKeyType1 = "const " + keyType;
        String constKetType2 = keyType + " const";
        String dataTypeAngleBracketSpace = TemplateParamsParser.spaceBetweenAngleBracket(elementType);
        String defaultAllocatorType1 = String.format("std::allocator<std::pair<%s, %s%s> >", constKeyType1, elementType, dataTypeAngleBracketSpace);
        String defaultAllocatorType2 = String.format("std::allocator<std::pair<%s, %s%s> >", constKetType2, elementType, dataTypeAngleBracketSpace);
        return allocatorType.contentEquals(defaultAllocatorType1) || allocatorType.contentEquals(defaultAllocatorType2);
    }

    public UnorderedMapTypeNameFormatter(String containerName) {
        this.myContainerName = containerName;
    }

    @Override
    public String format(String typeName) {
        int numParams;
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(typeName);
        int n = numParams = templateParams == null ? 0 : templateParams.size();
        if (numParams < 2 || numParams > 5) {
            return typeName;
        }
        String keyType = templateParams.get(0);
        String elementType = templateParams.get(1);
        if (numParams >= 3 && !UnorderedMapTypeNameFormatter.isDefaultHashFunction(keyType, templateParams.get(2))) {
            return typeName;
        }
        if (numParams >= 4 && !UnorderedMapTypeNameFormatter.isDefaultPredicateFunction(keyType, templateParams.get(3))) {
            return typeName;
        }
        if (numParams == 5 && !UnorderedMapTypeNameFormatter.isDefaultAllocatorType(keyType, elementType, templateParams.get(4))) {
            return typeName;
        }
        TypeNameFormatterCategory.TypeNameFormatter keyTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(keyType);
        String formattedKeyType = keyTypeFormatter != null ? keyTypeFormatter.format(keyType) : keyType;
        TypeNameFormatterCategory.TypeNameFormatter elementTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(elementType);
        String formattedElementType = elementTypeFormatter != null ? elementTypeFormatter.format(elementType) : elementType;
        return String.format("%s<%s, %s%s>", this.myContainerName, formattedKeyType, formattedElementType, TemplateParamsParser.spaceBetweenAngleBracket(formattedElementType));
    }
}

