/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.google.common.collect.ImmutableSet;
import com.intellij.internal.statistic.analytics.AnalyticsUploader;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBUsageTracker {
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(AndroidNativeDeviceException.class, LLDBDriverException.class);

    private static void trackEvent(@NotNull String eventAction, @Nullable String eventLabel) {
        UsageTracker.getInstance().trackEvent("lldb", eventAction, eventLabel, null);
    }

    private static Throwable getRootCause(Throwable e) {
        int depth = 0;
        while (depth++ < 20) {
            if (e.getCause() == null) {
                return e;
            }
            e = e.getCause();
        }
        return e;
    }

    @Nullable
    private static String getExceptionDescription(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause = LLDBUsageTracker.getRootCause(e);
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(cause.getClass())) {
            return cause.getMessage();
        }
        return AnalyticsUploader.getDescription((Throwable)cause);
    }

    public static void trackDeviceModel(@NotNull String deviceModel) {
        LLDBUsageTracker.trackEvent("ro.product.model", deviceModel);
    }

    public static void trackDeviceAPILevel(@NotNull String deviceAPILevel) {
        LLDBUsageTracker.trackEvent("ro.build.version.sdk", deviceAPILevel);
    }

    public static void trackSessionStarted(@NotNull String configName) {
        LLDBUsageTracker.trackEvent("sessionStarted", configName);
    }

    public static void trackSessionFailed(@NotNull Throwable e) {
        LLDBUsageTracker.trackEvent("sessionFailed", LLDBUsageTracker.getExceptionDescription(e));
    }

    public static void trackInstallStarted() {
        LLDBUsageTracker.trackEvent("installStarted", null);
    }

    public static void trackInstallFailed(@Nullable Throwable e) {
        LLDBUsageTracker.trackEvent("installFailed", LLDBUsageTracker.getExceptionDescription(e));
    }

    public static void trackSessionUsedWatchpoints() {
        LLDBUsageTracker.trackEvent("sessionUsedWatchpoints", null);
    }

    public static void trackFrontendExited(int exitCode) {
        LLDBUsageTracker.trackEvent("frontendExited", Integer.toString(exitCode));
    }
}

