/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.JavaCallSignature;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.LibStdCppTypeNameFormatters;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final String[] STARTUP_SCRIPTS = new String[]{ModulePathManager.getRepoLLDBStlPrintersBinFile("load_script").getPath()};
    private static final int CONNECT_PLATFORM_NUM_RETRIES = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final Collection<File> mySymDirs;
    private final SessionStarter mySessionStarter;
    private String myPlatformConnectURL;
    @NotNull
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    private final AndroidFacet myFacet;
    private final Map<Module, Collection<VirtualFile>> myModuleSourceDirs;
    private boolean myCrashed = false;
    private final List<Abi> myClientABIs;
    private final boolean myDeviceSupportsWatchpoints;
    private static final Set<String> WATCHPOINT_WHITELISTED_MODELS = Sets.newHashSet((Object[])new String[]{"Nexus 9"});
    private static final Set<Abi> WATCHPOINT_WHITELISTED_ABIS = ImmutableSet.of((Object)Abi.X86, (Object)Abi.X86_64);
    private static final Set<Abi> ARM_ABIS = ImmutableSet.of((Object)Abi.ARMEABI, (Object)Abi.ARMEABI_V7A, (Object)Abi.ARM64_V8A);
    private boolean myReportedWatchpointsUsage = false;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AndroidLLDBDriverConfiguration configuration, @NotNull ConsolePrinter printer) {
        super(handler, (DebuggerDriverConfiguration)configuration);
        this.myFacet = facet;
        this.myModuleSourceDirs = this.collectModuleSourceDirs();
        IDevice device = configuration.getDevice();
        this.mySessionStarter = configuration.getSessionStarter();
        this.myStartupCommands = configuration.getStartupCommands();
        this.myPostAttachCommands = configuration.getPostAttachCommands();
        this.myClientABIs = configuration.getClientABIs();
        this.mySymDirs = AndroidNativeDebugProcess.getSymbolsDir(facet, debuggerState, this.myClientABIs);
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            printer.stderr("Attention! No symbol directories found - please check your native debug configuration");
        }
        this.myDeviceSupportsWatchpoints = AndroidLLDBDriver.deviceSupportsWatchpoints(device);
    }

    @NotNull
    private Map<Module, Collection<VirtualFile>> collectModuleSourceDirs() {
        HashMap moduleSourceDirs = Maps.newHashMap();
        HashSet dependencies = Sets.newHashSet();
        ModuleUtilCore.getDependencies((Module)this.myFacet.getModule(), (Set)dependencies);
        for (Module module : dependencies) {
            AndroidFacet facet;
            if (module == null || (facet = AndroidFacet.getInstance((Module)module)) == null) continue;
            IdeaSourceProvider srcProvider = facet.getMainIdeaSourceProvider();
            Collection javaDirs = srcProvider.getJavaDirectories();
            Collection jniDirs = srcProvider.getJniDirectories();
            ArrayList sourceDirs = Lists.newArrayListWithCapacity((int)(javaDirs.size() + jniDirs.size()));
            sourceDirs.addAll(javaDirs);
            sourceDirs.addAll(jniDirs);
            moduleSourceDirs.put(module, sourceDirs);
        }
        return moduleSourceDirs;
    }

    private static boolean deviceSupportsWatchpoints(@NotNull IDevice device) {
        String model = device.getProperty("ro.product.model");
        if (WATCHPOINT_WHITELISTED_MODELS.contains(model)) {
            return true;
        }
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null || !WATCHPOINT_WHITELISTED_ABIS.contains(abi)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getWatchpointWhitelist() {
        return String.format("%s based devices/emulators, %s", WATCHPOINT_WHITELISTED_ABIS, WATCHPOINT_WHITELISTED_MODELS);
    }

    @Nullable
    Long getValueAddress(int threadId, int frameNumber, LLValue value) {
        String addrExpr = String.format("&%s", value.getReferenceExpression());
        try {
            LLValue addrValue = this.evaluate(threadId, frameNumber, addrExpr);
            return Long.decode(addrValue.getValue());
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to get address of %s: %s", value, e));
            return null;
        }
    }

    public void loadForRemote(File deviceSupport) throws ExecutionException {
        LOG.debug("Load startup scripts");
        this.loadStartupScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runCommands("Startup", this.myStartupCommands);
        LOG.debug("connectPlatform");
        LLDBDriverException lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.connectPlatform();
                lastException = null;
                break;
            }
            catch (LLDBDriverException e2) {
                lastException = e2;
                LOG.warn("failed to connect platform - retrying");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        LOG.debug("createEmptyTarget");
        this.createEmptyTarget();
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath() + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Set target.exec-search-paths: " + searchPathsStr);
            this.executeConsoleCommand("settings set target.exec-search-paths " + searchPathsStr);
        }
    }

    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        super.setValuesFilteringEnabled(true);
    }

    private void runCommands(@NotNull String name, @NotNull List<String> commands) throws ExecutionException {
        for (String cmd : commands) {
            String trimmed_cmd = cmd.trim();
            if (trimmed_cmd.isEmpty()) continue;
            LOG.info(String.format("%s command: \"%s\"", name, trimmed_cmd));
            this.executeConsoleCommand(trimmed_cmd);
        }
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeConsoleCommand(envCommand);
            ++i;
        }
    }

    private void loadStartupScripts() throws ExecutionException {
        for (String script : STARTUP_SCRIPTS) {
            LOG.info("Loading startup script: " + script);
            this.executeConsoleCommand("command source \"" + script + "\"");
        }
    }

    private void createEmptyTarget() throws ExecutionException {
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't create target");
        Protocol.CompositeRequest createTargetReq = ProtobufMessageFactory.createTarget((String)"", (String)"");
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)createTargetReq, Protocol.CreateTarget_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    private void connectPlatform() throws ExecutionException {
        if (this.myPlatformConnectURL == null) {
            this.myPlatformConnectURL = this.mySessionStarter.startServer();
        }
        LOG.info("Connecting to LLDB server: " + this.myPlatformConnectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)this.myPlatformConnectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)connectPlatformReq, Protocol.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public void start(@NotNull Installer installer, @NotNull String architecture) throws ExecutionException {
        super.start(installer, architecture);
        AndroidLLDBBreakpadIntegration.monitorForCrashes(this);
    }

    @Nullable
    private Pair<Module, File> findModuleSourceFile(@NotNull String sourceFile) {
        for (Map.Entry<Module, Collection<VirtualFile>> moduleSourceDirs : this.myModuleSourceDirs.entrySet()) {
            for (VirtualFile srcDir : moduleSourceDirs.getValue()) {
                VirtualFile childFile = srcDir.findFileByRelativePath(sourceFile);
                if (childFile == null) continue;
                return Pair.create((Object)moduleSourceDirs.getKey(), (Object)new File(childFile.getCanonicalPath()));
            }
        }
        return null;
    }

    @NotNull
    protected Pair<Module, File> getModuleSourceFile(final @NotNull Model.LLDBFrame frame) {
        String sourceFile = frame.getFile();
        File sf = new File(frame.getFile());
        if (sf.isAbsolute()) {
            return Pair.create((Object)this.myFacet.getModule(), (Object)sf);
        }
        Pair moduleSrcFile = this.findModuleSourceFile(sourceFile);
        if (moduleSrcFile != null) {
            return moduleSrcFile;
        }
        moduleSrcFile = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<Module, File>>(){

            public Pair<Module, File> compute() {
                Pair p = AndroidLLDBDriver.this.parseJavaCallSignature(AndroidLLDBDriver.this.myModuleSourceDirs.keySet(), frame.getFunction());
                if (p == null) {
                    return null;
                }
                PsiMethod psiMethod = (PsiMethod)p.getSecond();
                try {
                    VirtualFile srcFile = psiMethod.getContainingFile().getVirtualFile();
                    if (srcFile != null) {
                        return Pair.create((Object)p.getFirst(), (Object)new File(srcFile.getCanonicalPath()));
                    }
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                return null;
            }
        });
        if (moduleSrcFile != null) {
            return moduleSrcFile;
        }
        return Pair.create((Object)this.myFacet.getModule(), (Object)sf);
    }

    @NotNull
    protected LLFrame newLLFrame(final @NotNull Model.LLDBFrame frame) {
        Pair location;
        String sourceFile = frame.getFile();
        Module sourceModule = this.myFacet.getModule();
        if (sourceFile != null && !sourceFile.isEmpty()) {
            Pair<Module, File> moduleSrcFile = this.getModuleSourceFile(frame);
            sourceModule = (Module)moduleSrcFile.getFirst();
            sourceFile = ((File)moduleSrcFile.getSecond()).getAbsolutePath();
        }
        final Module module = sourceModule;
        int line = frame.getLine() - 1;
        if (line < 0 && sourceFile != null && (location = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<String, Integer>>(){

            public Pair<String, Integer> compute() {
                Pair p = AndroidLLDBDriver.this.parseJavaCallSignature(Collections.singleton(module), frame.getFunction());
                if (p == null) {
                    return null;
                }
                PsiMethod psiMethod = (PsiMethod)p.getSecond();
                try {
                    VirtualFile srcFile = psiMethod.getContainingFile().getVirtualFile();
                    if (srcFile == null) {
                        return null;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(srcFile);
                    if (document == null) {
                        return null;
                    }
                    return Pair.create((Object)srcFile.getCanonicalPath(), (Object)document.getLineNumber(psiMethod.getTextOffset()));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        })) != null) {
            sourceFile = (String)location.getFirst();
            line = (Integer)location.getSecond();
        }
        return new LLFrame(frame.getNumber(), frame.getFunction(), sourceFile, line, frame.getPc(), AndroidLLDBDriver.convertLanguage((Model.Language)frame.getLanguage()));
    }

    @Nullable
    private Pair<Module, PsiMethod> parseJavaCallSignature(@NotNull Collection<Module> modules, @NotNull String callSignature) {
        JavaCallSignature signature = JavaCallSignature.Parse(callSignature);
        if (signature == null) {
            return null;
        }
        PsiClass psiClass = null;
        Module module = null;
        for (Module m : modules) {
            psiClass = AndroidPsiUtils.getPsiClass((Module)m, (String)signature.getClassName());
            if (psiClass == null) continue;
            module = m;
            break;
        }
        if (psiClass == null) {
            return null;
        }
        for (PsiMethod psiMethod : psiClass.findMethodsByName(signature.getMethodName(), true)) {
            PsiParameterList paramList;
            if (!psiMethod.getReturnType().equalsToText(signature.getReturnType()) || (paramList = psiMethod.getParameterList()).getParametersCount() != signature.getParameterList().size()) continue;
            PsiParameter[] psiParams = paramList.getParameters();
            boolean equalParameterTypes = true;
            for (int i = 0; i < psiParams.length && equalParameterTypes; ++i) {
                equalParameterTypes = psiParams[i].getType().equalsToText(signature.getParameterList().get(i));
            }
            if (!equalParameterTypes) continue;
            return Pair.create((Object)module, (Object)psiMethod);
        }
        return null;
    }

    public boolean isCrashed() {
        return this.myCrashed;
    }

    public void setCrashed(boolean crashed) {
        this.myCrashed = crashed;
    }

    @NotNull
    public LLWatchpoint addWatchpoint(int threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DBCannotSetBreakpointException {
        if (!this.myDeviceSupportsWatchpoints) {
            throw new DBCannotSetBreakpointException("You are debugging on a device that is not known to support watchpoints - supported devices include " + AndroidLLDBDriver.getWatchpointWhitelist());
        }
        if (!this.myReportedWatchpointsUsage) {
            this.myReportedWatchpointsUsage = true;
            LLDBUsageTracker.trackSessionUsedWatchpoints();
        }
        try {
            return super.addWatchpoint(threadId, frameNumber, value, expr, lifetime, accessType);
        }
        catch (DBCannotSetBreakpointException e) {
            Long valueAddr;
            Abi abi;
            if (!this.myClientABIs.isEmpty() && ARM_ABIS.contains(abi = this.myClientABIs.get(0)) && (valueAddr = this.getValueAddress(threadId, frameNumber, value)) != null && valueAddr % (long)abi.getAddressSizeInBytes() != 0L) {
                throw new DBCannotSetBreakpointException(String.format("%s - unaligned watchpoints are not supported on ARM yet, try __attribute__((aligned(%d))) %s;", e.getMessage(), abi.getAddressSizeInBytes(), value.getName()));
            }
            throw e;
        }
    }

    private boolean isTargetDead() {
        DebuggerDriver.TargetState targetState = this.getState();
        return targetState.equals((Object)DebuggerDriver.TargetState.FINISHED);
    }

    public void attachTo(int pid) throws ExecutionException {
        super.attachTo(pid);
        this.runCommands("Post attach", this.myPostAttachCommands);
    }

    public void detach() throws ExecutionException {
        if (this.isTargetDead()) {
            LOG.warn("Target is dead - skip detach request");
            return;
        }
        super.detach();
    }

    public boolean abort() throws ExecutionException {
        if (this.isTargetDead()) {
            LOG.warn("Target is dead - skip abort request");
            return false;
        }
        return super.abort();
    }

    protected void handleExited(int code) {
        super.handleExited(code);
        LLDBUsageTracker.trackFrontendExited(code);
    }

    static {
        LibStdCppTypeNameFormatters.register();
    }
}

