/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointHandler;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AndroidNativeHybridDebugProcessBase
extends AndroidNativeDebugProcess {
    private final StepIntoNativeBreakpointHandler myStepIntoNativeBreakpointHandler = this.createStepIntoNativeHandler();

    public AndroidNativeHybridDebugProcessBase(@NotNull Project project, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull AttachProgressReporter attachProgressReporter, boolean detachOnStop) throws ExecutionException {
        super(project, parameters, session, consoleBuilder, printer, sessionStarter, client, attachProgressReporter, detachOnStop);
    }

    @NotNull
    private StepIntoNativeBreakpointHandler createStepIntoNativeHandler() {
        return new StepIntoNativeBreakpointHandler(this, StepIntoNativeBreakpointType.class);
    }

    private void removeStepIntoNativeBreakpoint(XBreakpointManager bpManager, XBreakpoint<StepIntoNativeBreakpointType.Properties> bp) {
        bpManager.removeBreakpoint(bp);
        this.myStepIntoNativeBreakpointHandler.unregisterBreakpoint(bp, false);
    }

    @NotNull
    public XBreakpoint<StepIntoNativeBreakpointType.Properties> registerStepIntoNativeBreakpoint(@NotNull String jniMethodName, int tid) {
        final StepIntoNativeBreakpointType.Properties props = new StepIntoNativeBreakpointType.Properties(jniMethodName, tid);
        final Ref bpRef = new Ref();
        AndroidNativeHybridDebugProcessBase.getApp().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidNativeHybridDebugProcessBase.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        XBreakpoint bp = AndroidNativeHybridDebugProcessBase.this.getBreakpointManager().addBreakpoint((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE, (XBreakpointProperties)props);
                        AndroidNativeHybridDebugProcessBase.this.myStepIntoNativeBreakpointHandler.registerBreakpoint((XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                        bpRef.set((Object)bp);
                    }
                });
            }
        }, ModalityState.defaultModalityState());
        return (XBreakpoint)bpRef.get();
    }

    public void removeAllStepIntoNativeBreakpoints() {
        final LinkedList bps = Lists.newLinkedList();
        AndroidNativeHybridDebugProcessBase.getApp().runReadAction(new Runnable(){

            @Override
            public void run() {
                bps.addAll(AndroidNativeHybridDebugProcessBase.this.getBreakpointManager().getBreakpoints((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE));
            }
        });
        if (bps.isEmpty()) {
            return;
        }
        AndroidNativeHybridDebugProcessBase.getApp().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidNativeHybridDebugProcessBase.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        XBreakpointManager bpManager = AndroidNativeHybridDebugProcessBase.this.getBreakpointManager();
                        for (XBreakpoint bp : bps) {
                            AndroidNativeHybridDebugProcessBase.this.removeStepIntoNativeBreakpoint(bpManager, (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                        }
                    }
                });
            }
        }, ModalityState.defaultModalityState());
    }

    public void handleBreakpoint(int number, @NotNull List<LLThread> threads, int currentThreadIndex) {
        final XBreakpoint bp = this.myStepIntoNativeBreakpointHandler.getCodepoint(number);
        if (bp == null) {
            super.handleBreakpoint(number, threads, currentThreadIndex);
            return;
        }
        ((StepIntoNativeBreakpointType.Properties)bp.getProperties()).setCalled(true);
        AndroidNativeHybridDebugProcessBase.getApp().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AndroidNativeHybridDebugProcessBase.getApp().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        AndroidNativeHybridDebugProcessBase.this.removeStepIntoNativeBreakpoint(AndroidNativeHybridDebugProcessBase.this.getBreakpointManager(), (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                    }
                });
            }
        }, ModalityState.defaultModalityState());
        this.handleXBreakpoint(threads, currentThreadIndex, bp);
    }
}

