/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Variant;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.concurrency.FutureResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jdom.Element;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebuggerState
extends AndroidDebuggerState {
    private static final String SYMBOL_DIRS = "symbol_dirs";
    private static final String SYMBOL_PATH = "symbol_path";
    private static final String STARTUP_COMMANDS = "startup_commands";
    private static final String STARTUP_COMMANDS_ATTR = "startup_commands_attr";
    private static final String POST_ATTACH_COMMANDS = "post_attach_commands";
    private static final String POST_ATTACH_COMMANDS_ATTR = "post_attach_commands_attr";
    private static final String SDK_CHECK_FAIL_WARNING = "SDK check failed.";
    private List<String> mySymbolDirs = Lists.newLinkedList();
    private List<String> myUserStartupCommands = Lists.newLinkedList();
    private List<String> myUserPostAttachCommands = Lists.newLinkedList();
    public boolean USE_JAVA_AWARE_DEBUGGER;
    public String WORKING_DIR = "";
    public String TARGET_LOGGING_CHANNELS = "lldb process:gdb-remote packets";

    @NotNull
    public List<ValidationError> validate(@NotNull AndroidFacet facet, @Nullable Executor executor) {
        ArrayList errors = Lists.newArrayList();
        if (executor == null || !(executor instanceof DefaultDebugExecutor)) {
            return errors;
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)facet);
        if (androidModel != null && Projects.isBuildWithGradle((Module)facet.getModule())) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildTypeContainer = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildTypeContainer == null) {
                errors.add(ValidationError.fatal((String)("Build type " + selectedVariant.getBuildType() + " not found")));
                return errors;
            }
            BuildType buildType = buildTypeContainer.getBuildType();
            if (!buildType.isDebuggable()) {
                errors.add(ValidationError.fatal((String)"Build type isn't debuggable"));
            }
        } else {
            Manifest manifest = facet.getManifest();
            if (manifest == null) {
                errors.add(ValidationError.fatal((String)"Manifest is not found"));
                return errors;
            }
            if (!Boolean.valueOf((String)manifest.getApplication().getDebuggable().getValue()).booleanValue()) {
                errors.add(ValidationError.fatal((String)"Application is not debuggable"));
            }
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RepoManager mgr = AndroidSdkUtils.tryToChooseSdkHandler().getSdkManager((ProgressIndicator)progress);
        final FutureResult localResult = new FutureResult();
        final FutureResult remoteUnavailableResult = new FutureResult();
        final FutureResult remoteUpdateResult = new FutureResult();
        StudioProgressRunner runner = new StudioProgressRunner(false, true, false, "Updating LLDB status", false, facet.getModule().getProject());
        RepoManager.RepoLoadedCallback localCallback = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                LocalPackage p = (LocalPackage)packages.getLocalPackages().get(LLDBSdkPkgInstaller.COMPATIBLE_PKG_PATH);
                if (p == null) {
                    localResult.set((Object)ValidationError.fatal((String)"C++ debugger package is missing or incompatible", (Runnable)new LLDBSdkPkgInstaller()));
                } else {
                    localResult.set(null);
                }
            }
        };
        RepoManager.RepoLoadedCallback remoteCallback = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                UpdatablePackage p = (UpdatablePackage)packages.getConsolidatedPkgs().get(LLDBSdkPkgInstaller.COMPATIBLE_PKG_PATH);
                if (p == null || !p.hasRemote()) {
                    remoteUnavailableResult.set((Object)ValidationError.fatal((String)"C++ debugger package needs to be updated or installed but is unavailable"));
                    remoteUpdateResult.set(null);
                } else if (p.isUpdate()) {
                    remoteUpdateResult.set((Object)ValidationError.fatal((String)"C++ debugger is not up to date", (Runnable)new LLDBSdkPkgInstaller()));
                    remoteUnavailableResult.set(null);
                } else {
                    remoteUnavailableResult.set(null);
                    remoteUpdateResult.set(null);
                }
            }
        };
        Runnable errorCallback = new Runnable(){

            @Override
            public void run() {
                localResult.set((Object)ValidationError.warning((String)NativeAndroidDebuggerState.SDK_CHECK_FAIL_WARNING));
                remoteUnavailableResult.set((Object)ValidationError.warning((String)NativeAndroidDebuggerState.SDK_CHECK_FAIL_WARNING));
                remoteUpdateResult.set((Object)ValidationError.warning((String)NativeAndroidDebuggerState.SDK_CHECK_FAIL_WARNING));
            }
        };
        mgr.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)localCallback), (List)ImmutableList.of((Object)remoteCallback), (List)ImmutableList.of((Object)errorCallback), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
        try {
            ValidationError localError = (ValidationError)localResult.get();
            if (localError != null) {
                if (localError.getSeverity() == ValidationError.Severity.FATAL) {
                    errors.add(localError);
                } else {
                    ValidationError remoteError = (ValidationError)remoteUnavailableResult.get();
                    if (remoteError != null) {
                        errors.add(remoteError);
                    } else {
                        errors.add(localError);
                    }
                }
            } else {
                ValidationError remoteError = (ValidationError)remoteUpdateResult.get();
                if (remoteError != null) {
                    errors.add(remoteError);
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return errors;
    }

    @NotNull
    public List<String> getSymbolDirs() {
        return this.mySymbolDirs;
    }

    public void setSymbolDirs(@NotNull List<String> symDirs) {
        this.mySymbolDirs.clear();
        this.mySymbolDirs.addAll(symDirs);
    }

    public void addSymbolDir(@NotNull String symDir) {
        if (this.mySymbolDirs.indexOf(symDir) == -1) {
            this.mySymbolDirs.add(symDir);
        }
    }

    public boolean useJavaAwareDebugger() {
        return this.USE_JAVA_AWARE_DEBUGGER;
    }

    public void setUseJavaAwareDebugger(boolean useJavaAwareDebugger) {
        this.USE_JAVA_AWARE_DEBUGGER = useJavaAwareDebugger;
    }

    @NotNull
    public String getWorkingDir() {
        return this.WORKING_DIR;
    }

    public void setWorkingDir(@NotNull String workingDir) {
        this.WORKING_DIR = workingDir;
    }

    @NotNull
    public String getTargetLoggingChannels() {
        return this.TARGET_LOGGING_CHANNELS;
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        this.TARGET_LOGGING_CHANNELS = targetLoggingChannels;
    }

    @NotNull
    public List<String> getUserStartupCommands() {
        return this.myUserStartupCommands;
    }

    public void setUserStartupCommands(@NotNull Collection<String> userStartupCommands) {
        this.myUserStartupCommands.clear();
        this.myUserStartupCommands.addAll(userStartupCommands);
    }

    @NotNull
    public List<String> getUserPostAttachCommands() {
        return this.myUserPostAttachCommands;
    }

    public void setUserPostAttachCommands(@NotNull Collection<String> userPostAttachCommands) {
        this.myUserPostAttachCommands.clear();
        this.myUserPostAttachCommands.addAll(userPostAttachCommands);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySymbolDirs = JDOMExternalizer.loadStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH);
        this.myUserStartupCommands = JDOMExternalizer.loadStringsList((Element)element, (String)STARTUP_COMMANDS, (String)STARTUP_COMMANDS_ATTR);
        this.myUserPostAttachCommands = JDOMExternalizer.loadStringsList((Element)element, (String)POST_ATTACH_COMMANDS, (String)POST_ATTACH_COMMANDS_ATTR);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.saveStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH, (String[])this.mySymbolDirs.toArray(new String[0]));
        JDOMExternalizer.saveStringsList((Element)element, (String)STARTUP_COMMANDS, (String)STARTUP_COMMANDS_ATTR, (String[])this.myUserStartupCommands.toArray(new String[0]));
        JDOMExternalizer.saveStringsList((Element)element, (String)POST_ATTACH_COMMANDS, (String)POST_ATTACH_COMMANDS_ATTR, (String[])this.myUserPostAttachCommands.toArray(new String[0]));
    }
}

