/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.ndk.run.editor.ChooseSymbolDirectoryPanel;
import com.android.tools.ndk.run.editor.StringListEntryPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class NativeAndroidDebuggerPanel {
    private final Project myProject;
    private JPanel myPanel;
    private ChooseSymbolDirectoryPanel mySymDirsPanel;
    private TextFieldWithBrowseButton myWorkingDirField;
    private JTextField myLoggingTargetChannelsField;
    private JCheckBox myUseJavaAwareDebugger;
    private JBTabbedPane myOptionListsPane;
    private StringListEntryPanel myLldbStartupCommandsPanel;
    private StringListEntryPanel myLldbPostAttachCommandsPanel;

    public NativeAndroidDebuggerPanel(@NotNull Project project, boolean enableUseJavaAwareDebugger) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myWorkingDirField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myUseJavaAwareDebugger.setEnabled(enableUseJavaAwareDebugger);
        this.myLldbStartupCommandsPanel = this.buildOptionListTabPane("LLDB Startup Commands");
        this.myLldbPostAttachCommandsPanel = this.buildOptionListTabPane("LLDB Post Attach Commands");
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public boolean useJavaAwareDebugger() {
        return this.myUseJavaAwareDebugger.isSelected();
    }

    public void setUseJavaAwareDebugger(boolean useJavaAwareDebugger) {
        this.myUseJavaAwareDebugger.setSelected(useJavaAwareDebugger);
    }

    @NotNull
    public ChooseSymbolDirectoryPanel getSymbolDirectoryPanel() {
        return this.mySymDirsPanel;
    }

    @NotNull
    public String getWorkingDir() {
        return this.myWorkingDirField.getText();
    }

    public void setWorkingDir(@NotNull String workingDir) {
        this.myWorkingDirField.setText(workingDir);
    }

    @NotNull
    public String getTargetLoggingChannels() {
        String logChannels = this.myLoggingTargetChannelsField.getText().trim();
        return logChannels.replaceAll("[^a-z\\-\\s:]", "");
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        this.myLoggingTargetChannelsField.setText(targetLoggingChannels);
    }

    @NotNull
    public List<String> getUserStartupCommands() {
        return this.myLldbStartupCommandsPanel.getEntries();
    }

    public void setUserStartupCommands(@NotNull List<String> userStartupCommands) {
        this.myLldbStartupCommandsPanel.setEntries(userStartupCommands);
    }

    @NotNull
    public List<String> getUserPostAttachCommands() {
        return this.myLldbPostAttachCommandsPanel.getEntries();
    }

    public void setUserPostAttachCommands(@NotNull List<String> userPostAttachCommands) {
        this.myLldbPostAttachCommandsPanel.setEntries(userPostAttachCommands);
    }

    @NotNull
    private StringListEntryPanel buildOptionListTabPane(String tabName) {
        StringListEntryPanel panel = new StringListEntryPanel();
        this.myOptionListsPane.add(tabName, (Component)panel);
        return panel;
    }

    private void createUIComponents() {
        this.mySymDirsPanel = new ChooseSymbolDirectoryPanel(this.myProject);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTabbedPane jBTabbedPane;
        JCheckBox jCheckBox;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 4, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Host working directory:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myWorkingDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logging", 0, 0, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Target channels:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLoggingTargetChannelsField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUseJavaAwareDebugger = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Experimental: Use Java aware C++ debugger - Android N+ only");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptionListsPane = jBTabbedPane = new JBTabbedPane();
        jPanel.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Symbol Directories", null, jPanel4, null);
        ChooseSymbolDirectoryPanel chooseSymbolDirectoryPanel = this.mySymDirsPanel;
        jPanel4.add((Component)chooseSymbolDirectoryPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 2, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

