/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidJavaDebugger;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.hybrid.AndroidJavaDebugProcess;
import com.android.tools.ndk.run.hybrid.AndroidNativeHybridDebugProcess;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HybridAndroidDebugger
extends NativeAndroidDebugger {
    public static final String ID = "Hybrid";
    private static final Logger LOG = Logger.getInstance(HybridAndroidDebugger.class);

    public HybridAndroidDebugger() {
        super(HybridAndroidDebugger.getAllBreakpointTypes());
    }

    private static Set<Class<? extends XBreakpointType<?, ?>>> getAllBreakpointTypes() {
        HashSet breakpointTypeCls = Sets.newHashSet();
        breakpointTypeCls.addAll(AndroidJavaDebugger.JAVA_BREAKPOINT_TYPES);
        breakpointTypeCls.addAll(NativeAndroidDebugger.NATIVE_BREAKPOINT_TYPES);
        return breakpointTypeCls;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull AndroidRunConfigurationBase runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject(), false);
    }

    @Override
    public boolean supportsJavaAwareNativeDebugging(@NotNull AndroidVersion version) {
        return false;
    }

    @Override
    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession = HybridAndroidDebugger.findNativeDebugSession(project, client);
        if (nativeDebugSession == null) {
            return false;
        }
        final String debugPort = HybridAndroidDebugger.getClientDebugPort((Client)client);
        XDebugSession javaDebugSession = HybridAndroidDebugger.findXDebugSession(project, new NotNullFunction<XDebugProcess, Boolean>(){

            @NotNull
            public Boolean fun(XDebugProcess debugProcess) {
                if (!(debugProcess instanceof AndroidJavaDebugProcess)) {
                    return false;
                }
                AndroidJavaDebugProcess javaDebugProcess = (AndroidJavaDebugProcess)debugProcess;
                return debugPort.equals(javaDebugProcess.getDebuggerSession().getProcess().getConnection().getAddress().trim());
            }
        });
        if (nativeDebugSession == null || javaDebugSession == null) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, javaDebugSession);
            return false;
        }
        boolean result = HybridAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        if (!result) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, javaDebugSession);
        }
        return true;
    }

    private static void detachDebugSessions(@Nullable XDebugSession nativeDebugSession, @Nullable XDebugSession javaDebugSession) {
        if (nativeDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(nativeDebugSession);
        }
        if (javaDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(javaDebugSession);
        }
    }

    @Override
    @NotNull
    public AndroidNativeDebugProcess getAndroidNativeDebugProcess(final @NotNull Project project, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull AttachProgressReporter attachProgressReporter, boolean detachOnStop) throws ExecutionException {
        session.addSessionListener((XDebugSessionListener)new FrameContentSwitcher(session));
        final AndroidNativeHybridDebugProcess result = new AndroidNativeHybridDebugProcess(project, parameters, session, consoleBuilder, printer, sessionStarter, client, attachProgressReporter, detachOnStop);
        final JdwpConnector jdwpConnector = sessionStarter.getJdwpConnector();
        jdwpConnector.addSessionListener(new JdwpConnector.SessionListener(){

            @Override
            public void sessionCreated(final @NotNull DebuggerSession debuggerSession, @NotNull DebugUIEnvironment debugUIEnv) {
                jdwpConnector.removeSessionListener(this);
                try {
                    XDebugSession javaDebugSession = XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(debugUIEnv.getRunProfile().getName() + "-java", debugUIEnv.getReuseContent(), new XDebugProcessStarter(){

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session) {
                            return AndroidJavaDebugProcess.create(session, debuggerSession, result);
                        }
                    });
                    javaDebugSession.addSessionListener((XDebugSessionListener)new FrameContentSwitcher(javaDebugSession));
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        return result;
    }

    private static class FrameContentSwitcher
    extends XDebugSessionAdapter {
        private final XDebugSession myDebugSession;
        private boolean myFirstRun = true;

        public FrameContentSwitcher(XDebugSession debugSession) {
            this.myDebugSession = debugSession;
        }

        public void sessionPaused() {
            super.sessionPaused();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RunContentDescriptor descriptor = myDebugSession.getRunContentDescriptor();
                    ExecutionManager.getInstance((Project)myDebugSession.getProject()).getContentManager().toFrontRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
                    if (myFirstRun) {
                        RunnerLayoutUi ui = myDebugSession.getUI();
                        Content frameContent = ui.findContent("FrameContent");
                        if (frameContent != null) {
                            ui.selectAndFocus(frameContent, true, true);
                        }
                        myFirstRun = false;
                    }
                }
            }, ModalityState.defaultModalityState());
        }
    }
}

