/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.AndroidJavaDebugger;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.editor.AutoAndroidDebuggerState;
import com.android.tools.ndk.run.editor.HybridAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoAndroidDebugger
implements AndroidDebugger<AutoAndroidDebuggerState> {
    public static final String ID = "Auto";
    private HybridAndroidDebugger myHybridAndroidDebugger;
    private AndroidJavaDebugger myAndroidJavaDebugger;
    private NativeAndroidDebugger myNativeAndroidDebugger;

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return ID;
    }

    @NotNull
    public AutoAndroidDebuggerState createState() {
        return new AutoAndroidDebuggerState(this);
    }

    @NotNull
    public AndroidDebuggerConfigurable<AutoAndroidDebuggerState> createConfigurable(@NotNull AndroidRunConfigurationBase runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<AutoAndroidDebuggerState>(runConfiguration.getProject(), !(runConfiguration instanceof AndroidTestRunConfiguration));
    }

    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull AutoAndroidDebuggerState state, @NotNull String runConfigTypeId) {
        return this.getInternalDebugger(facet.getModule().getProject(), version, state.useJavaAwareDebugger()).getConnectDebuggerTask(env, version, applicationIds, facet, (AndroidDebuggerState)state, this.getId() + ":" + runConfigTypeId);
    }

    public boolean supportsProject(@NotNull Project project) {
        return this.getInternalDebugger(project).supportsProject(project);
    }

    public void attachToClient(@NotNull Project project, @NotNull Client client) {
        this.getInternalDebugger(project, client.getDevice().getVersion(), client.getClientData().isNativeDebuggable()).attachToClient(project, client);
    }

    @NotNull
    public Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes(@NotNull Project project, @NotNull AndroidVersion version) {
        return this.getInternalDebugger(project, version, true).getSupportedBreakpointTypes(project, version);
    }

    public boolean shouldBeDefault() {
        return true;
    }

    @NotNull
    public String getAmStartOptions(@NotNull AutoAndroidDebuggerState debuggerState, @NotNull Project project, @NotNull AndroidVersion version) {
        return this.getInternalDebugger(project, version, debuggerState.useJavaAwareDebugger()).getAmStartOptions((AndroidDebuggerState)debuggerState, project, version);
    }

    protected boolean isNativeProject(@NotNull Project project) {
        return NdkHelper.isNdkProject(project);
    }

    private void findDebuggers() {
        if (this.myHybridAndroidDebugger != null && this.myNativeAndroidDebugger != null && this.myAndroidJavaDebugger != null) {
            return;
        }
        for (AndroidDebugger debugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            if (debugger instanceof HybridAndroidDebugger) {
                this.myHybridAndroidDebugger = (HybridAndroidDebugger)debugger;
                continue;
            }
            if (debugger instanceof NativeAndroidDebugger) {
                this.myNativeAndroidDebugger = (NativeAndroidDebugger)debugger;
                continue;
            }
            if (!(debugger instanceof AndroidJavaDebugger)) continue;
            this.myAndroidJavaDebugger = (AndroidJavaDebugger)debugger;
        }
    }

    @NotNull
    private AndroidDebugger getInternalDebugger(@NotNull Project project) {
        return this.getInternalDebugger(project, null, true);
    }

    @NotNull
    private synchronized AndroidDebugger getInternalDebugger(@NotNull Project project, @Nullable AndroidVersion version, boolean useJavaAwareDebugger) {
        this.findDebuggers();
        if (!this.isNativeProject(project)) {
            return this.myAndroidJavaDebugger;
        }
        if (useJavaAwareDebugger && (version == null || version.getFeatureLevel() >= 24)) {
            return this.myNativeAndroidDebugger;
        }
        return this.myHybridAndroidDebugger;
    }
}

