/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import icons.CidrLangIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JniRelatedItemMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiElement[] targets;
        PsiMethod method;
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            String name = declarator.getName();
            if (name == null || !name.startsWith("Java_")) {
                return;
            }
            PsiMethod declaration = JniNameMangler.findDeclaration(declarator);
            if (declaration != null) {
                List<GotoRelatedItem> items = Collections.singletonList(new GotoRelatedItem((PsiElement)declaration));
                PsiElement nameIdentifier = declarator.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                TextRange textRange = nameIdentifier.getTextRange();
                ToJavaNavigationHandler handler = new ToJavaNavigationHandler();
                RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo((PsiElement)declarator, textRange, CidrLangIcons.AssocFile, 6, (Function)handler, (GutterIconNavigationHandler)handler, GutterIconRenderer.Alignment.LEFT, items);
                result.add((RelatedItemLineMarkerInfo)info);
            }
        } else if (element instanceof PsiMethod && (method = (PsiMethod)element).hasModifierProperty("native") && (targets = JniGotoDeclarationHandler.getGotoDeclarationTargets(element)) != null && targets.length > 0) {
            ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>(targets.length);
            for (PsiElement target : targets) {
                items.add(new GotoRelatedItem(target));
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            TextRange textRange = nameIdentifier.getTextRange();
            ToNativeNavigationHandler handler = new ToNativeNavigationHandler();
            RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo((PsiElement)method, textRange, CidrLangIcons.AssocFile, 6, (Function)handler, (GutterIconNavigationHandler)handler, GutterIconRenderer.Alignment.LEFT, items);
            result.add((RelatedItemLineMarkerInfo)info);
        }
    }

    private static class ToJavaNavigationHandler
    implements GutterIconNavigationHandler<OCDeclarator>,
    Function<OCDeclarator, String> {
        private ToJavaNavigationHandler() {
        }

        public void navigate(MouseEvent e, OCDeclarator declarator) {
            PsiMethod declaration = JniNameMangler.findDeclaration(declarator);
            if (declaration != null) {
                PsiNavigateUtil.navigate((PsiElement)declaration);
            }
        }

        public String fun(OCDeclarator declarator) {
            PsiMethod declaration = JniNameMangler.findDeclaration(declarator);
            if (declaration != null) {
                PsiClass containingClass = declaration.getContainingClass();
                return "Native declaration: " + declaration.getName() + (containingClass != null ? " in " + containingClass.getName() : "");
            }
            return null;
        }
    }

    private static class ToNativeNavigationHandler
    implements GutterIconNavigationHandler<PsiMethod>,
    Function<PsiMethod, String> {
        private ToNativeNavigationHandler() {
        }

        public void navigate(MouseEvent e, PsiMethod method) {
            PsiElement[] targets = JniGotoDeclarationHandler.getGotoDeclarationTargets((PsiElement)method);
            if (targets != null && targets.length != 0) {
                if (targets.length == 1) {
                    PsiNavigateUtil.navigate((PsiElement)targets[0]);
                } else {
                    JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])targets, (String)("<html>Choose target for <b>" + method.getName() + "<b></html>"));
                    popup.show(new RelativePoint(e));
                }
            }
        }

        public String fun(PsiMethod method) {
            return "JNI implementation: " + JniNameMangler.getJniMethodName(method);
        }
    }
}

