/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.PsiNavigateUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniMissingFunctionInspection
extends LocalInspectionTool {
    private static final String REGISTER_NATIVES = "RegisterNatives";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiElement[] targets;
                if (method.hasModifierProperty("native") && ((targets = JniGotoDeclarationHandler.getGotoDeclarationTargets((PsiElement)method)) == null || targets.length == 0)) {
                    Project project = holder.getProject();
                    if (JniMissingFunctionInspection.projectUsesRegisterNatives(project)) {
                        return;
                    }
                    String jniMethodName = JniNameMangler.getJniMethodName(method);
                    String message = String.format("Cannot resolve corresponding JNI function %1$s", jniMethodName);
                    LocalQuickFix[] fixes = new LocalQuickFix[]{new CreateJniFunctionFix(method, jniMethodName)};
                    if (!NdkHelper.isNdkProject(project)) {
                        fixes = LocalQuickFix.EMPTY_ARRAY;
                    }
                    holder.registerProblem((PsiElement)(method.getNameIdentifier() != null ? method.getNameIdentifier() : method), message, ProblemHighlightType.ERROR, fixes);
                }
            }
        };
    }

    private static boolean projectUsesRegisterNatives(Project project) {
        final Ref registersNatives = new Ref((Object)false);
        OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, (Processor)new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                PsiElement definition;
                if (symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                    PsiElement definition2;
                    OCFile containingOCFile = symbol.getContainingOCFile();
                    if (containingOCFile != null && (symbol = containingOCFile.findSymbol(JniMissingFunctionInspection.REGISTER_NATIVES, OCSymbolWithQualifiedName.class)) != null && (definition2 = symbol.locateDefinition()) != null) {
                        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)definition2.getProject());
                        Collection all = ReferencesSearch.search((PsiElement)definition2.getParent(), (SearchScope)scope).findAll();
                        if (!all.isEmpty()) {
                            registersNatives.set((Object)true);
                        }
                    }
                } else if ((symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (definition = symbol.locateDefinition()) != null) {
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)definition.getProject());
                    Collection all = ReferencesSearch.search((PsiElement)definition.getParent(), (SearchScope)scope).findAll();
                    if (!all.isEmpty()) {
                        registersNatives.set((Object)true);
                    }
                }
                return true;
            }
        }, (String)REGISTER_NATIVES);
        return (Boolean)registersNatives.get();
    }

    private static class CreateJniFunctionFix
    implements LocalQuickFix {
        private final PsiMethod myMethod;
        private final String myMethodName;

        public CreateJniFunctionFix(PsiMethod method, String methodName) {
            this.myMethod = method;
            this.myMethodName = methodName;
        }

        @NotNull
        public String getName() {
            return String.format("Create function %1$s", this.myMethodName);
        }

        @NotNull
        public String getFamilyName() {
            return "Create JNI function";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            OCFile file = this.findJniTargetFile(project);
            if (file == null) {
                Logger.getInstance(JniMissingFunctionInspection.class).warn("Can't create JNI file");
                return;
            }
            OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind((OCFile)file);
            this.createMethod(project, file, kind == OCLanguageKind.CPP, true);
        }

        private void createMethod(@NotNull Project project, @NotNull OCFile file, boolean cpp, boolean insertConversions) {
            String objName;
            StringBuilder sb = new StringBuilder();
            PsiType returnType = this.myMethod.getReturnType();
            String jniReturnType = null;
            sb.append("JNIEXPORT ");
            if (returnType != null) {
                jniReturnType = JniNameMangler.getJniType(returnType);
                sb.append(jniReturnType);
            } else {
                sb.append("void");
            }
            PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
            sb.append(" JNICALL");
            sb.append('\n');
            sb.append(this.myMethodName);
            sb.append("(JNIEnv* env, ");
            if (this.myMethod.hasModifierProperty("static")) {
                sb.append("jclass");
                objName = "type";
            } else {
                sb.append("jobject");
                objName = "instance";
            }
            sb.append(" ");
            while (CreateJniFunctionFix.hasParameterName(parameters, objName)) {
                objName = objName + "_";
            }
            sb.append(objName);
            StringBuilder allocate = new StringBuilder();
            StringBuilder deallocate = new StringBuilder();
            String envName = "env";
            while (CreateJniFunctionFix.hasParameterName(parameters, envName)) {
                envName = envName + "_";
            }
            if (parameters.length > 0) {
                for (PsiParameter parameter : parameters) {
                    sb.append(", ");
                    PsiType type = parameter.getType();
                    String jniType = JniNameMangler.getJniType(type);
                    String name = parameter.getName();
                    if (insertConversions) {
                        if ("jstring".equals(jniType)) {
                            name = CreateJniFunctionFix.convertString(parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jintArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jint", "Int", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jlongArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jlong", "Long", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jbooleanArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jboolean", "Boolean", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jdoubleArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jdouble", "Double", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jcharArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jchar", "Char", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jbyteArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jbyte", "Byte", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jshortArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jshort", "Short", parameters, name, envName, allocate, deallocate, cpp);
                        } else if ("jfloatArray".equals(jniType)) {
                            name = CreateJniFunctionFix.convertArray("jfloat", "Float", parameters, name, envName, allocate, deallocate, cpp);
                        }
                    }
                    sb.append(jniType);
                    sb.append(' ');
                    sb.append(name);
                }
            }
            sb.append(")\n{\n");
            sb.append((CharSequence)allocate);
            sb.append("\n // TODO\n\n");
            sb.append((CharSequence)deallocate);
            if (insertConversions && jniReturnType != null && "jstring".equals(jniReturnType)) {
                sb.append("\n");
                sb.append("return ").append(!cpp ? "(*" : "").append(envName).append(!cpp ? ")" : "").append("->NewStringUTF(").append(!cpp ? envName : "").append(!cpp ? ", " : "").append("returnValue);\n");
            }
            sb.append("}");
            String text = sb.toString();
            OCDeclaration declaration = OCElementFactory.declarationFromText((String)text, (PsiElement)file, (boolean)true);
            OCDeclaration added = (OCDeclaration)OCChangeUtil.add((PsiElement)file, (PsiElement)declaration);
            OCChangeUtil.reformatTextIfNotInjected((PsiFile)file, (int)added.getTextOffset(), (int)(added.getTextOffset() + added.getTextLength()));
            Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)added, PsiComment.class);
            if (comments.size() > 1) {
                PsiComment firstComment = (PsiComment)comments.iterator().next();
                PsiNavigateUtil.navigate((PsiElement)firstComment);
                TextRange textRange = firstComment.getTextRange();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor != null) {
                    editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                }
            } else {
                PsiNavigateUtil.navigate((PsiElement)added);
            }
        }

        private static boolean hasParameterName(PsiParameter[] parameters, String candidate) {
            for (PsiParameter parameter : parameters) {
                if (!candidate.equals(parameter.getName())) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private static String convertString(PsiParameter[] parameters, String name, String envName, StringBuilder allocate, StringBuilder deallocate, boolean cpp) {
            String tempName = CreateJniFunctionFix.findUniqueParameterName(parameters, name);
            allocate.append("const char *").append(name).append(" = ").append(!cpp ? "(*" : "").append(envName).append(!cpp ? ")" : "").append("->GetStringUTFChars(").append(!cpp ? envName : "").append(!cpp ? ", " : "").append(tempName).append(", 0);\n");
            deallocate.append(!cpp ? "(*" : "").append(envName).append(!cpp ? ")" : "").append("->ReleaseStringUTFChars(").append(!cpp ? envName : "").append(!cpp ? ", " : "").append(tempName).append(", ").append(name).append(");\n");
            return tempName;
        }

        @NotNull
        private static String convertArray(String elementType, String methodNameMiddle, PsiParameter[] parameters, String name, String envName, StringBuilder allocate, StringBuilder deallocate, boolean cpp) {
            String tempName = CreateJniFunctionFix.findUniqueParameterName(parameters, name);
            allocate.append(elementType).append(" *").append(name).append(" = ").append(!cpp ? "(*" : "").append(envName).append(!cpp ? ")" : "").append("->").append("Get").append(methodNameMiddle).append("ArrayElements").append("(").append(!cpp ? envName : "").append(!cpp ? ", " : "").append(tempName).append(", NULL);\n");
            deallocate.append(!cpp ? "(*" : "").append(envName).append(!cpp ? ")" : "").append("->").append("Release").append(methodNameMiddle).append("ArrayElements").append("(").append(!cpp ? envName : "").append(!cpp ? ", " : "").append(tempName).append(", ").append(name).append(", 0);\n");
            return tempName;
        }

        @NotNull
        private static String findUniqueParameterName(PsiParameter[] parameters, String name) {
            String tempName = name + "_";
            while (CreateJniFunctionFix.hasParameterName(parameters, tempName)) {
                tempName = tempName + "_";
            }
            return tempName;
        }

        @Nullable
        private OCFile findJniTargetFile(Project project) {
            OCFile existing = CreateJniFunctionFix.findFileWithJniFunctions(project);
            if (existing != null) {
                return existing;
            }
            return this.createNewTargetFile(project);
        }

        @Nullable
        private AndroidFacet pickModule() {
            AndroidFacet facet;
            Module module = AndroidPsiUtils.getModuleSafely((PsiElement)this.myMethod);
            if (module != null && (facet = AndroidFacet.getInstance((Module)module)) != null) {
                return facet;
            }
            for (Module m : ModuleManager.getInstance((Project)this.myMethod.getProject()).getModules()) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)m);
                if (facet2 == null) continue;
                return facet2;
            }
            return null;
        }

        @Nullable
        private OCFile createNewTargetFile(@NotNull Project project) {
            PsiFile file;
            SourceProvider provider;
            Collection cDirectories;
            AndroidFacet facet = this.pickModule();
            if (facet == null) {
                return null;
            }
            VirtualFile dir = null;
            PsiDirectory psiDirectory = null;
            if (facet.getAndroidModel() != null && !(cDirectories = (provider = facet.getMainSourceProvider()).getCDirectories()).isEmpty()) {
                File dirFile = (File)cDirectories.iterator().next();
                dir = LocalFileSystem.getInstance().findFileByIoFile(dirFile);
                if (dir == null) {
                    psiDirectory = DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)project), (String)FileUtil.toSystemIndependentName((String)dirFile.getPath()));
                    if (psiDirectory != null) {
                        dir = psiDirectory.getVirtualFile();
                    }
                } else {
                    psiDirectory = PsiManager.getInstance((Project)project).findDirectory(dir);
                }
            }
            if (dir == null || psiDirectory == null) {
                return null;
            }
            String fileName = this.pickFilename();
            VirtualFile newFile = dir.findChild(fileName);
            if (newFile == null) {
                OCNewFileHelperUtil.addCreatedFiles((PsiDirectory)psiDirectory, (String[])new String[]{fileName}, (PsiFile[])new PsiFile[]{null}, (Project)project, (Function)Function.NULL);
                newFile = dir.findChild(fileName);
                if (newFile == null) {
                    return null;
                }
                try {
                    VfsUtil.saveText((VirtualFile)newFile, (String)"#include <jni.h>\n");
                }
                catch (IOException ioe) {
                    Logger.getInstance(JniMissingFunctionInspection.class).error((Throwable)ioe);
                    return null;
                }
            }
            if ((file = PsiManager.getInstance((Project)project).findFile(newFile)) instanceof OCFile) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = documentManager.getDocument(file);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
                return (OCFile)file;
            }
            return null;
        }

        @NotNull
        private String pickFilename() {
            PsiClass cls;
            PsiFile containingFile = this.myMethod.getContainingFile();
            if (containingFile != null) {
                for (PsiMethodCallExpression expression : PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, PsiMethodCallExpression.class)) {
                    PsiLiteralExpression literal;
                    Object value;
                    PsiExpression[] argumentList;
                    String qualifiedName;
                    PsiMethod method;
                    PsiClass cls2;
                    PsiElement resolved;
                    PsiReferenceExpression methodExpression = expression.getMethodExpression();
                    String referenceName = methodExpression.getReferenceName();
                    if (!"loadLibrary".equals(referenceName) || (resolved = methodExpression.resolve()) instanceof PsiMethod && (cls2 = (method = (PsiMethod)resolved).getContainingClass()) != null && (qualifiedName = cls2.getQualifiedName()) != null && !qualifiedName.equals("java.lang.System") || (argumentList = expression.getArgumentList().getExpressions()).length != 1 || !(argumentList[0] instanceof PsiLiteralExpression) || !((value = (literal = (PsiLiteralExpression)argumentList[0]).getValue()) instanceof String)) continue;
                    String name = (String)value;
                    StringBuilder sb = new StringBuilder();
                    int n = name.length();
                    for (int i = 0; i < n; ++i) {
                        char c = name.charAt(i);
                        if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_' && c != '-') continue;
                        sb.append(c);
                    }
                    if (sb.length() <= 0) continue;
                    sb.append(".c");
                    return sb.toString();
                }
            }
            if ((cls = this.myMethod.getContainingClass()) != null) {
                return cls.getName().toLowerCase(Locale.US) + ".c";
            }
            return "jni.c";
        }

        @Nullable
        private static OCFile findFileWithJniFunctions(@NotNull Project project) {
            final Ref ref = new Ref();
            for (String symbol : OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)project)) {
                if (!symbol.startsWith("Java_")) continue;
                Processor<OCSymbol> processor = new Processor<OCSymbol>(){

                    public boolean process(OCSymbol symbol) {
                        OCFile containing;
                        if ((symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (containing = symbol.getContainingOCFile()) != null) {
                            ref.set((Object)containing);
                            return false;
                        }
                        return true;
                    }
                };
                OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)project, (Processor)processor, (String)symbol);
                OCFile file = (OCFile)ref.get();
                if (file == null) continue;
                return file;
            }
            return null;
        }
    }
}

