/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.cdt.utils.debug.dwarf.DwarfReader;
import org.eclipse.cdt.utils.elf.Elf;
import org.jetbrains.annotations.NotNull;

public class SourceRootsExtractor {
    private static final Logger LOG = Logger.getInstance(SourceRootsExtractor.class);

    @NotNull
    public static List<String> extractSourceRootsFromDirectory(@NotNull File symbolDir) {
        if (!symbolDir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<String> sourceRoots = new ArrayList<String>();
        File[] children = symbolDir.listFiles();
        if (children != null) {
            for (File file : children) {
                if (file.isDirectory() || !file.exists()) continue;
                sourceRoots.addAll(SourceRootsExtractor.extractSourceRootsFromLibrary(file));
            }
        }
        return SourceRootsExtractor.mergeRoots(sourceRoots);
    }

    @NotNull
    private static List<String> extractSourceRootsFromLibrary(@NotNull File file) {
        String[] sourceFiles;
        try {
            Elf elf = new Elf(file.getPath());
            Elf.Section debugInfo = elf.getSectionByName(".debug_info");
            if (debugInfo == null) {
                LOG.info("No debug info in the ELF lib");
                return Collections.emptyList();
            }
            DwarfReader reader = new DwarfReader(elf);
            sourceFiles = reader.getSourceFiles();
        }
        catch (IOException e) {
            LOG.error("Parsing ELF lib error: " + e);
            return Collections.emptyList();
        }
        if (sourceFiles == null) {
            LOG.info("No source files can be found in ELF lib");
            return Collections.emptyList();
        }
        return SourceRootsExtractor.computeSourceRootsForFiles(sourceFiles);
    }

    @VisibleForTesting
    @NotNull
    protected static List<String> computeSourceRootsForFiles(@NotNull String[] sourceFiles) {
        ArrayList<String> directories = new ArrayList<String>(sourceFiles.length);
        for (String sourceFile : sourceFiles) {
            directories.add(PathUtil.getParentPath((String)sourceFile));
        }
        return SourceRootsExtractor.mergeRoots(directories);
    }

    @NotNull
    public static List<String> mergeRoots(@NotNull List<String> roots) {
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<String> sortedRoots = new TreeSet<String>(roots);
        ArrayList<String> result = new ArrayList<String>(roots.size());
        String current = (String)sortedRoots.first();
        for (String folder : sortedRoots) {
            if (folder.startsWith(current)) continue;
            result.add(current);
            current = folder;
        }
        result.add(current);
        return result;
    }
}

