/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.ndk.run.lldb.LLDBSdkPkgInstaller;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class ModulePathManager {
    @NotNull
    public static File getRepoLLDBBinFile(@NotNull String relativePath) {
        File lldbBin = new File(PathManager.getBinPath(), "lldb");
        File file = new File(lldbBin, relativePath);
        if (file.exists()) {
            return file;
        }
        return new File(new File(PathManager.getHomePath(), "../vendor/google/android-ndk/bin/lldb"), relativePath);
    }

    @NotNull
    public static File getSdkLLDBDir() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ModulePathManager.class);
        String path = DetailsTypes.getLldbPath((Revision)LLDBSdkPkgInstaller.PINNED_REVISION);
        LocalPackage p = AndroidSdkUtils.tryToChooseSdkHandler().getLocalPackage(path, (ProgressIndicator)progress);
        if (p == null) {
            throw new IllegalStateException("LLDB package hasn't been found");
        }
        return p.getLocation();
    }

    @NotNull
    public static File getSdkLLDBFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getSdkLLDBDir(), relativePath);
    }

    @NotNull
    public static File getSdkLLDBAndroidFile(@NotNull String relativePath) {
        return new File(new File(ModulePathManager.getSdkLLDBDir(), "android"), relativePath);
    }

    @NotNull
    public static File getRepoLLDBSharedBinFile(@NotNull String relativePath) {
        return ModulePathManager.getRepoLLDBBinFile(new File("shared", relativePath).getPath());
    }

    @NotNull
    public static File getRepoLLDBStlPrintersFolder() {
        return ModulePathManager.getRepoLLDBSharedBinFile("stl_printers");
    }

    @NotNull
    public static File getRepoLLDBStlPrintersBinFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getRepoLLDBStlPrintersFolder(), relativePath);
    }
}

