/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyReferenceBase
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.references.PropertyReferenceBase");
    protected final String myKey;
    protected final PsiElement myElement;
    protected boolean mySoft;
    private final TextRange myTextRange;

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element) {
        this(key, soft, element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element, TextRange range) {
        this.myKey = key;
        this.mySoft = soft;
        this.myElement = element;
        this.myTextRange = range;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    protected String getKeyText() {
        return this.myKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReferenceBase other = (PropertyReferenceBase)o;
        return this.getElement() == other.getElement() && this.getKeyText().equals(other.getKeyText());
    }

    public int hashCode() {
        return this.getKeyText().hashCode();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myKey;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        if (manipulator == null) {
            LOG.error("Cannot find manipulator for " + this.myElement + " of class " + this.myElement.getClass());
        }
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("not implemented");
    }

    public boolean isReferenceTo(PsiElement element) {
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement el = result.getElement();
            if (el == null || !el.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    protected void addKey(Object property, Set<Object> variants) {
        variants.add(property);
    }

    protected void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return PropertiesBundle.message("unresolved.property.key", new Object[0]);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ArrayList<IProperty> properties;
        String key = this.getKeyText();
        List<PropertiesFile> propertiesFiles = this.getPropertiesFiles();
        if (propertiesFiles == null) {
            properties = PropertiesImplUtil.findPropertiesByKey(this.getElement().getProject(), key);
        } else {
            properties = new ArrayList();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
        }
        ContainerUtil.quickSort(properties, (Comparator)new Comparator<IProperty>(){

            @Override
            public int compare(IProperty o1, IProperty o2) {
                String name1 = o1.getPropertiesFile().getName();
                String name2 = o2.getPropertiesFile().getName();
                return Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
            }
        });
        return PropertyReferenceBase.getResolveResults(properties);
    }

    protected static ResolveResult[] getResolveResults(List<IProperty> properties) {
        if (properties.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            IProperty property = properties.get(i);
            results[i] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
        }
        return results;
    }

    @Nullable
    protected abstract List<PropertiesFile> getPropertiesFiles();

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

