/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesAnchorizer;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleFileStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final ResourceBundle myResourceBundle;
    private boolean myShowOnlyIncomplete;
    private final PropertiesAnchorizer myAnchorizer;

    public ResourceBundleFileStructureViewElement(ResourceBundle resourceBundle, PropertiesAnchorizer anchorizer) {
        this.myResourceBundle = resourceBundle;
        this.myAnchorizer = anchorizer;
    }

    public void setShowOnlyIncomplete(boolean showOnlyIncomplete) {
        this.myShowOnlyIncomplete = showOnlyIncomplete;
    }

    public boolean isShowOnlyIncomplete() {
        return this.myShowOnlyIncomplete;
    }

    public ResourceBundle getValue() {
        return this.myResourceBundle;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        MultiMap<String, IProperty> propertyNames = ResourceBundleFileStructureViewElement.getPropertiesMap(this.myResourceBundle, this.myShowOnlyIncomplete);
        ArrayList<ResourceBundlePropertyStructureViewElement> result = new ArrayList<ResourceBundlePropertyStructureViewElement>(propertyNames.size());
        for (Map.Entry entry : propertyNames.entrySet()) {
            Collection properties = (Collection)entry.getValue();
            PropertiesAnchorizer.PropertyAnchor anchor = this.myAnchorizer.createOrUpdate(properties);
            result.add(new ResourceBundlePropertyStructureViewElement(this.myResourceBundle, anchor));
        }
        return result.toArray(new StructureViewTreeElement[result.size()]);
    }

    public static MultiMap<String, IProperty> getPropertiesMap(ResourceBundle resourceBundle, boolean onlyIncomplete) {
        MultiMap<String, IProperty> propertyNames;
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        if (onlyIncomplete) {
            propertyNames = ResourceBundleFileStructureViewElement.getChildrenIdShowOnlyIncomplete(resourceBundle);
        } else {
            propertyNames = MultiMap.createLinked();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                List<IProperty> properties = propertiesFile.getProperties();
                for (IProperty property : properties) {
                    String name = property.getKey();
                    propertyNames.putValue((Object)name, (Object)property);
                }
            }
        }
        return propertyNames;
    }

    private static MultiMap<String, IProperty> getChildrenIdShowOnlyIncomplete(ResourceBundle resourceBundle) {
        final MultiMap propertyNames = MultiMap.createLinked();
        TObjectIntHashMap occurrences = new TObjectIntHashMap();
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            MultiMap currentFilePropertyNames = MultiMap.createLinked();
            for (IProperty property : file.getProperties()) {
                String name = property.getKey();
                currentFilePropertyNames.putValue((Object)name, (Object)property);
            }
            propertyNames.putAllValues(currentFilePropertyNames);
            for (String propertyName : currentFilePropertyNames.keySet()) {
                if (occurrences.contains((Object)propertyName)) {
                    occurrences.adjustValue((Object)propertyName, 1);
                    continue;
                }
                occurrences.put((Object)propertyName, 1);
            }
        }
        final int targetOccurrences = resourceBundle.getPropertiesFiles().size();
        occurrences.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String propertyName, int occurrences) {
                if (occurrences == targetOccurrences) {
                    propertyNames.remove((Object)propertyName);
                }
                return true;
            }
        });
        return propertyNames;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundleFileStructureViewElement.this.myResourceBundle.getBaseName();
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.Properties;
            }
        };
    }

    @Override
    @Nullable
    public IProperty[] getProperties() {
        return new IProperty[0];
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        List<PropertiesFile> files = this.getValue().getPropertiesFiles();
        return (PsiFile[])ContainerUtil.map2Array(files, (Object[])new PsiFile[files.size()], (Function)new Function<PropertiesFile, PsiFile>(){

            public PsiFile fun(PropertiesFile propertiesFile) {
                return propertiesFile.getContainingFile();
            }
        });
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

