/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManagerState;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ResourceBundleManager", storages={@Storage(value="resourceBundles.xml")})
public class ResourceBundleManager
implements PersistentStateComponent<ResourceBundleManagerState> {
    private static final Logger LOG = Logger.getInstance(ResourceBundleManager.class);
    private ResourceBundleManagerState myState = new ResourceBundleManagerState();

    public ResourceBundleManager(PsiManager manager) {
        manager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(final @NotNull PsiTreeChangeEvent event) {
                PsiElement child = event.getChild();
                if (!(child instanceof PsiFile)) {
                    if (child instanceof PsiDirectory && event.getOldParent() instanceof PsiDirectory && event.getNewParent() instanceof PsiDirectory) {
                        String fromDirUrl = ((PsiDirectory)event.getOldParent()).getVirtualFile().getUrl() + "/";
                        NotNullLazyValue<String> toDirUrl = new NotNullLazyValue<String>(){

                            @NotNull
                            protected String compute() {
                                return ((PsiDirectory)event.getNewParent()).getVirtualFile().getUrl() + "/";
                            }
                        };
                        for (String dissociatedFileUrl : new SmartList(ResourceBundleManager.this.myState.getDissociatedFiles())) {
                            if (!dissociatedFileUrl.startsWith(fromDirUrl)) continue;
                            ResourceBundleManager.this.myState.getDissociatedFiles().remove(dissociatedFileUrl);
                            ResourceBundleManager.this.myState.getDissociatedFiles().add((String)toDirUrl.getValue() + dissociatedFileUrl.substring(fromDirUrl.length()));
                        }
                        for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                            for (String fileUrl : new SmartList(customResourceBundleState.getFileUrls())) {
                                if (!fileUrl.startsWith(fromDirUrl)) continue;
                                customResourceBundleState.getFileUrls().remove(fileUrl);
                                customResourceBundleState.getFileUrls().add((String)toDirUrl.getValue() + fileUrl.substring(fromDirUrl.length()));
                            }
                        }
                    }
                    return;
                }
                final PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)child);
                if (propertiesFile == null) {
                    return;
                }
                final String oldParentUrl = this.getUrl(event.getOldParent());
                if (oldParentUrl == null) {
                    return;
                }
                final String newParentUrl = this.getUrl(event.getNewParent());
                if (newParentUrl == null) {
                    return;
                }
                NotNullLazyValue<Pair<String, String>> oldAndNewUrls = new NotNullLazyValue<Pair<String, String>>(){

                    @NotNull
                    protected Pair<String, String> compute() {
                        String newUrl = propertiesFile.getVirtualFile().getUrl();
                        return Pair.create((Object)(oldParentUrl + newUrl.substring(newParentUrl.length())), (Object)newUrl);
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty() && ResourceBundleManager.this.myState.getDissociatedFiles().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                }
                for (CustomResourceBundleState customResourceBundleState : ResourceBundleManager.this.myState.getCustomResourceBundles()) {
                    if (!customResourceBundleState.getFileUrls().remove(((Pair)oldAndNewUrls.getValue()).getFirst())) continue;
                    customResourceBundleState.getFileUrls().add((String)((Pair)oldAndNewUrls.getValue()).getSecond());
                    break;
                }
            }

            @Nullable
            private String getUrl(PsiElement element) {
                return !(element instanceof PsiDirectory) ? null : ((PsiDirectory)element).getVirtualFile().getUrl();
            }

            public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
                PsiElement child = event.getChild();
                if (!(child instanceof PsiFile)) {
                    if (child instanceof PsiDirectory) {
                        String deletedDirUrl = ((PsiDirectory)child).getVirtualFile().getUrl() + "/";
                        for (String dissociatedFileUrl : new SmartList(ResourceBundleManager.this.myState.getDissociatedFiles())) {
                            if (!dissociatedFileUrl.startsWith(deletedDirUrl)) continue;
                            ResourceBundleManager.this.myState.getDissociatedFiles().remove(dissociatedFileUrl);
                        }
                        for (CustomResourceBundleState customResourceBundleState : new SmartList(ResourceBundleManager.this.myState.getCustomResourceBundles())) {
                            for (String fileUrl : new ArrayList<String>(customResourceBundleState.getFileUrls())) {
                                if (!fileUrl.startsWith(deletedDirUrl)) continue;
                                customResourceBundleState.getFileUrls().remove(fileUrl);
                            }
                            if (customResourceBundleState.getFileUrls().size() >= 2) continue;
                            ResourceBundleManager.this.myState.getCustomResourceBundles().remove(customResourceBundleState);
                        }
                    }
                    return;
                }
                PsiFile psiFile = (PsiFile)child;
                if (!PropertiesImplUtil.canBePropertyFile(psiFile)) {
                    return;
                }
                final VirtualFile virtualFile = psiFile.getVirtualFile();
                NotNullLazyValue<String> url = new NotNullLazyValue<String>(){

                    @NotNull
                    protected String compute() {
                        return virtualFile.getUrl();
                    }
                };
                if (!ResourceBundleManager.this.myState.getDissociatedFiles().isEmpty()) {
                    ResourceBundleManager.this.myState.getDissociatedFiles().remove(url.getValue());
                }
                for (CustomResourceBundleState customResourceBundleState : new SmartList(ResourceBundleManager.this.myState.getCustomResourceBundles())) {
                    Set<String> urls = customResourceBundleState.getFileUrls();
                    if (!urls.remove(url.getValue())) continue;
                    if (urls.size() >= 2) break;
                    ResourceBundleManager.this.myState.getCustomResourceBundles().remove(customResourceBundleState);
                    break;
                }
            }
        });
    }

    public static ResourceBundleManager getInstance(Project project) {
        return (ResourceBundleManager)ServiceManager.getService((Project)project, ResourceBundleManager.class);
    }

    @Nullable
    public String getFullName(final @NotNull PropertiesFile propertiesFile) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

            public String compute() {
                PsiDirectory directory = propertiesFile.getParent();
                String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
                if (packageQualifiedName == null) {
                    return null;
                }
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                qName.append(ResourceBundleManager.this.getBaseName(propertiesFile.getContainingFile()));
                return qName.toString();
            }
        });
    }

    @NotNull
    public String getBaseName(@NotNull PsiFile file) {
        return this.getBaseName(file.getVirtualFile());
    }

    @NotNull
    private String getBaseName(@NotNull VirtualFile file) {
        CustomResourceBundleState customResourceBundle = this.getCustomResourceBundleState(file);
        if (customResourceBundle != null) {
            return customResourceBundle.getBaseName();
        }
        if (this.isDefaultDissociated(file)) {
            return file.getNameWithoutExtension();
        }
        return PropertiesUtil.getDefaultBaseName(file);
    }

    public void dissociateResourceBundle(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle instanceof CustomResourceBundle) {
            CustomResourceBundleState state = this.getCustomResourceBundleState(resourceBundle.getDefaultPropertiesFile().getVirtualFile());
            LOG.assertTrue(state != null);
            this.myState.getCustomResourceBundles().remove(state);
        } else {
            if (EmptyResourceBundle.getInstance() != resourceBundle) {
                ((ResourceBundleImpl)resourceBundle).invalidate();
            }
            for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                VirtualFile file = propertiesFile.getContainingFile().getVirtualFile();
                this.myState.getDissociatedFiles().add(file.getUrl());
            }
        }
    }

    public void combineToResourceBundle(@NotNull List<PropertiesFile> propertiesFiles, String baseName) {
        this.myState.getCustomResourceBundles().add(new CustomResourceBundleState().addAll(ContainerUtil.map(propertiesFiles, (Function)new Function<PropertiesFile, String>(){

            public String fun(PropertiesFile file) {
                return file.getVirtualFile().getUrl();
            }
        })).setBaseName(baseName));
    }

    @Nullable
    public CustomResourceBundle getCustomResourceBundle(@NotNull PropertiesFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        CustomResourceBundleState state = this.getCustomResourceBundleState(virtualFile);
        return state == null ? null : CustomResourceBundle.fromState(state, file.getProject());
    }

    public boolean isDefaultDissociated(@NotNull VirtualFile virtualFile) {
        if (this.myState.getDissociatedFiles().isEmpty() && this.myState.getCustomResourceBundles().isEmpty()) {
            return false;
        }
        String url = virtualFile.getUrl();
        return this.myState.getDissociatedFiles().contains(url) || this.getCustomResourceBundleState(virtualFile) != null;
    }

    @Nullable
    private CustomResourceBundleState getCustomResourceBundleState(@NotNull VirtualFile virtualFile) {
        if (this.myState.getCustomResourceBundles().isEmpty()) {
            return null;
        }
        String url = virtualFile.getUrl();
        for (CustomResourceBundleState customResourceBundleState : this.myState.getCustomResourceBundles()) {
            if (!customResourceBundleState.getFileUrls().contains(url)) continue;
            return customResourceBundleState;
        }
        return null;
    }

    @Nullable
    public ResourceBundleManagerState getState() {
        return this.myState.isEmpty() ? null : this.myState;
    }

    public void loadState(ResourceBundleManagerState state) {
        this.myState = state.removeNonExistentFiles();
    }
}

