/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleImpl
extends ResourceBundle {
    @NotNull
    private final PropertiesFile myDefaultPropertiesFile;
    private boolean myValid = true;

    public ResourceBundleImpl(@NotNull PropertiesFile defaultPropertiesFile) {
        this.myDefaultPropertiesFile = defaultPropertiesFile;
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        if (ResourceBundleManager.getInstance(this.getProject()).isDefaultDissociated(this.myDefaultPropertiesFile.getVirtualFile())) {
            return Collections.singletonList(this.myDefaultPropertiesFile);
        }
        PsiFile[] children = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return ResourceBundleImpl.this.myDefaultPropertiesFile.getParent().getFiles();
            }
        });
        String baseName = this.getBaseName();
        SmartList result = new SmartList();
        for (PsiFile file : children) {
            PropertiesFile propertiesFile;
            if (!file.isValid() || (propertiesFile = PropertiesImplUtil.getPropertiesFile(file)) == null || !Comparing.strEqual((String)PropertiesUtil.getDefaultBaseName(file.getVirtualFile()), (String)baseName)) continue;
            result.add(propertiesFile);
            if (propertiesFile.equals(this.myDefaultPropertiesFile) || !Comparing.equal((String)propertiesFile.getName(), (String)this.myDefaultPropertiesFile.getName())) continue;
            return Collections.singletonList(this.myDefaultPropertiesFile);
        }
        return result;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        return this.myDefaultPropertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        return ResourceBundleManager.getInstance(this.getProject()).getBaseName(this.myDefaultPropertiesFile.getContainingFile());
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        return this.myDefaultPropertiesFile.getParent().getVirtualFile();
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }
}

