/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PropertiesAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (!(element instanceof IProperty)) {
            return;
        }
        Property property = (Property)element;
        PropertiesFile propertiesFile = property.getPropertiesFile();
        List<IProperty> others = propertiesFile.findPropertiesByKey(property.getUnescapedKey());
        ASTNode keyNode = ((PropertyImpl)property).getKeyNode();
        if (others.size() != 1) {
            Annotation annotation = holder.createErrorAnnotation(keyNode, PropertiesBundle.message("duplicate.property.key.error.message", new Object[0]));
            annotation.registerFix(PropertiesQuickFixFactory.getInstance().createRemovePropertyFix(property));
        }
        PropertiesAnnotator.highlightTokens(property, keyNode, holder, new PropertiesHighlighter());
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode != null) {
            PropertiesAnnotator.highlightTokens(property, valueNode, holder, new PropertiesValueHighlighter());
        }
    }

    private static void highlightTokens(final Property property, ASTNode node, AnnotationHolder holder, PropertiesHighlighter highlighter) {
        Lexer lexer = highlighter.getHighlightingLexer();
        String s = node.getText();
        lexer.start((CharSequence)s);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            IElementType elementType = lexer.getTokenType();
            for (TextAttributesKey key : keys = highlighter.getTokenHighlights(elementType)) {
                Pair<String, HighlightSeverity> pair = PropertiesHighlighter.DISPLAY_NAMES.get(key);
                String displayName = (String)pair.getFirst();
                HighlightSeverity severity = (HighlightSeverity)pair.getSecond();
                if (severity == null) continue;
                int start = lexer.getTokenStart() + node.getTextRange().getStartOffset();
                int end = lexer.getTokenEnd() + node.getTextRange().getStartOffset();
                TextRange textRange = new TextRange(start, end);
                final Annotation annotation = severity == HighlightSeverity.WARNING ? holder.createWarningAnnotation(textRange, displayName) : (severity == HighlightSeverity.ERROR ? holder.createErrorAnnotation(textRange, displayName) : holder.createInfoAnnotation(textRange, displayName));
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
                annotation.setEnforcedTextAttributes(attributes);
                if (key != PropertiesHighlighter.PROPERTIES_INVALID_STRING_ESCAPE) continue;
                annotation.registerFix(new IntentionAction(){

                    @NotNull
                    public String getText() {
                        return PropertiesBundle.message("unescape", new Object[0]);
                    }

                    @NotNull
                    public String getFamilyName() {
                        return this.getText();
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (!property.isValid() || !property.getManager().isInProject((PsiElement)property)) {
                            return false;
                        }
                        String text = property.getPropertiesFile().getContainingFile().getText();
                        int startOffset = annotation.getStartOffset();
                        return text.length() > startOffset && text.charAt(startOffset) == '\\';
                    }

                    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
                        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                            return;
                        }
                        int offset = annotation.getStartOffset();
                        if (property.getPropertiesFile().getContainingFile().getText().charAt(offset) == '\\') {
                            editor.getDocument().deleteString(offset, offset + 1);
                        }
                    }

                    public boolean startInWriteAction() {
                        return true;
                    }
                });
            }
            lexer.advance();
        }
    }
}

