/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="custom-resource-bundle")
public class CustomResourceBundleState {
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="file", elementValueAttribute="value")
    public Set<String> myFileUrls = new HashSet();
    @Tag(value="base-name")
    public String myBaseName;

    @Transient
    @NotNull
    public String getBaseName() {
        return this.myBaseName;
    }

    public Set<String> getFileUrls() {
        return this.myFileUrls;
    }

    public List<VirtualFile> getFiles(final @NotNull VirtualFileManager manager) {
        return ContainerUtil.mapNotNull(this.getFileUrls(), (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String url) {
                return manager.findFileByUrl(url);
            }
        });
    }

    @Nullable
    public CustomResourceBundleState removeNonExistentFiles(final VirtualFileManager virtualFileManager) {
        List existentFiles = ContainerUtil.filter(this.myFileUrls, (Condition)new Condition<String>(){

            public boolean value(String url) {
                return virtualFileManager.findFileByUrl(url) != null;
            }
        });
        if (existentFiles.isEmpty()) {
            return null;
        }
        CustomResourceBundleState customResourceBundleState = new CustomResourceBundleState();
        customResourceBundleState.myFileUrls.addAll(existentFiles);
        customResourceBundleState.myBaseName = this.myBaseName;
        return customResourceBundleState;
    }

    public CustomResourceBundleState addAll(Collection<String> urls) {
        this.myFileUrls.addAll(urls);
        return this;
    }

    public CustomResourceBundleState setBaseName(String baseName) {
        this.myBaseName = baseName;
        return this;
    }
}

