/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.FileCheckingInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaCreatePropertyFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidPropertyKeyInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.PROPERTIES_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "UnresolvedPropertyKey";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return InvalidPropertyKeyInspection.checkElement((PsiElement)method, manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClassInitializer[] initializers = aClass.getInitializers();
        ArrayList result = new ArrayList();
        for (PsiClassInitializer initializer : initializers) {
            Object[] descriptors = InvalidPropertyKeyInspection.checkElement((PsiElement)initializer, manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
        return result.isEmpty() ? null : result.toArray(new ProblemDescriptor[result.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, result, (PsiElement)field.getInitializer());
        InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, result, (PsiElement)field.getModifierList());
        if (field instanceof PsiEnumConstant) {
            InvalidPropertyKeyInspection.appendProblems(manager, isOnTheFly, result, (PsiElement)((PsiEnumConstant)field).getArgumentList());
        }
        return result.isEmpty() ? null : result.toArray(new ProblemDescriptor[result.size()]);
    }

    private static void appendProblems(InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> result, PsiElement element) {
        ProblemDescriptor[] descriptors;
        if (element != null && (descriptors = InvalidPropertyKeyInspection.checkElement(element, manager, isOnTheFly)) != null) {
            Collections.addAll(result, descriptors);
        }
    }

    @Nullable
    private static ProblemDescriptor[] checkElement(PsiElement element, InspectionManager manager, boolean onTheFly) {
        UnresolvedPropertyVisitor visitor = new UnresolvedPropertyVisitor(manager, onTheFly);
        element.accept((PsiElementVisitor)visitor);
        List<ProblemDescriptor> problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        FileCheckingInspection[] fileCheckingInspections;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.invalidPropertyKeyInspectionTool");
        for (FileCheckingInspection obj : fileCheckingInspections = (FileCheckingInspection[])point.getExtensions()) {
            ProblemDescriptor[] descriptors = obj.checkFile(file, manager, isOnTheFly);
            if (descriptors == null) continue;
            return descriptors;
        }
        return null;
    }

    private static class UnresolvedPropertyVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final InspectionManager myManager;
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final boolean onTheFly;

        public UnresolvedPropertyVisitor(InspectionManager manager, boolean onTheFly) {
            this.myManager = manager;
            this.onTheFly = onTheFly;
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            PsiExpressionList argList = aClass.getArgumentList();
            if (argList != null) {
                argList.accept((PsiElementVisitor)this);
            }
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitField(PsiField field) {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement resolvedExpression = expression.resolve();
            if (!(resolvedExpression instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)resolvedExpression;
            PsiExpression initializer = field.getInitializer();
            if (initializer == null || !(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            if (!field.hasModifierProperty("final")) {
                return;
            }
            Object initializerValue = ((PsiLiteralExpression)initializer).getValue();
            if (!(initializerValue instanceof String)) {
                return;
            }
            String key = (String)initializerValue;
            this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, key);
        }

        private void visitPropertyKeyAnnotationParameter(PsiExpression expression, String key) {
            block6: {
                Ref resourceBundleName;
                block7: {
                    List propFiles;
                    block5: {
                        resourceBundleName = new Ref();
                        if (JavaI18nUtil.isValidPropertyReference(this.myManager.getProject(), expression, key, (Ref<String>)resourceBundleName)) break block5;
                        String bundleName = (String)resourceBundleName.get();
                        if (bundleName == null) break block6;
                        UnresolvedPropertyVisitor.appendPropertyKeyNotFoundProblem(bundleName, key, expression, this.myManager, this.myProblems, this.onTheFly);
                        break block6;
                    }
                    if (!(expression.getParent() instanceof PsiNameValuePair)) break block7;
                    PsiNameValuePair nvp = (PsiNameValuePair)expression.getParent();
                    if (!Comparing.equal((String)nvp.getName(), (String)"resourceBundle")) break block6;
                    PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)expression.getProject());
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
                    if (module != null && (propFiles = manager.findPropertiesFiles(module, key)).isEmpty()) {
                        String description = CodeInsightBundle.message((String)"inspection.invalid.resource.bundle.reference", (Object[])new Object[]{key});
                        ProblemDescriptor problem = this.myManager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, this.onTheFly);
                        this.myProblems.add(problem);
                    }
                    break block6;
                }
                if (expression.getParent() instanceof PsiExpressionList && expression.getParent().getParent() instanceof PsiMethodCallExpression) {
                    HashMap<String, Object> annotationParams = new HashMap<String, Object>();
                    annotationParams.put("resourceBundle", null);
                    if (!JavaI18nUtil.mustBePropertyKey(expression, annotationParams)) {
                        return;
                    }
                    SortedSet<Integer> paramsCount = JavaI18nUtil.getPropertyValueParamsCount(expression, (String)resourceBundleName.get());
                    if (paramsCount.isEmpty() || paramsCount.size() != 1 && resourceBundleName.get() == null) {
                        return;
                    }
                    int maxParamCount = paramsCount.last();
                    PsiExpressionList expressions = (PsiExpressionList)expression.getParent();
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expressions.getParent();
                    PsiMethod method = methodCall.resolveMethod();
                    PsiExpression[] args = expressions.getExpressions();
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] != expression) continue;
                        if (i + maxParamCount < args.length || method == null || method.getParameterList().getParametersCount() != i + 2 || !method.getParameterList().getParameters()[i + 1].isVarArgs() || UnresolvedPropertyVisitor.hasArrayTypeAt(i + 1, methodCall)) break;
                        this.myProblems.add(this.myManager.createProblemDescriptor((PsiElement)methodCall, CodeInsightBundle.message((String)"property.has.more.parameters.than.passed", (Object[])new Object[]{key, maxParamCount, args.length - i - 1}), this.onTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR));
                        break;
                    }
                }
            }
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            Object value = expression.getValue();
            if (!(value instanceof String)) {
                return;
            }
            String key = (String)value;
            if (UnresolvedPropertyVisitor.isComputablePropertyExpression((PsiExpression)expression)) {
                return;
            }
            this.visitPropertyKeyAnnotationParameter((PsiExpression)expression, key);
        }

        private static void appendPropertyKeyNotFoundProblem(@NotNull String bundleName, @NotNull String key, @NotNull PsiExpression expression, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean onTheFly) {
            String description = CodeInsightBundle.message((String)"inspection.unresolved.property.key.reference.message", (Object[])new Object[]{key});
            List<PropertiesFile> propertiesFiles = UnresolvedPropertyVisitor.filterNotInLibrary(expression.getProject(), I18nUtil.propertiesFilesByBundleName((String)bundleName, (PsiElement)expression));
            problems.add(manager.createProblemDescriptor((PsiElement)expression, description, (LocalQuickFix)(propertiesFiles.isEmpty() ? null : new JavaCreatePropertyFix((PsiElement)expression, key, propertiesFiles)), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly));
        }

        @NotNull
        private static List<PropertiesFile> filterNotInLibrary(@NotNull Project project, @NotNull List<PropertiesFile> propertiesFiles) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>(propertiesFiles.size());
            for (PropertiesFile file : propertiesFiles) {
                if (fileIndex.isInLibraryClasses(file.getVirtualFile()) || fileIndex.isInLibrarySource(file.getVirtualFile())) continue;
                result.add(file);
            }
            return result;
        }

        private static boolean hasArrayTypeAt(int i, PsiMethodCallExpression methodCall) {
            return methodCall != null && methodCall.getArgumentList().getExpressionTypes().length > i && methodCall.getArgumentList().getExpressionTypes()[i] instanceof PsiArrayType;
        }

        private static boolean isComputablePropertyExpression(PsiExpression expression) {
            while (expression != null && expression.getParent() instanceof PsiParenthesizedExpression) {
                expression = (PsiExpression)expression.getParent();
            }
            return expression != null && expression.getParent() instanceof PsiExpression;
        }

        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }
    }
}

