/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.writer.FieldSection;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

public class BuilderFieldPool
implements FieldSection<BuilderStringReference, BuilderTypeReference, BuilderFieldReference, BuilderField> {
    @Nonnull
    private final BuilderContext context;
    @Nonnull
    private final ConcurrentMap<FieldReference, BuilderFieldReference> internedItems = Maps.newConcurrentMap();

    BuilderFieldPool(@Nonnull BuilderContext context) {
        this.context = context;
    }

    @Nonnull
    BuilderFieldReference internField(@Nonnull String definingClass, String name, String type) {
        ImmutableFieldReference fieldReference = new ImmutableFieldReference(definingClass, name, type);
        return this.internField(fieldReference);
    }

    @Nonnull
    public BuilderFieldReference internField(@Nonnull FieldReference fieldReference) {
        BuilderFieldReference ret = (BuilderFieldReference)this.internedItems.get(fieldReference);
        if (ret != null) {
            return ret;
        }
        BuilderFieldReference dexPoolFieldReference = new BuilderFieldReference(this.context.typePool.internType(fieldReference.getDefiningClass()), this.context.stringPool.internString(fieldReference.getName()), this.context.typePool.internType(fieldReference.getType()));
        ret = this.internedItems.putIfAbsent(dexPoolFieldReference, dexPoolFieldReference);
        return ret == null ? dexPoolFieldReference : ret;
    }

    @Override
    @Nonnull
    public BuilderTypeReference getDefiningClass(@Nonnull BuilderFieldReference key) {
        return key.definingClass;
    }

    @Override
    @Nonnull
    public BuilderTypeReference getFieldType(@Nonnull BuilderFieldReference key) {
        return key.fieldType;
    }

    @Override
    @Nonnull
    public BuilderStringReference getName(@Nonnull BuilderFieldReference key) {
        return key.name;
    }

    @Override
    public int getFieldIndex(@Nonnull BuilderField builderField) {
        return builderField.fieldReference.getIndex();
    }

    @Override
    public int getItemIndex(@Nonnull BuilderFieldReference key) {
        return key.index;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderFieldReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderFieldReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderFieldReference key) {
                return key.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderFieldReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }
}

