/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterUtils;
import org.jf.dexlib2.rewriter.Rewriters;

public class MethodReferenceRewriter
implements Rewriter<MethodReference> {
    @Nonnull
    protected final Rewriters rewriters;

    public MethodReferenceRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public MethodReference rewrite(@Nonnull MethodReference methodReference) {
        return new RewrittenMethodReference(methodReference);
    }

    protected class RewrittenMethodReference
    extends BaseMethodReference {
        @Nonnull
        protected MethodReference methodReference;

        public RewrittenMethodReference(MethodReference methodReference) {
            this.methodReference = methodReference;
        }

        @Override
        @Nonnull
        public String getDefiningClass() {
            return MethodReferenceRewriter.this.rewriters.getTypeRewriter().rewrite(this.methodReference.getDefiningClass());
        }

        @Override
        @Nonnull
        public String getName() {
            return this.methodReference.getName();
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            return RewriterUtils.rewriteList(MethodReferenceRewriter.this.rewriters.getTypeRewriter(), Lists.transform(this.methodReference.getParameterTypes(), (Function)new Function<CharSequence, String>(){

                @Nonnull
                public String apply(CharSequence input) {
                    return ((Object)input).toString();
                }
            }));
        }

        @Override
        @Nonnull
        public String getReturnType() {
            return MethodReferenceRewriter.this.rewriters.getTypeRewriter().rewrite(this.methodReference.getReturnType());
        }
    }
}

