/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.jf.dexlib2.analysis.RegisterType;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.util.ExceptionWithContext;

public class AnalyzedInstruction
implements Comparable<AnalyzedInstruction> {
    protected Instruction instruction;
    protected final int instructionIndex;
    protected final TreeSet<AnalyzedInstruction> predecessors = new TreeSet();
    protected final LinkedList<AnalyzedInstruction> successors = new LinkedList();
    protected final RegisterType[] preRegisterMap;
    protected final RegisterType[] postRegisterMap;
    protected final Instruction originalInstruction;

    public AnalyzedInstruction(Instruction instruction, int instructionIndex, int registerCount) {
        this.instruction = instruction;
        this.originalInstruction = instruction;
        this.instructionIndex = instructionIndex;
        this.postRegisterMap = new RegisterType[registerCount];
        this.preRegisterMap = new RegisterType[registerCount];
        RegisterType unknown = RegisterType.getRegisterType((byte)0, null);
        for (int i = 0; i < registerCount; ++i) {
            this.preRegisterMap[i] = unknown;
            this.postRegisterMap[i] = unknown;
        }
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    public int getPredecessorCount() {
        return this.predecessors.size();
    }

    public SortedSet<AnalyzedInstruction> getPredecessors() {
        return Collections.unmodifiableSortedSet(this.predecessors);
    }

    protected boolean addPredecessor(AnalyzedInstruction predecessor) {
        return this.predecessors.add(predecessor);
    }

    protected void addSuccessor(AnalyzedInstruction successor) {
        this.successors.add(successor);
    }

    protected void setDeodexedInstruction(Instruction instruction) {
        assert (this.originalInstruction.getOpcode().odexOnly());
        this.instruction = instruction;
    }

    protected void restoreOdexedInstruction() {
        assert (this.originalInstruction.getOpcode().odexOnly());
        this.instruction = this.originalInstruction;
    }

    public int getSuccessorCount() {
        return this.successors.size();
    }

    public List<AnalyzedInstruction> getSuccesors() {
        return Collections.unmodifiableList(this.successors);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public Instruction getOriginalInstruction() {
        return this.originalInstruction;
    }

    public boolean isBeginningInstruction() {
        if (this.predecessors.size() == 0) {
            return false;
        }
        return this.predecessors.first().instructionIndex == -1;
    }

    protected boolean mergeRegister(int registerNumber, RegisterType registerType, BitSet verifiedInstructions) {
        assert (registerNumber >= 0 && registerNumber < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType oldRegisterType = this.preRegisterMap[registerNumber];
        RegisterType mergedRegisterType = oldRegisterType.merge(registerType);
        if (mergedRegisterType.equals(oldRegisterType)) {
            return false;
        }
        this.preRegisterMap[registerNumber] = mergedRegisterType;
        verifiedInstructions.clear(this.instructionIndex);
        if (!this.setsRegister(registerNumber)) {
            this.postRegisterMap[registerNumber] = mergedRegisterType;
            return true;
        }
        return false;
    }

    protected RegisterType mergePreRegisterTypeFromPredecessors(int registerNumber) {
        RegisterType mergedRegisterType = null;
        for (AnalyzedInstruction predecessor : this.predecessors) {
            RegisterType predecessorRegisterType = predecessor.postRegisterMap[registerNumber];
            assert (predecessorRegisterType != null);
            mergedRegisterType = predecessorRegisterType.merge(mergedRegisterType);
        }
        return mergedRegisterType;
    }

    protected boolean setPostRegisterType(int registerNumber, RegisterType registerType) {
        assert (registerNumber >= 0 && registerNumber < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType oldRegisterType = this.postRegisterMap[registerNumber];
        if (oldRegisterType.equals(registerType)) {
            return false;
        }
        this.postRegisterMap[registerNumber] = registerType;
        return true;
    }

    protected boolean isInvokeInit() {
        if (this.instruction == null || !this.instruction.getOpcode().canInitializeReference()) {
            return false;
        }
        ReferenceInstruction instruction = (ReferenceInstruction)this.instruction;
        Reference reference = instruction.getReference();
        if (reference instanceof MethodReference) {
            return ((MethodReference)reference).getName().equals("<init>");
        }
        return false;
    }

    public boolean setsRegister() {
        return this.instruction.getOpcode().setsRegister();
    }

    public boolean setsWideRegister() {
        return this.instruction.getOpcode().setsWideRegister();
    }

    public boolean setsRegister(int registerNumber) {
        if (this.isInvokeInit()) {
            int destinationRegister;
            if (this.instruction instanceof FiveRegisterInstruction) {
                destinationRegister = ((FiveRegisterInstruction)this.instruction).getRegisterC();
            } else {
                assert (this.instruction instanceof RegisterRangeInstruction);
                RegisterRangeInstruction rangeInstruction = (RegisterRangeInstruction)this.instruction;
                assert (rangeInstruction.getRegisterCount() > 0);
                destinationRegister = rangeInstruction.getStartRegister();
            }
            if (registerNumber == destinationRegister) {
                return true;
            }
            RegisterType preInstructionDestRegisterType = this.getPreInstructionRegisterType(registerNumber);
            if (preInstructionDestRegisterType.category != 16 && preInstructionDestRegisterType.category != 17) {
                return false;
            }
            return this.getPreInstructionRegisterType(registerNumber).equals(preInstructionDestRegisterType);
        }
        if (!this.setsRegister()) {
            return false;
        }
        int destinationRegister = this.getDestinationRegister();
        if (registerNumber == destinationRegister) {
            return true;
        }
        return this.setsWideRegister() && registerNumber == destinationRegister + 1;
    }

    public int getDestinationRegister() {
        if (!this.instruction.getOpcode().setsRegister()) {
            throw new ExceptionWithContext("Cannot call getDestinationRegister() for an instruction that doesn't store a value", new Object[0]);
        }
        return ((OneRegisterInstruction)this.instruction).getRegisterA();
    }

    public int getRegisterCount() {
        return this.postRegisterMap.length;
    }

    @Nonnull
    public RegisterType getPostInstructionRegisterType(int registerNumber) {
        return this.postRegisterMap[registerNumber];
    }

    @Nonnull
    public RegisterType getPreInstructionRegisterType(int registerNumber) {
        return this.preRegisterMap[registerNumber];
    }

    @Override
    public int compareTo(AnalyzedInstruction analyzedInstruction) {
        if (this.instructionIndex < analyzedInstruction.instructionIndex) {
            return -1;
        }
        if (this.instructionIndex == analyzedInstruction.instructionIndex) {
            return 0;
        }
        return 1;
    }
}

