/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import gnu.trove.TIntHashSet;
import org.jetbrains.annotations.NotNull;

public class PropertiesResourceBundleUtil {
    private static final TIntHashSet SYMBOLS_TO_ESCAPE = new TIntHashSet(new int[]{61, 58});
    private static final char ESCAPE_SYMBOL = '\\';

    @NotNull
    public static String fromPropertyValueToValueEditor(@NotNull String text) {
        StringBuilder buffer = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped && (i == text.length() - 1 || text.charAt(i + 1) != 'u' && text.charAt(i + 1) != 'U')) {
                escaped = true;
                continue;
            }
            if (escaped && c == 'n') {
                buffer.append('\\');
            }
            buffer.append(c);
            escaped = false;
        }
        return buffer.toString();
    }

    @NotNull
    public static String fromValueEditorToPropertyValue(@NotNull String text, char delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0 && (c == ' ' || c == '\t') || c == '\n' || delimiter == ' ' && SYMBOLS_TO_ESCAPE.contains((int)c)) {
                buffer.append('\\');
            } else if (c == '\\') {
                if (text.length() > i + 1) {
                    char nextChar = text.charAt(i + 1);
                    if (nextChar != 'n' && nextChar != 'u' && nextChar != 'U') {
                        buffer.append('\\');
                    }
                } else {
                    buffer.append('\\');
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

