/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleDeleteProvider
implements DeleteProvider {
    private static final Logger LOG = Logger.getInstance(ResourceBundleDeleteProvider.class);
    private static final Function<ResourceBundle, List<PropertiesFile>> MAPPER_RES_BUNDLE_TO_FILES = new Function<ResourceBundle, List<PropertiesFile>>(){

        public List<PropertiesFile> fun(ResourceBundle resourceBundle) {
            return resourceBundle.getPropertiesFiles();
        }
    };
    private static final Function<PropertiesFile, PsiElement> MAPPER_FILE_AS_PSI_ELEMENT = new Function<PropertiesFile, PsiElement>(){

        public PsiElement fun(PropertiesFile propertiesFile) {
            return propertiesFile.getContainingFile();
        }
    };

    public void deleteElement(@NotNull DataContext dataContext) {
        Object[] resourceBundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(dataContext);
        if (resourceBundles != null && resourceBundles.length != 0) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            LOG.assertTrue(project != null);
            new SafeDeleteHandler().invoke(project, (PsiElement[])ContainerUtil.map2Array((Collection)ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])resourceBundles, MAPPER_RES_BUNDLE_TO_FILES)), PsiElement.class, MAPPER_FILE_AS_PSI_ELEMENT), dataContext);
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null;
    }
}

