/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorInspection;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProjectProfileManagerImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleEditorInspectionPass {
    @Nullable
    public static InspectionPassInfo inspect(final @NotNull String key, ResourceBundle resourceBundle) {
        List properties = ContainerUtil.mapNotNull(resourceBundle.getPropertiesFiles(), (Function)new Function<PropertiesFile, IProperty>(){

            public IProperty fun(PropertiesFile propertiesFile) {
                return propertiesFile.findPropertyByKey(key);
            }
        });
        if (properties.isEmpty()) {
            return null;
        }
        IProperty property = (IProperty)properties.get(0);
        PsiElement representativeElement = property.getPsiElement();
        PsiFile representativeFile = representativeElement.getContainingFile();
        Project project = representativeElement.getProject();
        InspectionProfileWrapper profileToUse = InspectionProjectProfileManagerImpl.getInstanceImpl((Project)project).getProfileWrapper();
        PsiFile containingFile = representativeFile.getContainingFile();
        InspectionToolWrapper[] propertiesTools = profileToUse.getInspectionTools((PsiElement)containingFile);
        SmartList allDescriptors = new SmartList();
        TreeSet<HighlightInfoType> highlightTypes = new TreeSet<HighlightInfoType>(new Comparator<HighlightInfoType>(){

            @Override
            public int compare(HighlightInfoType o1, HighlightInfoType o2) {
                HighlightSeverity s1 = o1.getSeverity(null);
                HighlightSeverity s2 = o2.getSeverity(null);
                return Comparing.compare((Comparable)s1, (Comparable)s2);
            }
        });
        for (InspectionToolWrapper tool : propertiesTools) {
            ResourceBundleEditorInspection inspection;
            ResourceBundleEditorProblemDescriptor[] descriptors;
            HighlightDisplayKey toolKey;
            if (!(tool.getTool() instanceof ResourceBundleEditorInspection) || !profileToUse.isToolEnabled(toolKey = HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)containingFile) || (descriptors = (inspection = (ResourceBundleEditorInspection)tool.getTool()).checkPropertyGroup(properties, resourceBundle)) == null) continue;
            for (ResourceBundleEditorProblemDescriptor descriptor : descriptors) {
                QuickFix[] currentFixes = descriptor.getFixes();
                if (currentFixes != null) {
                    allDescriptors.add(Pair.create((Object)descriptor, (Object)toolKey));
                }
                HighlightSeverity severity = profileToUse.getInspectionProfile().getErrorLevel(toolKey, (PsiElement)containingFile).getSeverity();
                HighlightInfoType infoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)descriptor.getHighlightType(), (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)project));
                highlightTypes.add(infoType);
            }
        }
        return new InspectionPassInfo(allDescriptors.toArray(new Pair[allDescriptors.size()]), highlightTypes);
    }

    public static class InspectionPassInfo {
        private final Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] myDescriptors;
        private final SortedSet<HighlightInfoType> myHighlightTypes;

        public InspectionPassInfo(Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] descriptors, SortedSet<HighlightInfoType> types) {
            this.myDescriptors = descriptors;
            this.myHighlightTypes = types;
        }

        public Pair<ResourceBundleEditorProblemDescriptor, HighlightDisplayKey>[] getDescriptors() {
            return this.myDescriptors;
        }

        @Nullable
        public TextAttributes getTextAttributes(EditorColorsScheme scheme) {
            TextAttributes mixedAttributes = null;
            for (HighlightInfoType type : this.myHighlightTypes) {
                TextAttributes current = scheme.getAttributes(type.getAttributesKey());
                if (mixedAttributes == null) {
                    mixedAttributes = current;
                    continue;
                }
                mixedAttributes = TextAttributes.merge((TextAttributes)mixedAttributes, (TextAttributes)current);
            }
            return mixedAttributes;
        }
    }
}

