/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PropertiesAnchorizer {
    private static final Logger LOG = Logger.getInstance(PropertiesAnchorizer.class);
    private final Map<IProperty, PropertyAnchor> myAnchors = new HashMap();

    public PropertiesAnchorizer(Project project) {
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                PsiElement removed = event.getChild();
                if (removed instanceof IProperty) {
                    PropertiesAnchorizer.this.myAnchors.remove(removed);
                }
            }
        });
    }

    @NotNull
    public PropertyAnchor get(IProperty property) {
        PropertyAnchor anchor = this.myAnchors.get(property);
        LOG.assertTrue(anchor != null);
        return anchor;
    }

    public PropertyAnchor createOrUpdate(Collection<IProperty> properties) {
        LOG.assertTrue(!properties.isEmpty());
        SmartList propertiesWithoutAnchor = new SmartList();
        PropertyAnchor representativeAnchor = null;
        for (IProperty property : properties) {
            PropertyAnchor anchor = this.myAnchors.get(property);
            if (anchor == null) {
                propertiesWithoutAnchor.add(property);
                continue;
            }
            if (representativeAnchor != null) {
                LOG.assertTrue(representativeAnchor == anchor);
            }
            representativeAnchor = anchor;
        }
        if (representativeAnchor == null) {
            LOG.assertTrue(propertiesWithoutAnchor.size() == properties.size());
            representativeAnchor = new PropertyAnchor(properties);
        } else {
            representativeAnchor.addProperties((Collection)propertiesWithoutAnchor);
        }
        for (IProperty property : propertiesWithoutAnchor) {
            this.myAnchors.put(property, representativeAnchor);
        }
        return representativeAnchor;
    }

    public static final class PropertyAnchor {
        private final Collection<IProperty> myProperties;

        public PropertyAnchor(Collection<IProperty> properties) {
            this.myProperties = new ArrayList<IProperty>(properties);
        }

        @NotNull
        public String getName() {
            return this.getRepresentative().getName();
        }

        @NotNull
        public IProperty getRepresentative() {
            return (IProperty)ContainerUtil.getFirstItem(this.myProperties);
        }

        public String toString() {
            return "PropertyAnchor:" + this.getName();
        }

        private void addProperties(Collection<IProperty> properties) {
            this.myProperties.addAll(properties);
        }
    }
}

