/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class RemovePropertyFix
implements IntentionAction {
    private final Property myProperty;

    RemovePropertyFix(@NotNull Property origProperty) {
        this.myProperty = origProperty;
    }

    @NotNull
    public String getText() {
        return PropertiesBundle.message("remove.property.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return file != null && file.isValid() && this.myProperty.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myProperty);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        this.myProperty.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

