/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlightingLexer;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PropertiesHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    public static final TextAttributesKey PROPERTY_KEY;
    public static final TextAttributesKey PROPERTY_VALUE;
    public static final TextAttributesKey PROPERTY_COMMENT;
    public static final TextAttributesKey PROPERTY_KEY_VALUE_SEPARATOR;
    public static final TextAttributesKey PROPERTIES_VALID_STRING_ESCAPE;
    public static final TextAttributesKey PROPERTIES_INVALID_STRING_ESCAPE;
    public static final Map<TextAttributesKey, Pair<String, HighlightSeverity>> DISPLAY_NAMES;

    @NotNull
    public Lexer getHighlightingLexer() {
        return new PropertiesHighlightingLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        return SyntaxHighlighterBase.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
    }

    static {
        PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        PROPERTY_VALUE = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        PROPERTY_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        PROPERTY_KEY_VALUE_SEPARATOR = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.KEY_VALUE_SEPARATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        PROPERTIES_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        PROPERTIES_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROPERTIES.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        keys1 = new THashMap();
        keys2 = new THashMap();
        keys1.put(PropertiesTokenTypes.VALUE_CHARACTERS, PROPERTY_VALUE);
        keys1.put(PropertiesTokenTypes.END_OF_LINE_COMMENT, PROPERTY_COMMENT);
        keys1.put(PropertiesTokenTypes.KEY_CHARACTERS, PROPERTY_KEY);
        keys1.put(PropertiesTokenTypes.KEY_VALUE_SEPARATOR, PROPERTY_KEY_VALUE_SEPARATOR);
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, PROPERTIES_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, PROPERTIES_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, PROPERTIES_INVALID_STRING_ESCAPE);
        DISPLAY_NAMES = new THashMap(6);
        DISPLAY_NAMES.put(PROPERTY_KEY, (Pair<String, HighlightSeverity>)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.property.key", new Object[0]), null));
        DISPLAY_NAMES.put(PROPERTY_VALUE, (Pair<String, HighlightSeverity>)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.property.value", new Object[0]), null));
        DISPLAY_NAMES.put(PROPERTY_KEY_VALUE_SEPARATOR, (Pair<String, HighlightSeverity>)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.key.value.separator", new Object[0]), null));
        DISPLAY_NAMES.put(PROPERTY_COMMENT, (Pair<String, HighlightSeverity>)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.comment", new Object[0]), null));
        DISPLAY_NAMES.put(PROPERTIES_VALID_STRING_ESCAPE, (Pair<String, HighlightSeverity>)new Pair((Object)PropertiesBundle.message("options.properties.attribute.descriptor.valid.string.escape", new Object[0]), null));
        DISPLAY_NAMES.put(PROPERTIES_INVALID_STRING_ESCAPE, (Pair<String, HighlightSeverity>)Pair.create((Object)PropertiesBundle.message("options.properties.attribute.descriptor.invalid.string.escape", new Object[0]), (Object)HighlightSeverity.WARNING));
    }
}

