/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileType
extends LanguageFileType {
    public static final LanguageFileType INSTANCE = new PropertiesFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "properties";
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".properties";

    private PropertiesFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "Properties";
    }

    @NotNull
    public String getDescription() {
        return PropertiesBundle.message("properties.files.file.type.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Properties;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Charset charset = EncodingRegistry.getInstance().getDefaultCharsetForPropertiesFiles(file);
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset();
        }
        return charset.name();
    }
}

