/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    static ImageTransfer _instance = new ImageTransfer();
    static final String TIFF = OS.NSTIFFPboardType.getString();
    static final int TIFFID = ImageTransfer.registerType(TIFF);

    ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        ImageData imageData = (ImageData)object;
        Image image = new Image((Device)Display.getCurrent(), imageData);
        NSImage nSImage = image.handle;
        transferData.data = nSImage.TIFFRepresentation();
        image.dispose();
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSData nSData = (NSData)transferData.data;
        if (nSData.length() == 0L) {
            return null;
        }
        NSImage nSImage = (NSImage)new NSImage().alloc();
        nSImage.initWithData(nSData);
        Image image = Image.cocoa_new(Display.getCurrent(), 0, nSImage);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{TIFFID};
    }

    protected String[] getTypeNames() {
        return new String[]{TIFF};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

