/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationField;
import android.databinding.tool.reflection.annotation.AnnotationMethod;
import android.databinding.tool.util.L;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class AnnotationClass
extends ModelClass {
    final TypeMirror mTypeMirror;

    public AnnotationClass(TypeMirror typeMirror) {
        this.mTypeMirror = typeMirror;
    }

    @Override
    public String toJavaCode() {
        if (this.isIncomplete()) {
            return this.getCanonicalName();
        }
        return this.mTypeMirror.toString();
    }

    @Override
    public boolean isArray() {
        return this.mTypeMirror.getKind() == TypeKind.ARRAY;
    }

    @Override
    public AnnotationClass getComponentType() {
        TypeMirror component = null;
        if (this.isArray()) {
            component = ((ArrayType)this.mTypeMirror).getComponentType();
        } else {
            if (this.isList()) {
                for (ModelMethod method : this.getMethods("get", 1)) {
                    ModelClass parameter = method.getParameterTypes()[0];
                    if (!parameter.isInt() && !parameter.isLong()) continue;
                    ArrayList<ModelClass> parameters = new ArrayList<ModelClass>(1);
                    parameters.add(parameter);
                    return (AnnotationClass)method.getReturnType(parameters);
                }
                return null;
            }
            AnnotationClass mapClass = (AnnotationClass)ModelAnalyzer.getInstance().getMapType();
            DeclaredType mapType = this.findInterface(mapClass.mTypeMirror);
            if (mapType == null) {
                return null;
            }
            component = mapType.getTypeArguments().get(1);
        }
        return new AnnotationClass(component);
    }

    private DeclaredType findInterface(TypeMirror interfaceType) {
        Types typeUtil = AnnotationClass.getTypeUtils();
        TypeMirror foundInterface = null;
        if (typeUtil.isSameType(interfaceType, typeUtil.erasure(this.mTypeMirror))) {
            foundInterface = this.mTypeMirror;
        } else {
            ArrayList<? extends TypeMirror> toCheck = new ArrayList<TypeMirror>();
            toCheck.add(this.mTypeMirror);
            while (!toCheck.isEmpty()) {
                TypeMirror typeMirror = (TypeMirror)toCheck.remove(0);
                if (typeUtil.isSameType(interfaceType, typeUtil.erasure(typeMirror))) {
                    foundInterface = typeMirror;
                    break;
                }
                toCheck.addAll(typeUtil.directSupertypes(typeMirror));
            }
            if (foundInterface == null) {
                L.e((String)("Detected " + interfaceType + " type for " + this.mTypeMirror + ", but not able to find the implemented interface."), (Object[])new Object[0]);
                return null;
            }
        }
        if (foundInterface.getKind() != TypeKind.DECLARED) {
            L.e((String)("Found " + interfaceType + " type for " + this.mTypeMirror + ", but it isn't a declared type: " + foundInterface), (Object[])new Object[0]);
            return null;
        }
        return (DeclaredType)foundInterface;
    }

    @Override
    public boolean isNullable() {
        switch (this.mTypeMirror.getKind()) {
            case ARRAY: 
            case DECLARED: 
            case NULL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        switch (this.mTypeMirror.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case CHAR: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBoolean() {
        return this.mTypeMirror.getKind() == TypeKind.BOOLEAN;
    }

    @Override
    public boolean isChar() {
        return this.mTypeMirror.getKind() == TypeKind.CHAR;
    }

    @Override
    public boolean isByte() {
        return this.mTypeMirror.getKind() == TypeKind.BYTE;
    }

    @Override
    public boolean isShort() {
        return this.mTypeMirror.getKind() == TypeKind.SHORT;
    }

    @Override
    public boolean isInt() {
        return this.mTypeMirror.getKind() == TypeKind.INT;
    }

    @Override
    public boolean isLong() {
        return this.mTypeMirror.getKind() == TypeKind.LONG;
    }

    @Override
    public boolean isFloat() {
        return this.mTypeMirror.getKind() == TypeKind.FLOAT;
    }

    @Override
    public boolean isDouble() {
        return this.mTypeMirror.getKind() == TypeKind.DOUBLE;
    }

    @Override
    public boolean isGeneric() {
        boolean isGeneric = false;
        if (this.mTypeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)this.mTypeMirror;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            isGeneric = typeArguments != null && !typeArguments.isEmpty();
        }
        return isGeneric;
    }

    @Override
    public int getMinApi() {
        if (this.mTypeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)this.mTypeMirror;
            List<? extends AnnotationMirror> annotations = AnnotationClass.getElementUtils().getAllAnnotationMirrors(declaredType.asElement());
            TypeElement targetApi = AnnotationClass.getElementUtils().getTypeElement("android.annotation.TargetApi");
            TypeMirror targetApiType = targetApi.asType();
            Types typeUtils = AnnotationClass.getTypeUtils();
            for (AnnotationMirror annotationMirror : annotations) {
                Iterator<? extends AnnotationValue> iterator;
                if (!typeUtils.isAssignable(annotationMirror.getAnnotationType(), targetApiType) || !(iterator = annotationMirror.getElementValues().values().iterator()).hasNext()) continue;
                AnnotationValue value = iterator.next();
                return (Integer)value.getValue();
            }
        }
        return super.getMinApi();
    }

    @Override
    public List<ModelClass> getTypeArguments() {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        ArrayList<AnnotationClass> types = null;
        if (this.mTypeMirror.getKind() == TypeKind.DECLARED && (typeArguments = (declaredType = (DeclaredType)this.mTypeMirror).getTypeArguments()) != null && !typeArguments.isEmpty()) {
            types = new ArrayList<AnnotationClass>();
            for (TypeMirror typeMirror : typeArguments) {
                types.add(new AnnotationClass(typeMirror));
            }
        }
        return types;
    }

    @Override
    public boolean isTypeVar() {
        return this.mTypeMirror.getKind() == TypeKind.TYPEVAR;
    }

    @Override
    public boolean isWildcard() {
        return this.mTypeMirror.getKind() == TypeKind.WILDCARD;
    }

    @Override
    public boolean isInterface() {
        return this.mTypeMirror.getKind() == TypeKind.DECLARED && ((DeclaredType)this.mTypeMirror).asElement().getKind() == ElementKind.INTERFACE;
    }

    @Override
    public boolean isVoid() {
        return this.mTypeMirror.getKind() == TypeKind.VOID;
    }

    @Override
    public AnnotationClass unbox() {
        if (!this.isNullable()) {
            return this;
        }
        try {
            return new AnnotationClass(AnnotationClass.getTypeUtils().unboxedType(this.mTypeMirror));
        }
        catch (IllegalArgumentException e) {
            return this;
        }
    }

    @Override
    public AnnotationClass box() {
        if (!this.isPrimitive()) {
            return this;
        }
        return new AnnotationClass(AnnotationClass.getTypeUtils().boxedClass((PrimitiveType)this.mTypeMirror).asType());
    }

    @Override
    public boolean isAssignableFrom(ModelClass that) {
        ModelClass other;
        for (other = that; other != null && !(other instanceof AnnotationClass); other = other.getSuperclass()) {
        }
        if (other == null) {
            return false;
        }
        if (this.equals(other)) {
            return true;
        }
        AnnotationClass thatAnnotationClass = (AnnotationClass)other;
        return AnnotationClass.getTypeUtils().isAssignable(thatAnnotationClass.mTypeMirror, this.mTypeMirror);
    }

    @Override
    public ModelMethod[] getDeclaredMethods() {
        ModelMethod[] declaredMethods;
        if (this.mTypeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)this.mTypeMirror;
            Elements elementUtils = AnnotationClass.getElementUtils();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            List<? extends Element> members = elementUtils.getAllMembers(typeElement);
            List<ExecutableElement> methods = ElementFilter.methodsIn(members);
            declaredMethods = new ModelMethod[methods.size()];
            for (int i = 0; i < declaredMethods.length; ++i) {
                declaredMethods[i] = new AnnotationMethod(declaredType, methods.get(i));
            }
        } else {
            declaredMethods = new ModelMethod[]{};
        }
        return declaredMethods;
    }

    @Override
    public AnnotationClass getSuperclass() {
        DeclaredType declaredType;
        TypeElement typeElement;
        TypeMirror superClass;
        if (this.mTypeMirror.getKind() == TypeKind.DECLARED && (superClass = (typeElement = (TypeElement)(declaredType = (DeclaredType)this.mTypeMirror).asElement()).getSuperclass()).getKind() == TypeKind.DECLARED) {
            return new AnnotationClass(superClass);
        }
        return null;
    }

    @Override
    public String getCanonicalName() {
        return AnnotationClass.getTypeUtils().erasure(this.mTypeMirror).toString();
    }

    @Override
    public ModelClass erasure() {
        TypeMirror erasure = AnnotationClass.getTypeUtils().erasure(this.mTypeMirror);
        if (erasure == this.mTypeMirror) {
            return this;
        }
        return new AnnotationClass(erasure);
    }

    @Override
    public String getJniDescription() {
        return TypeUtil.getInstance().getDescription(this);
    }

    @Override
    protected ModelField[] getDeclaredFields() {
        ModelField[] declaredFields;
        if (this.mTypeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)this.mTypeMirror;
            Elements elementUtils = AnnotationClass.getElementUtils();
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            List<? extends Element> members = elementUtils.getAllMembers(typeElement);
            List<VariableElement> fields = ElementFilter.fieldsIn(members);
            declaredFields = new ModelField[fields.size()];
            for (int i = 0; i < declaredFields.length; ++i) {
                declaredFields[i] = new AnnotationField(typeElement, fields.get(i));
            }
        } else {
            declaredFields = new ModelField[]{};
        }
        return declaredFields;
    }

    private static Types getTypeUtils() {
        return AnnotationAnalyzer.get().mProcessingEnv.getTypeUtils();
    }

    private static Elements getElementUtils() {
        return AnnotationAnalyzer.get().mProcessingEnv.getElementUtils();
    }

    public String toString() {
        return this.mTypeMirror.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotationClass) {
            return AnnotationClass.getTypeUtils().isSameType(this.mTypeMirror, ((AnnotationClass)obj).mTypeMirror);
        }
        return false;
    }

    public int hashCode() {
        return this.mTypeMirror.toString().hashCode();
    }
}

