/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.plugins.announce.Announcer;
import org.gradle.api.plugins.announce.internal.AnnouncerUnavailableException;
import org.gradle.api.plugins.announce.internal.IconProvider;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecSpec;

public class NotifySend
implements Announcer {
    private final IconProvider iconProvider;
    private final ProcessOperations processOperations;

    public NotifySend(ProcessOperations processOperations, IconProvider iconProvider) {
        this.processOperations = processOperations;
        this.iconProvider = iconProvider;
    }

    public void send(final String title, final String message) {
        final File exe = OperatingSystem.current().findInPath("notify-send");
        if (exe == null) {
            throw new AnnouncerUnavailableException("Could not find 'notify-send' in the path.");
        }
        this.processOperations.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.executable((Object)exe);
                File icon = NotifySend.this.iconProvider.getIcon(32, 32);
                if (icon != null) {
                    execSpec.args(new Object[]{"-i", icon.getAbsolutePath()});
                }
                execSpec.args(new Object[]{"--hint=int:transient:1"});
                execSpec.args(new Object[]{title, message});
            }
        });
    }
}

