/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import java.util.regex.Pattern;

public class Symbol {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^([a-z_][a-z0-9_]*\\.)*");
    public final String qualifiedName;
    public final String packageName;
    public final String symbolName;

    public Symbol(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        String[] splits = PACKAGE_PATTERN.split(qualifiedName);
        if (splits.length > 1) {
            this.symbolName = splits[1];
            int packageLength = qualifiedName.length() - this.symbolName.length() - 1;
            this.packageName = qualifiedName.substring(0, packageLength);
        } else {
            this.packageName = "";
            this.symbolName = qualifiedName;
        }
    }

    public boolean isQualified() {
        return !this.packageName.isEmpty();
    }

    public String toString() {
        return String.format("{Symbol: %s, Package: %s}", this.symbolName, this.packageName);
    }
}

