/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import icons.EditorconfigIcons;
import java.awt.Color;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

public class EditorConfigNotifierProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"editor.config.notification.panel");
    private static final String EDITOR_CONFIG_ACCEPTED = "editor.config.accepted";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        final Project project = ((TextEditor)fileEditor).getEditor().getProject();
        final CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        if (!Utils.isEnabled(settings) || PropertiesComponent.getInstance((Project)project).getBoolean(EDITOR_CONFIG_ACCEPTED)) {
            return null;
        }
        List<EditorConfig.OutPair> pairs = SettingsProviderComponent.getInstance().getOutPairs(project, Utils.getFilePath(project, file));
        if (!pairs.isEmpty()) {
            EditorNotificationPanel panel = new EditorNotificationPanel(){

                public Color getBackground() {
                    return LightColors.GREEN;
                }
            }.text("EditorConfig is overriding Code Style settings for this file").icon(EditorconfigIcons.Editorconfig);
            panel.createActionLabel("OK", new Runnable(){

                @Override
                public void run() {
                    PropertiesComponent.getInstance((Project)project).setValue(EditorConfigNotifierProvider.EDITOR_CONFIG_ACCEPTED, true);
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }
            });
            panel.createActionLabel("Disable EditorConfig support", new Runnable(){

                @Override
                public void run() {
                    ((EditorConfigSettings)settings.getCustomSettings(EditorConfigSettings.class)).ENABLED = false;
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }
            });
            return panel;
        }
        return null;
    }
}

