/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.builder.core.AaptPackageProcessBuilder;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class GenerateSplitAbiRes
extends BaseTask {
    private String applicationId;
    private String outputBaseName;
    private Set<String> splits;
    private File outputDirectory;
    private boolean debuggable;
    private AaptOptions aaptOptions;
    private ApkVariantOutputData variantOutputData;

    @OutputFiles
    public List<File> getOutputFiles() {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (String split : this.getSplits()) {
            outputFiles.add(this.getOutputFileForSplit(split));
        }
        return outputFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void doFullTaskAction() throws IOException, InterruptedException, ProcessException {
        for (String split : this.getSplits()) {
            String resPackageFileName = this.getOutputFileForSplit(split).getAbsolutePath();
            File tmpDirectory = new File(this.getOutputDirectory(), this.getOutputBaseName());
            tmpDirectory.mkdirs();
            File tmpFile = new File(tmpDirectory, "AndroidManifest.xml");
            String versionNameToUse = this.getVersionName();
            if (versionNameToUse == null) {
                versionNameToUse = String.valueOf(this.getVersionCode());
            }
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8");
            try {
                String splitName = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'.')).negate().replaceFrom((CharSequence)(split + "_" + this.getOutputBaseName()), '_');
                fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + this.getApplicationId() + "\"\n" + "      android:versionCode=\"" + this.getVersionCode() + "\"\n" + "      android:versionName=\"" + versionNameToUse + "\"\n" + "      split=\"lib_" + splitName + "\">\n" + "       <uses-sdk android:minSdkVersion=\"21\"/>\n" + "</manifest> ");
                fileWriter.flush();
            }
            finally {
                fileWriter.close();
            }
            AaptPackageProcessBuilder aaptPackageCommandBuilder = new AaptPackageProcessBuilder(tmpFile, (com.android.builder.model.AaptOptions)this.getAaptOptions()).setDebuggable(this.isDebuggable()).setResPackageOutput(resPackageFileName);
            this.getBuilder().processResources(aaptPackageCommandBuilder, false, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
        }
    }

    private File getOutputFileForSplit(String split) {
        return new File(this.getOutputDirectory(), "resources-" + this.getOutputBaseName() + "-" + split + ".ap_");
    }

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Input
    public int getVersionCode() {
        return this.variantOutputData.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.variantOutputData.getVersionName();
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    public void setOutputBaseName(String outputBaseName) {
        this.outputBaseName = outputBaseName;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    public void setSplits(Set<String> splits) {
        this.splits = splits;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateSplitAbiRes> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "SplitAbiRes");
        }

        @Override
        public Class<GenerateSplitAbiRes> getType() {
            return GenerateSplitAbiRes.class;
        }

        @Override
        public void execute(GenerateSplitAbiRes generateSplitAbiRes) {
            final GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
            generateSplitAbiRes.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            generateSplitAbiRes.setVariantName(config.getFullName());
            generateSplitAbiRes.setOutputDirectory(this.scope.getGenerateSplitAbiResOutputDirectory());
            generateSplitAbiRes.setSplits((Set<String>)filters);
            generateSplitAbiRes.setOutputBaseName(config.getBaseName());
            generateSplitAbiRes.setApplicationId(config.getApplicationId());
            generateSplitAbiRes.variantOutputData = (ApkVariantOutputData)this.scope.getVariantData().getOutputs().get(0);
            ConventionMappingHelper.map((Task)generateSplitAbiRes, "debuggable", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return config.getBuildType().isDebuggable();
                }
            });
            ConventionMappingHelper.map((Task)generateSplitAbiRes, "aaptOptions", new Callable<AaptOptions>(){

                @Override
                public AaptOptions call() throws Exception {
                    return ConfigAction.this.scope.getGlobalScope().getExtension().getAaptOptions();
                }
            });
        }
    }
}

