/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.parser.FilterSpecification;
import com.android.utils.AsmUtils;
import com.android.utils.Pair;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class ShrinkerLogger {
    private final List<FilterSpecification> mDontWarnSpecs;
    private final Logger mLogger;
    private final Set<Pair<String, String>> mWarningsEmitted;

    public ShrinkerLogger(List<FilterSpecification> dontWarnSpecs, Logger logger) {
        this.mDontWarnSpecs = dontWarnSpecs;
        this.mLogger = logger;
        this.mWarningsEmitted = Sets.newHashSet();
    }

    synchronized void invalidClassReference(String from, String to) {
        if (from.contains(".")) {
            from = AsmUtils.getClassName((String)from);
        }
        if (this.mWarningsEmitted.contains(Pair.of((Object)from, (Object)to))) {
            return;
        }
        for (FilterSpecification dontWarnSpec : this.mDontWarnSpecs) {
            if (!dontWarnSpec.matches(from) && !dontWarnSpec.matches(to)) continue;
            return;
        }
        this.mWarningsEmitted.add((Pair<String, String>)Pair.of((Object)from, (Object)to));
        this.mLogger.warn("{} references unknown class: {}", (Object)from, (Object)to);
    }

    synchronized void invalidMemberReference(String from, String to) {
        if (this.mWarningsEmitted.contains(Pair.of((Object)from, (Object)to))) {
            return;
        }
        String fromClassName = from.contains(".") ? AsmUtils.getClassName((String)from) : from;
        String toClassName = AsmUtils.getClassName((String)to);
        for (FilterSpecification dontWarnSpec : this.mDontWarnSpecs) {
            if (!dontWarnSpec.matches(fromClassName) && !dontWarnSpec.matches(toClassName)) continue;
            return;
        }
        this.mWarningsEmitted.add((Pair<String, String>)Pair.of((Object)from, (Object)to));
        this.mLogger.warn("{} references unknown class member: {}", (Object)from, (Object)to);
    }

    public int getWarningsCount() {
        return this.mWarningsEmitted.size();
    }
}

