/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;

@ParallelizableTask
public class AndroidReportTask
extends DefaultTask
implements AndroidTestTask {
    private final List<AndroidTestTask> subTasks = Lists.newArrayList();
    private ReportType reportType;
    private boolean ignoreFailures;
    private boolean testFailed;
    private File reportsDir;
    private File resultsDir;

    @OutputDirectory
    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    @Override
    @OutputDirectory
    public File getResultsDir() {
        return this.resultsDir;
    }

    public void setResultsDir(File resultsDir) {
        this.resultsDir = resultsDir;
    }

    @Override
    public boolean getTestFailed() {
        return this.testFailed;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public void addTask(AndroidTestTask task) {
        this.subTasks.add(task);
        this.dependsOn(new Object[]{task});
    }

    @InputFiles
    public List<File> getResultInputs() {
        ArrayList list = Lists.newArrayList();
        for (AndroidTestTask task : this.subTasks) {
            list.add(task.getResultsDir());
        }
        return list;
    }

    public void setWillRun() {
        for (AndroidTestTask task : this.subTasks) {
            task.setIgnoreFailures(true);
        }
    }

    @TaskAction
    public void createReport() throws IOException {
        File resultsOutDir = this.getResultsDir();
        File reportOutDir = this.getReportsDir();
        FileUtils.emptyFolder((File)resultsOutDir);
        FileUtils.emptyFolder((File)reportOutDir);
        this.copyResults(resultsOutDir);
        TestReport report = new TestReport(this.reportType, resultsOutDir, reportOutDir);
        report.generateReport();
        for (AndroidTestTask task : this.subTasks) {
            if (!task.getTestFailed()) continue;
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
                break;
            }
            throw new GradleException(message);
        }
    }

    private void copyResults(File reportOutDir) throws IOException {
        List<File> inputs = this.getResultInputs();
        for (File input : inputs) {
            File[] children = input.listFiles();
            if (children == null) continue;
            for (File child : children) {
                FileUtils.copy((File)child, (File)reportOutDir);
            }
        }
    }
}

