/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.LibraryImpl;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AndroidLibraryImpl
extends LibraryImpl
implements AndroidLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String project;
    private final String variant;
    private final File bundle;
    private final File folder;
    private final File manifest;
    private final File jarFile;
    private final Collection<File> localJars;
    private final File resFolder;
    private final File assetsFolder;
    private final File jniFolder;
    private final File aidlFolder;
    private final File renderscriptFolder;
    private final File proguardRules;
    private final File lintJar;
    private final File annotations;
    private final File publicResources;
    private final List<AndroidLibrary> dependencies;
    private final boolean isOptional;

    AndroidLibraryImpl(LibraryDependency libraryDependency, List<AndroidLibrary> dependencies, Collection<File> localJarOverride, String project, String variant, MavenCoordinates requestedCoordinates, MavenCoordinates resolvedCoordinates) {
        super(requestedCoordinates, resolvedCoordinates);
        this.dependencies = dependencies;
        this.bundle = libraryDependency.getBundle();
        this.folder = libraryDependency.getFolder();
        this.manifest = libraryDependency.getManifest();
        this.jarFile = libraryDependency.getJarFile();
        this.localJars = Lists.newArrayList(localJarOverride);
        this.resFolder = libraryDependency.getResFolder();
        this.assetsFolder = libraryDependency.getAssetsFolder();
        this.jniFolder = libraryDependency.getJniFolder();
        this.aidlFolder = libraryDependency.getAidlFolder();
        this.renderscriptFolder = libraryDependency.getRenderscriptFolder();
        this.proguardRules = libraryDependency.getProguardRules();
        this.lintJar = libraryDependency.getLintJar();
        this.annotations = libraryDependency.getExternalAnnotations();
        this.publicResources = libraryDependency.getPublicResources();
        this.isOptional = libraryDependency.isOptional();
        this.project = project;
        this.variant = variant;
    }

    public String getProject() {
        return this.project;
    }

    public String getProjectVariant() {
        return this.variant;
    }

    public File getBundle() {
        return this.bundle;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.dependencies;
    }

    public File getManifest() {
        return this.manifest;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public Collection<File> getLocalJars() {
        return this.localJars;
    }

    public File getResFolder() {
        return this.resFolder;
    }

    public File getAssetsFolder() {
        return this.assetsFolder;
    }

    public File getJniFolder() {
        return this.jniFolder;
    }

    public File getAidlFolder() {
        return this.aidlFolder;
    }

    public File getRenderscriptFolder() {
        return this.renderscriptFolder;
    }

    public File getProguardRules() {
        return this.proguardRules;
    }

    public File getLintJar() {
        return this.lintJar;
    }

    public File getExternalAnnotations() {
        return this.annotations;
    }

    public File getPublicResources() {
        return this.publicResources;
    }

    public boolean isOptional() {
        return this.isOptional;
    }
}

